/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;
import net.silentchaos512.scalinghealth.entity.EntityBlightFire;
import net.silentchaos512.scalinghealth.event.BlightHandler;
import net.silentchaos512.scalinghealth.event.PlayerBonusRegenHandler;
import net.silentchaos512.scalinghealth.lib.EnumAreaDifficultyMode;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;
import org.lwjgl.opengl.GL11;

public class ScalingHealthClientEvents {
    @SubscribeEvent
    public void renderTick(RenderGameOverlayEvent.Post event) {
        if (Minecraft.func_71410_x().field_71441_e == null || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!ConfigScalingHealth.DEBUG_MODE) {
            return;
        }
        ScaledResolution res = event.getResolution();
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        FontRenderer fontRender = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushMatrix();
        float scale = 0.6f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        String text = this.getDebugText();
        int y = 3;
        for (String line : text.split("\n")) {
            String[] array = line.split("=");
            if (array.length == 2) {
                fontRender.func_78276_b(array[0].trim(), 3, y, 0xFFFFFF);
                fontRender.func_78276_b(array[1].trim(), 90, y, 0xFFFFFF);
            } else {
                fontRender.func_78276_b(line, 3, y, 0xFFFFFF);
            }
            y += 10;
        }
        GL11.glPopMatrix();
    }

    private String getDebugText() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get((EntityPlayer)player);
        EnumAreaDifficultyMode areaMode = ConfigScalingHealth.AREA_DIFFICULTY_MODE;
        if (data == null) {
            return "Player data is null!";
        }
        String ret = "";
        ret = ret + String.format("Area Difficulty = %.4f (%s)\n", areaMode.getAreaDifficulty((World)world, player.func_180425_c()), areaMode.name());
        ret = ret + String.format("Player Difficulty = %.4f\n", data.getDifficulty());
        ret = ret + "Player Health = " + player.func_110143_aJ() + " / " + player.func_110138_aP() + "\n";
        int regenTimer = PlayerBonusRegenHandler.INSTANCE.getTimerForPlayer((EntityPlayer)player);
        ret = ret + String.format("Regen Timer = %d (%ds)", regenTimer, regenTimer / 20) + "\n";
        ret = ret + String.format("Food = %d (%.2f)", player.func_71024_bL().func_75116_a(), Float.valueOf(player.func_71024_bL().func_75115_e())) + "\n";
        int blightCount = world.func_175644_a(EntityLivingBase.class, e -> BlightHandler.isBlight(e)).size();
        int blightFires = world.func_175644_a(EntityBlightFire.class, e -> true).size();
        ret = ret + String.format("Blights (Fires) = %d (%d)", blightCount, blightFires);
        return ret;
    }
}

