/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;
import net.silentchaos512.scalinghealth.network.NetworkHandler;
import net.silentchaos512.scalinghealth.network.message.MessageDataSync;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;

public class SHPlayerDataHandler {
    public static final String NBT_ROOT = "scalinghealth_data";
    private static Map<Integer, PlayerData> playerData = new HashMap<Integer, PlayerData>();

    public static PlayerData get(EntityPlayer player) {
        int key = SHPlayerDataHandler.getKey(player);
        if (!playerData.containsKey(key)) {
            playerData.put(key, new PlayerData(player));
        }
        PlayerData data = playerData.get(key);
        if (data.playerWR.get() != player) {
            NBTTagCompound tags = new NBTTagCompound();
            data.writeToNBT(tags);
            playerData.remove(key);
            data = SHPlayerDataHandler.get(player);
            data.readFromNBT(tags);
        }
        return data;
    }

    public static void cleanup() {
        ArrayList<Integer> remove = new ArrayList<Integer>();
        for (int i : playerData.keySet()) {
            PlayerData d = playerData.get(i);
            if (d == null || d.playerWR.get() != null) continue;
            remove.add(i);
        }
        for (int i : remove) {
            playerData.remove(i);
        }
    }

    private static int getKey(EntityPlayer player) {
        return player.hashCode() << 1 + (player.field_70170_p.field_72995_K ? 1 : 0);
    }

    public static NBTTagCompound getDataCompoundForPlayer(EntityPlayer player) {
        NBTTagCompound persistentData;
        NBTTagCompound forgeData = player.getEntityData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(persistentData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b(NBT_ROOT)) {
            persistentData.func_74782_a(NBT_ROOT, (NBTBase)new NBTTagCompound());
        }
        return persistentData.func_74775_l(NBT_ROOT);
    }

    public static class PlayerData {
        public static final String NBT_DIFFICULTY = "difficulty";
        public static final String NBT_HEALTH = "health";
        public static final String NBT_MAX_HEALTH = "max_health";
        double difficulty = 0.0;
        float health = 20.0f;
        float maxHealth = ConfigScalingHealth.PLAYER_STARTING_HEALTH;
        public WeakReference<EntityPlayer> playerWR;
        private final boolean client;
        private int lastPosX = 0;
        private int lastPosY = 0;
        private int lastPosZ = 0;

        public PlayerData(EntityPlayer player) {
            this.playerWR = new WeakReference<EntityPlayer>(player);
            this.client = player.field_70170_p.field_72995_K;
            this.load();
        }

        public double getDifficulty() {
            return this.difficulty;
        }

        public void setDifficulty(double value) {
            this.difficulty = MathHelper.func_151237_a((double)value, (double)0.0, (double)ConfigScalingHealth.DIFFICULTY_MAX);
        }

        public void incrementDifficulty(double amount) {
            this.setDifficulty(this.difficulty + amount);
        }

        public float getHealth() {
            return this.health;
        }

        public float getMaxHealth() {
            if (this.maxHealth < 2.0f) {
                this.maxHealth = ConfigScalingHealth.PLAYER_STARTING_HEALTH;
            }
            return this.maxHealth;
        }

        public void setMaxHealth(float value) {
            int configMax = ConfigScalingHealth.PLAYER_HEALTH_MAX;
            configMax = configMax <= 0 ? Integer.MAX_VALUE : configMax;
            this.maxHealth = MathHelper.func_76131_a((float)value, (float)2.0f, (float)configMax);
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            if (player != null) {
                ModifierHandler.setMaxHealth((EntityLivingBase)player, this.maxHealth, 0);
            }
            this.save();
            this.sendUpdateMessage();
        }

        public void incrementMaxHealth(float amount) {
            this.setMaxHealth(this.maxHealth + amount);
            EntityPlayer player = (EntityPlayer)this.playerWR.get();
            if (player != null) {
                player.func_70691_i(amount);
            }
        }

        private void tick() {
            if (!this.client) {
                EntityPlayer player = (EntityPlayer)this.playerWR.get();
                if (player == null) {
                    return;
                }
                if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                    float amount = ConfigScalingHealth.DIFFICULTY_PER_SECOND;
                    if (this.lastPosX == (int)player.field_70165_t && this.lastPosZ == (int)player.field_70161_v) {
                        amount *= ConfigScalingHealth.DIFFICULTY_IDLE_MULTI;
                    }
                    this.incrementDifficulty(amount);
                    this.lastPosX = (int)player.field_70165_t;
                    this.lastPosY = (int)player.field_70163_u;
                    this.lastPosZ = (int)player.field_70161_v;
                }
                if (player.field_70170_p.func_82737_E() % (long)ConfigScalingHealth.PACKET_DELAY == 0L) {
                    this.health = player.func_110143_aJ();
                    this.save();
                    this.sendUpdateMessage();
                }
            }
        }

        private void sendUpdateMessage() {
            if (!this.client) {
                EntityPlayer player = (EntityPlayer)this.playerWR.get();
                MessageDataSync message = new MessageDataSync(SHPlayerDataHandler.get(player), player);
                NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
            }
        }

        public void save() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound tags = SHPlayerDataHandler.getDataCompoundForPlayer(player);
                this.writeToNBT(tags);
            }
        }

        public void writeToNBT(NBTTagCompound tags) {
            tags.func_74780_a(NBT_DIFFICULTY, this.difficulty);
            tags.func_74776_a(NBT_HEALTH, this.health);
            tags.func_74776_a(NBT_MAX_HEALTH, this.maxHealth);
        }

        public void load() {
            EntityPlayer player;
            if (!this.client && (player = (EntityPlayer)this.playerWR.get()) != null) {
                NBTTagCompound tags = SHPlayerDataHandler.getDataCompoundForPlayer(player);
                this.readFromNBT(tags);
            }
        }

        public void readFromNBT(NBTTagCompound tags) {
            this.difficulty = tags.func_74769_h(NBT_DIFFICULTY);
            this.health = tags.func_74760_g(NBT_HEALTH);
            this.maxHealth = tags.func_74760_g(NBT_MAX_HEALTH);
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                SHPlayerDataHandler.cleanup();
            }
        }

        @SubscribeEvent
        public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                SHPlayerDataHandler.get(player).tick();
                if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 5L * (long)ConfigScalingHealth.PACKET_DELAY == 0L) {
                    int radius = ConfigScalingHealth.DIFFICULTY_SEARCH_RADIUS;
                    int radiusSquared = radius <= 0 ? Integer.MAX_VALUE : radius * radius;
                    for (EntityPlayer p2 : player.field_70170_p.func_175661_b(EntityPlayer.class, p -> !p.equals((Object)player) && p.func_174818_b(player.func_180425_c()) < (double)radiusSquared)) {
                        MessageDataSync message = new MessageDataSync(SHPlayerDataHandler.get(p2), p2);
                        NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
                    }
                }
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.player instanceof EntityPlayerMP) {
                MessageDataSync message = new MessageDataSync(SHPlayerDataHandler.get(event.player), event.player);
                NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)event.player);
            }
        }
    }
}

