/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.config;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.lib.EnumAreaDifficultyMode;
import net.silentchaos512.scalinghealth.lib.EnumHealthModMode;

public class ConfigScalingHealth {
    public static boolean DEBUG_MODE = false;
    public static boolean CHANGE_HEART_RENDERING = true;
    public static boolean RENDER_DIFFICULTY_METER = true;
    public static boolean RENDER_DIFFICULTY_METER_ALWAYS = false;
    public static int DIFFICULTY_METER_DISPLAY_TIME = 160;
    public static int[] HEART_COLORS = new int[]{0xBF0000, 0xE66000, 15112448, 15127296, 10085888, 5039616, 59033, 59110, 39398, 230, 10027238, 13992191, 0x8C8C8C, 0xE6E6E6};
    public static boolean ALLOW_PLAYER_MODIFIED_HEALTH = true;
    public static int PLAYER_STARTING_HEALTH = 20;
    public static int PLAYER_HEALTH_MAX = 0;
    public static int PLAYER_HEALTH_LOST_ON_DEATH = 0;
    public static boolean ENABLE_BONUS_HEALTH_REGEN = true;
    public static int BONUS_HEALTH_REGEN_MIN_FOOD = 10;
    public static int BONUS_HEALTH_REGEN_MAX_FOOD = 20;
    public static int BONUS_HEALTH_REGEN_INITIAL_DELAY = 400;
    public static int BONUS_HEALTH_REGEN_DELAY = 100;
    public static boolean ALLOW_PEACEFUL_EXTRA_HEALTH = true;
    public static boolean ALLOW_HOSTILE_EXTRA_HEALTH = true;
    public static float DIFFICULTY_GENERIC_HEALTH_MULTIPLIER = 0.5f;
    public static float DIFFICULTY_PEACEFUL_HEALTH_MULTIPLIER = 0.25f;
    public static EnumHealthModMode MOB_HEALTH_SCALING_MODE = EnumHealthModMode.MULTI_HALF;
    private static List<String> MOB_HEALTH_BLACKLIST;
    private static String[] MOB_HEALTH_BLACKLIST_DEFAULTS;
    public static float BLIGHT_CHANCE_MULTIPLIER;
    public static int BLIGHT_AMP_SPEED;
    public static int BLIGHT_AMP_STRENGTH;
    public static boolean BLIGHT_FIRE_RIDES_BLIGHT;
    public static boolean BLIGHT_INVISIBLE;
    public static boolean BLIGHT_FIRE_RESIST;
    public static float BLIGHT_XP_MULTIPLIER;
    public static boolean BLIGHT_SUPERCHARGE_CREEPERS;
    public static boolean BLIGHT_NOTIFY_PLAYERS_ON_DEATH;
    private static List<String> BLIGHT_BLACKLIST;
    private static String[] BLIGHT_BLACKLIST_DEFAULTS;
    public static float HEART_DROP_CHANCE;
    public static int HEARTS_DROPPED_BY_BOSS_MIN;
    public static int HEARTS_DROPPED_BY_BOSS_MAX;
    public static int HEARTS_DROPPED_BY_BLIGHT_MIN;
    public static int HEARTS_DROPPED_BY_BLIGHT_MAX;
    public static float DIFFICULTY_MAX;
    public static float DIFFICULTY_DEFAULT;
    public static int HOURS_TO_MAX_DIFFICULTY;
    public static float DIFFICULTY_PER_SECOND;
    public static float DIFFICULTY_PER_BLOCK;
    public static float DIFFICULTY_IDLE_MULTI;
    public static float DIFFICULTY_GROUP_AREA_BONUS;
    public static int DIFFICULTY_SEARCH_RADIUS;
    public static EnumAreaDifficultyMode AREA_DIFFICULTY_MODE;
    public static int PACKET_DELAY;
    public static float HEART_CRYSTAL_ORE_VEIN_COUNT;
    public static int HEART_CRYSTAL_ORE_VEIN_SIZE;
    public static int HEART_CRYSTAL_ORE_MIN_HEIGHT;
    public static int HEART_CRYSTAL_ORE_MAX_HEIGHT;
    static final String split = ".";
    public static final String CAT_MAIN = "main";
    public static final String CAT_CLIENT = "main.client";
    public static final String CAT_PLAYER = "main.player";
    public static final String CAT_PLAYER_HEALTH = "main.player.health";
    public static final String CAT_PLAYER_REGEN = "main.player.regen";
    public static final String CAT_MOB = "main.mob";
    public static final String CAT_MOB_HEALTH = "main.mob.health";
    public static final String CAT_MOB_BLIGHT = "main.mob.blights";
    public static final String CAT_ITEMS = "main.items";
    public static final String CAT_DIFFICULTY = "main.difficulty";
    public static final String CAT_NETWORK = "main.network";
    public static final String CAT_WORLD = "main.world";
    private static Configuration c;

    public static void init(File file) {
        String path = file.getPath().replaceFirst("\\.cfg$", "/main.cfg");
        c = new Configuration(new File(path));
        ConfigScalingHealth.load();
    }

    public static void load() {
        try {
            DEBUG_MODE = c.getBoolean("Debug Mode", CAT_MAIN, DEBUG_MODE, "Draws random stuffs on the screen! And maybe does some other things.");
            RENDER_DIFFICULTY_METER = c.getBoolean("Render Difficulty Meter", CAT_CLIENT, RENDER_DIFFICULTY_METER, "Show the difficulty meter. Usually, it is displayed for a few seconds occasionally.");
            RENDER_DIFFICULTY_METER_ALWAYS = c.getBoolean("Render Difficulty Meter Always", CAT_CLIENT, RENDER_DIFFICULTY_METER_ALWAYS, "Render the difficulty meter at all times.");
            DIFFICULTY_METER_DISPLAY_TIME = c.getInt("Difficulty Meter Display Time", CAT_CLIENT, DIFFICULTY_METER_DISPLAY_TIME, 0, Integer.MAX_VALUE, "The time (in ticks) to show the difficulty meter whenever it pops up.");
            CHANGE_HEART_RENDERING = c.getBoolean("Custom Heart Rendering", CAT_CLIENT, CHANGE_HEART_RENDERING, "Replace vanilla heart rendering.");
            ConfigScalingHealth.loadHeartColors(c);
            ALLOW_PLAYER_MODIFIED_HEALTH = c.getBoolean("Allow Modified Health", CAT_PLAYER_HEALTH, ALLOW_PLAYER_MODIFIED_HEALTH, "Allow Scaling Health to modify the player's health. Set to false if you have another mod that modifies player health, and you would like that mod to handle health modifications instead. With this option set to false, heart containers will not work, nor will the '/scalinghealth health' command.");
            PLAYER_STARTING_HEALTH = c.getInt("Starting Health", CAT_PLAYER_HEALTH, PLAYER_STARTING_HEALTH, 2, Integer.MAX_VALUE, "The amount of health (in half hearts) the player starts with.");
            PLAYER_HEALTH_MAX = c.getInt("Max Health", CAT_PLAYER_HEALTH, PLAYER_HEALTH_MAX, 0, Integer.MAX_VALUE, "The maximum amount of health (in half hearts) the player can reach. Zero means unlimited.");
            PLAYER_HEALTH_LOST_ON_DEATH = c.getInt("Health Lost on Death", CAT_PLAYER_HEALTH, PLAYER_HEALTH_LOST_ON_DEATH, 0, Integer.MAX_VALUE, "The amount of health (in half hearts) the player will lose each time they die.");
            ENABLE_BONUS_HEALTH_REGEN = c.getBoolean("Enable Bonus Regen", CAT_PLAYER_REGEN, ENABLE_BONUS_HEALTH_REGEN, "Bonus health regen will be enabled. Vanilla regen is not changed in any way, this just adds extra healing!");
            BONUS_HEALTH_REGEN_MIN_FOOD = c.getInt("Food Min", CAT_PLAYER_REGEN, BONUS_HEALTH_REGEN_MIN_FOOD, 0, 20, "The minimum food level at which bonus regen will be active.");
            BONUS_HEALTH_REGEN_MAX_FOOD = c.getInt("Food Max", CAT_PLAYER_REGEN, BONUS_HEALTH_REGEN_MAX_FOOD, 0, 20, "The maximum food level at which bonus regen will be active.");
            BONUS_HEALTH_REGEN_INITIAL_DELAY = c.getInt("Delay (Initial)", CAT_PLAYER_REGEN, BONUS_HEALTH_REGEN_INITIAL_DELAY, 0, Integer.MAX_VALUE, "The number of ticks after being hurt before bonus regen activates.");
            BONUS_HEALTH_REGEN_DELAY = c.getInt("Delay", CAT_PLAYER_REGEN, BONUS_HEALTH_REGEN_DELAY, 0, Integer.MAX_VALUE, "The number of ticks between each bonus regen tick (a half heart being healed).");
            ALLOW_PEACEFUL_EXTRA_HEALTH = c.getBoolean("Allow Peaceful Extra Health", CAT_MOB_HEALTH, ALLOW_PEACEFUL_EXTRA_HEALTH, "Allow peaceful mobs (such as animals) to spawn with extra health based on difficulty.");
            ALLOW_HOSTILE_EXTRA_HEALTH = c.getBoolean("Allow Hostile Extra Health", CAT_MOB_HEALTH, ALLOW_HOSTILE_EXTRA_HEALTH, "Allow hostile mobs (monsters) to spawn with extra health based on difficulty.");
            DIFFICULTY_GENERIC_HEALTH_MULTIPLIER = c.getFloat("Base Health Modifier", CAT_MOB_HEALTH, DIFFICULTY_GENERIC_HEALTH_MULTIPLIER, 0.0f, Float.MAX_VALUE, "The minimum extra health a mob will have per point of difficulty. For example, at difficulty 30, a mob that normally has 20 health would have at least 50 health.");
            DIFFICULTY_PEACEFUL_HEALTH_MULTIPLIER = c.getFloat("Base Health Modifier Peaceful", CAT_MOB_HEALTH, DIFFICULTY_PEACEFUL_HEALTH_MULTIPLIER, 0.0f, Float.MAX_VALUE, "The minimum extra health a peaceful will have per point of difficulty. Same as \"Base Health Modifier\", but for peaceful mobs!");
            MOB_HEALTH_SCALING_MODE = EnumHealthModMode.loadFromConfig(c, MOB_HEALTH_SCALING_MODE);
            MOB_HEALTH_BLACKLIST = Arrays.asList(c.getStringList("Blacklist", CAT_MOB_HEALTH, MOB_HEALTH_BLACKLIST_DEFAULTS, "Mobs listed here will never receive extra health, and will not become blights. There is also a separate blacklist for blights, if you still want the mob in question to have extra health."));
            if (MOB_HEALTH_BLACKLIST == null) {
                MOB_HEALTH_BLACKLIST = Lists.newArrayList((Object[])MOB_HEALTH_BLACKLIST_DEFAULTS);
            }
            BLIGHT_CHANCE_MULTIPLIER = c.getFloat("Blight Chance Multiplier", CAT_MOB_BLIGHT, BLIGHT_CHANCE_MULTIPLIER, 0.0f, Float.MAX_VALUE, "Determines the chance of a mob spawning as a blight. Formula is blightChanceMulti * currentDifficulty / maxDifficulty");
            BLIGHT_AMP_SPEED = c.getInt("Amplifier Speed", CAT_MOB_BLIGHT, BLIGHT_AMP_SPEED, 0, 99, "The amplifier level on the speed potion effect applied to blights.");
            BLIGHT_AMP_STRENGTH = c.getInt("Amplifier Strength", CAT_MOB_BLIGHT, BLIGHT_AMP_STRENGTH, 0, 99, "The amplifier level on the strength potion effect applied to blights.");
            BLIGHT_FIRE_RIDES_BLIGHT = c.getBoolean("Fire Rides Blights", CAT_MOB_BLIGHT, BLIGHT_FIRE_RIDES_BLIGHT, "Blight's fire will be set to ride the blight. This will make the fire follow the blight more smoothly and prevent it from bobbing. Disable if you are having issues.");
            BLIGHT_INVISIBLE = c.getBoolean("Invisibility", CAT_MOB_BLIGHT, BLIGHT_INVISIBLE, "Should blights have the invisibility potion effect?");
            BLIGHT_FIRE_RESIST = c.getBoolean("Fire Resist", CAT_MOB_BLIGHT, BLIGHT_FIRE_RESIST, "Should blights have the fire resistance potion effect?");
            BLIGHT_XP_MULTIPLIER = c.getFloat("XP Multiplier", CAT_MOB_BLIGHT, BLIGHT_XP_MULTIPLIER, 0.0f, 1000.0f, "The multiplier applied to the amount of XP dropped when a blight is killed.");
            BLIGHT_SUPERCHARGE_CREEPERS = c.getBoolean("Supercharge Creepers", CAT_MOB_BLIGHT, BLIGHT_SUPERCHARGE_CREEPERS, "Blight creepers will also be supercharged (like when they are struck by lightning).");
            BLIGHT_BLACKLIST = Arrays.asList(c.getStringList("Blacklist", CAT_MOB_BLIGHT, BLIGHT_BLACKLIST_DEFAULTS, "Mobs listed here will never become blights, but can still receive extra health. There is also a blacklist for extra health."));
            HEART_DROP_CHANCE = c.getFloat("Heart Drop Chance", CAT_ITEMS, HEART_DROP_CHANCE, 0.0f, 1.0f, "The chance of any mob dropping a heart canister when killed.");
            HEARTS_DROPPED_BY_BOSS_MIN = c.getInt("Hearts Dropped by Boss Min", CAT_ITEMS, HEARTS_DROPPED_BY_BOSS_MIN, 0, 64, "The minimum number of heart canisters that a boss will drop when killed.");
            if ((HEARTS_DROPPED_BY_BOSS_MAX = c.getInt("Hearts Dropped by Boss Max", CAT_ITEMS, HEARTS_DROPPED_BY_BOSS_MAX, 0, 64, "The maximum number of heart canisters that a boss will drop when killed.")) < HEARTS_DROPPED_BY_BOSS_MIN) {
                HEARTS_DROPPED_BY_BOSS_MAX = HEARTS_DROPPED_BY_BOSS_MIN;
            }
            HEARTS_DROPPED_BY_BLIGHT_MIN = c.getInt("Hearts Dropped by Blight Min", CAT_ITEMS, HEARTS_DROPPED_BY_BLIGHT_MIN, 0, 64, "The minimum number of heart canisters that a blight will drop when killed.");
            if ((HEARTS_DROPPED_BY_BLIGHT_MAX = c.getInt("Hearts Dropped by Blight Max", CAT_ITEMS, HEARTS_DROPPED_BY_BLIGHT_MAX, 0, 64, "The maximum number of heart canisters that a blight will drop when killed.")) < HEARTS_DROPPED_BY_BLIGHT_MIN) {
                HEARTS_DROPPED_BY_BLIGHT_MAX = HEARTS_DROPPED_BY_BLIGHT_MIN;
            }
            DIFFICULTY_MAX = c.getFloat("Max Value", CAT_DIFFICULTY, DIFFICULTY_MAX, 0.0f, Float.MAX_VALUE, "The maximum difficult level that can be reached.");
            DIFFICULTY_DEFAULT = c.getFloat("Starting Value", CAT_DIFFICULTY, DIFFICULTY_DEFAULT, 0.0f, Float.MAX_VALUE, "The starting difficulty level for new worlds.");
            DIFFICULTY_PER_SECOND = c.getFloat("Increase Per Second", CAT_DIFFICULTY, DIFFICULTY_PER_SECOND, 0.0f, Float.MAX_VALUE, "The amount of difficulty added each second. In Difficult Life, the option was named per tick, but was actually applied each second.");
            DIFFICULTY_PER_BLOCK = c.getFloat("Difficulty Per Block", CAT_DIFFICULTY, DIFFICULTY_PER_BLOCK, 0.0f, Float.MAX_VALUE, "The amount of difficulty added per unit distance from the origin/spanw, assuming \"Area Mode\" is set to a distance-based option.");
            DIFFICULTY_IDLE_MULTI = c.getFloat("Idle Multiplier", CAT_DIFFICULTY, DIFFICULTY_IDLE_MULTI, 0.0f, Float.MAX_VALUE, "Difficulty added per second is multiplied by this if the player is not moving.");
            DIFFICULTY_GROUP_AREA_BONUS = c.getFloat("Group Area Bonus", CAT_DIFFICULTY, DIFFICULTY_GROUP_AREA_BONUS, 0.0f, Float.MAX_VALUE, "Adds this much extra difficulty per additional player in the area. So, area difficulty will be multiplied by: 1 + group_bonus * (players_in_area - 1)");
            DIFFICULTY_SEARCH_RADIUS = c.getInt("Search Radius", CAT_DIFFICULTY, DIFFICULTY_SEARCH_RADIUS, 0, Short.MAX_VALUE, "The distance from a newly spawned mob to search for players to determine its difficulty level. Set to 0 for unlimited range.");
            AREA_DIFFICULTY_MODE = EnumAreaDifficultyMode.loadFromConfig(c, AREA_DIFFICULTY_MODE);
            PACKET_DELAY = c.getInt("Packet Delay", CAT_NETWORK, PACKET_DELAY, 1, 1200, "The number of ticks between update packets. Smaller numbers mean more packets (and more bandwidth and processing power used), but also less client-server desync.");
            String cat = "main.world.heart_crystal_ore";
            HEART_CRYSTAL_ORE_VEIN_COUNT = c.getFloat("Veins Per Chunk", cat, HEART_CRYSTAL_ORE_VEIN_COUNT, 0.0f, 10000.0f, "The number of veins per chunk. The fractional part is a probability of an extra vein in each chunk.");
            HEART_CRYSTAL_ORE_VEIN_SIZE = c.getInt("Vein Size", cat, HEART_CRYSTAL_ORE_VEIN_SIZE, 0, 10000, "The size of each vein.");
            HEART_CRYSTAL_ORE_MIN_HEIGHT = c.getInt("Min Height", cat, HEART_CRYSTAL_ORE_MIN_HEIGHT, 0, 255, "The lowest y-level the ore can be found at. Must be less than Max Height");
            if ((HEART_CRYSTAL_ORE_MAX_HEIGHT = c.getInt("Max Height", cat, HEART_CRYSTAL_ORE_MAX_HEIGHT, 0, 255, "The highest y-level the ore can be found at. Must be greater than Min Height")) <= HEART_CRYSTAL_ORE_MIN_HEIGHT) {
                HEART_CRYSTAL_ORE_MAX_HEIGHT = 35;
                HEART_CRYSTAL_ORE_MIN_HEIGHT = 10;
            }
        }
        catch (Exception ex) {
            ScalingHealth.logHelper.severe((Object)"Could not load configuration file!");
            ex.printStackTrace();
        }
    }

    public static List<String> getMobHealthBlacklist() {
        if (MOB_HEALTH_BLACKLIST == null) {
            MOB_HEALTH_BLACKLIST = Lists.newArrayList();
        }
        return MOB_HEALTH_BLACKLIST;
    }

    public static List<String> getMobBlightBlacklist() {
        if (BLIGHT_BLACKLIST == null) {
            BLIGHT_BLACKLIST = Lists.newArrayList();
        }
        return BLIGHT_BLACKLIST;
    }

    private static void loadHeartColors(Configuration c) {
        String[] defaults = new String[HEART_COLORS.length];
        for (int i = 0; i < defaults.length; ++i) {
            defaults[i] = String.format("%06x", HEART_COLORS[i]);
        }
        String[] list = c.getStringList("Heart Colors", CAT_CLIENT, defaults, "The colors for each additional row of hearts. The colors will loop back around to the beginning if necessary. Use hexadecimal to specify colors (like HTML color codes).");
        try {
            HEART_COLORS = new int[list.length];
            for (int i = 0; i < HEART_COLORS.length; ++i) {
                ConfigScalingHealth.HEART_COLORS[i] = Integer.decode("0x" + list[i]);
            }
        }
        catch (NumberFormatException ex) {
            ScalingHealth.logHelper.warning((Object)"Failed to load heart colors because a value could not be parsed. Make sure all values are valid hexadecimal integers. Try using an online HTML color picker if you are having problems.");
            ex.printStackTrace();
        }
    }

    public static void save() {
        if (c.hasChanged()) {
            c.save();
        }
    }

    public static ConfigCategory getCategory(String str) {
        return c.getCategory(str);
    }

    public static Configuration getConfiguration() {
        return c;
    }

    public static List<IConfigElement> getConfigElements() {
        return new ConfigElement(ConfigScalingHealth.getCategory(CAT_MAIN)).getChildElements();
    }

    static {
        MOB_HEALTH_BLACKLIST_DEFAULTS = new String[0];
        BLIGHT_CHANCE_MULTIPLIER = 0.0625f;
        BLIGHT_AMP_SPEED = 8;
        BLIGHT_AMP_STRENGTH = 2;
        BLIGHT_FIRE_RIDES_BLIGHT = false;
        BLIGHT_INVISIBLE = false;
        BLIGHT_FIRE_RESIST = true;
        BLIGHT_XP_MULTIPLIER = 10.0f;
        BLIGHT_SUPERCHARGE_CREEPERS = true;
        BLIGHT_NOTIFY_PLAYERS_ON_DEATH = true;
        BLIGHT_BLACKLIST_DEFAULTS = new String[]{"WitherBoss", "Villager"};
        HEART_DROP_CHANCE = 0.01f;
        HEARTS_DROPPED_BY_BOSS_MIN = 3;
        HEARTS_DROPPED_BY_BOSS_MAX = 6;
        HEARTS_DROPPED_BY_BLIGHT_MIN = 0;
        HEARTS_DROPPED_BY_BLIGHT_MAX = 2;
        DIFFICULTY_MAX = 250.0f;
        DIFFICULTY_DEFAULT = 0.0f;
        HOURS_TO_MAX_DIFFICULTY = 60;
        DIFFICULTY_PER_SECOND = DIFFICULTY_MAX / (float)(HOURS_TO_MAX_DIFFICULTY * 3600);
        DIFFICULTY_PER_BLOCK = DIFFICULTY_MAX / 100000.0f;
        DIFFICULTY_IDLE_MULTI = 0.7f;
        DIFFICULTY_GROUP_AREA_BONUS = 0.05f;
        DIFFICULTY_SEARCH_RADIUS = 160;
        AREA_DIFFICULTY_MODE = EnumAreaDifficultyMode.WEIGHTED_AVERAGE;
        PACKET_DELAY = 20;
        HEART_CRYSTAL_ORE_VEIN_COUNT = 0.42857143f;
        HEART_CRYSTAL_ORE_VEIN_SIZE = 6;
        HEART_CRYSTAL_ORE_MIN_HEIGHT = 10;
        HEART_CRYSTAL_ORE_MAX_HEIGHT = 35;
    }
}

