/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;
import net.silentchaos512.scalinghealth.entity.EntityBlightFire;
import net.silentchaos512.scalinghealth.init.ModItems;
import net.silentchaos512.scalinghealth.network.NetworkHandler;
import net.silentchaos512.scalinghealth.network.message.MessageMarkBlight;

public class BlightHandler {
    public static final String NBT_BLIGHT = "ScalingHealth.IsBlight";
    public static int UPDATE_DELAY = 200;
    public static int UPDATE_DELAY_SALT = 5 + ScalingHealth.random.nextInt(10);
    public static BlightHandler INSTANCE = new BlightHandler();

    public static boolean isBlight(EntityLivingBase entityLiving) {
        return entityLiving != null && entityLiving.getEntityData() != null && entityLiving.getEntityData().func_74767_n(NBT_BLIGHT);
    }

    public static void markBlight(EntityLivingBase entityLiving) {
        if (entityLiving == null || entityLiving.getEntityData() == null) {
            return;
        }
        entityLiving.getEntityData().func_74757_a(NBT_BLIGHT, true);
    }

    public static void spawnBlightFire(EntityLivingBase blight) {
        if (blight.field_70170_p.field_72995_K) {
            return;
        }
        EntityBlightFire fire = new EntityBlightFire(blight);
        fire.func_70107_b(blight.field_70165_t, blight.field_70163_u, blight.field_70161_v);
        blight.field_70170_p.func_72838_d((Entity)fire);
        if (ConfigScalingHealth.BLIGHT_FIRE_RIDES_BLIGHT) {
            fire.func_184220_m((Entity)blight);
        }
    }

    public static EntityBlightFire getBlightFire(EntityLivingBase blight) {
        World world = blight.field_70170_p;
        List fireList = world.func_175644_a(EntityBlightFire.class, e -> true);
        for (EntityBlightFire fire : fireList) {
            if (fire.getParent() == null || !fire.getParent().equals((Object)blight)) continue;
            return fire;
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlightKilled(LivingDeathEvent event) {
        if (event.getSource() == null || !BlightHandler.isBlight(event.getEntityLiving()) || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        LocalizationHelper loc = ScalingHealth.localizationHelper;
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            int heartCount;
            EntityLivingBase blight = event.getEntityLiving();
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (ConfigScalingHealth.BLIGHT_NOTIFY_PLAYERS_ON_DEATH) {
                String message = loc.getLocalizedString("blight", "killedByPlayer", new Object[]{blight.func_70005_c_(), player.func_70005_c_()});
                ScalingHealth.logHelper.info((Object)message);
                for (EntityPlayer p : player.field_70170_p.func_175661_b(EntityPlayer.class, e -> true)) {
                    ChatHelper.sendMessage((EntityPlayer)p, (String)message);
                }
            }
            if ((heartCount = ScalingHealth.random.nextInt(ConfigScalingHealth.HEARTS_DROPPED_BY_BLIGHT_MAX - ConfigScalingHealth.HEARTS_DROPPED_BY_BLIGHT_MIN + 1) + ConfigScalingHealth.HEARTS_DROPPED_BY_BLIGHT_MIN) > 0) {
                blight.func_145779_a((Item)ModItems.heart, heartCount);
            }
        } else {
            EntityLivingBase blight = event.getEntityLiving();
            if (ConfigScalingHealth.BLIGHT_NOTIFY_PLAYERS_ON_DEATH) {
                String message = event.getSource().func_151519_b(blight).func_150254_d();
                String blightName = loc.getLocalizedString("blight", "name", new Object[]{blight.func_70005_c_()});
                if ((message = message.replaceFirst(blight.func_70005_c_(), blightName)).startsWith("Blight Squid") && message.contains("drowned")) {
                    message = message + "... again";
                }
                if (message.endsWith("suffocated in a wall")) {
                    message = message + " *slow clap*";
                }
                ScalingHealth.logHelper.info((Object)message);
                for (EntityPlayer p : blight.field_70170_p.func_175661_b(EntityPlayer.class, e -> true)) {
                    ChatHelper.sendMessage((EntityPlayer)p, (String)message);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onXPDropped(LivingExperienceDropEvent event) {
        if (!BlightHandler.isBlight(event.getEntityLiving())) {
            return;
        }
        int amount = event.getDroppedExperience();
        amount = (int)((float)amount * ConfigScalingHealth.BLIGHT_XP_MULTIPLIER);
        event.setDroppedExperience(amount);
    }

    @SubscribeEvent
    public void onBlightUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() != null) {
            boolean updateTime;
            EntityLivingBase entityLiving = event.getEntityLiving();
            World world = entityLiving.field_70170_p;
            if (!BlightHandler.isBlight(entityLiving)) {
                return;
            }
            boolean bl = updateTime = (world.func_82737_E() + (long)UPDATE_DELAY_SALT) % (long)UPDATE_DELAY == 0L;
            if (updateTime && !world.field_72995_K) {
                MessageMarkBlight message = new MessageMarkBlight(entityLiving);
                NetworkHandler.INSTANCE.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(entityLiving.field_71093_bK, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 128.0));
                if (BlightHandler.getBlightFire(entityLiving) == null) {
                    BlightHandler.spawnBlightFire(entityLiving);
                }
            }
        }
    }
}

