/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.silentchaos512.lib.util.StackHelper;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;
import net.silentchaos512.scalinghealth.event.BlightHandler;
import net.silentchaos512.scalinghealth.network.NetworkHandler;
import net.silentchaos512.scalinghealth.network.message.MessageMarkBlight;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;

public class DifficultyHandler {
    public static DifficultyHandler INSTANCE = new DifficultyHandler();

    @SubscribeEvent
    public void onMobSpawn(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entityLiving = (EntityLivingBase)event.getEntity();
        if (entityLiving.field_70170_p.field_72995_K || entityLiving instanceof EntityPlayer || this.entityBlacklistedFromHealthIncrease(entityLiving) || !this.canIncreaseEntityHealth(entityLiving)) {
            return;
        }
        boolean makeBlight = this.increaseEntityHealth(entityLiving);
        if (makeBlight) {
            this.makeEntityBlight(entityLiving, ScalingHealth.random);
        }
    }

    private boolean increaseEntityHealth(EntityLivingBase entityLiving) {
        float diffIncrease;
        float difficulty = (float)ConfigScalingHealth.AREA_DIFFICULTY_MODE.getAreaDifficulty(entityLiving.field_70170_p, entityLiving.func_180425_c());
        Random rand = ScalingHealth.random;
        boolean makeBlight = false;
        if (!this.entityBlacklistedFromBecomingBlight(entityLiving)) {
            float chance = difficulty / ConfigScalingHealth.DIFFICULTY_MAX * ConfigScalingHealth.BLIGHT_CHANCE_MULTIPLIER;
            if (rand.nextFloat() < chance) {
                makeBlight = true;
                difficulty *= 3.0f;
            }
        }
        float genAddedHealth = difficulty;
        float genAddedDamage = 0.0f;
        float baseMaxHealth = (float)entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        genAddedHealth = entityLiving instanceof IMob ? (genAddedHealth *= ConfigScalingHealth.DIFFICULTY_GENERIC_HEALTH_MULTIPLIER) : (genAddedHealth *= ConfigScalingHealth.DIFFICULTY_PEACEFUL_HEALTH_MULTIPLIER);
        difficulty -= genAddedHealth;
        if (difficulty > 0.0f) {
            diffIncrease = difficulty * rand.nextFloat();
            difficulty -= diffIncrease;
            genAddedHealth += diffIncrease;
        }
        if (difficulty > 0.0f) {
            diffIncrease = difficulty * rand.nextFloat();
            difficulty -= diffIncrease;
            genAddedDamage = diffIncrease / 10.0f;
        }
        if (difficulty > 0.0f) {
            // empty if block
        }
        float healthMulti = 1.0f;
        float healthScaleDiff = Math.max(0.0f, baseMaxHealth - 20.0f);
        switch (ConfigScalingHealth.MOB_HEALTH_SCALING_MODE) {
            case ADD: {
                ModifierHandler.setMaxHealth(entityLiving, genAddedHealth + baseMaxHealth, 0);
                break;
            }
            case MULTI: {
                healthMulti = genAddedHealth / 20.0f;
                ModifierHandler.setMaxHealth(entityLiving, healthMulti + baseMaxHealth, 1);
                break;
            }
            case MULTI_HALF: {
                healthMulti = genAddedHealth / (20.0f + healthScaleDiff * 0.5f);
                ModifierHandler.setMaxHealth(entityLiving, healthMulti + baseMaxHealth, 1);
                break;
            }
            case MULTI_QUARTER: {
                healthMulti = genAddedHealth / (20.0f + healthScaleDiff * 0.75f);
                ModifierHandler.setMaxHealth(entityLiving, healthMulti + baseMaxHealth, 1);
                break;
            }
            default: {
                ScalingHealth.logHelper.severe((Object)("Unknown mob health scaling mode: " + ConfigScalingHealth.MOB_HEALTH_SCALING_MODE.name()));
            }
        }
        ModifierHandler.addAttackDamage(entityLiving, genAddedDamage, 0);
        entityLiving.func_70606_j(entityLiving.func_110138_aP());
        return makeBlight;
    }

    private void makeEntityBlight(EntityLivingBase entityLiving, Random rand) {
        BlightHandler.markBlight(entityLiving);
        BlightHandler.spawnBlightFire(entityLiving);
        if (ConfigScalingHealth.BLIGHT_INVISIBLE) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76441_p, Integer.MAX_VALUE, 0, true, false));
        }
        if (ConfigScalingHealth.BLIGHT_FIRE_RESIST) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0, true, false));
        }
        if (ConfigScalingHealth.BLIGHT_AMP_SPEED > 0) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, ConfigScalingHealth.BLIGHT_AMP_SPEED, true, false));
        }
        if (ConfigScalingHealth.BLIGHT_AMP_STRENGTH > 0) {
            entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, ConfigScalingHealth.BLIGHT_AMP_STRENGTH, true, false));
        }
        if (entityLiving instanceof EntityLiving) {
            int j;
            EntityLiving entity = (EntityLiving)entityLiving;
            int i = rand.nextInt(2);
            float f = 0.5f;
            for (j = 0; j < 3; ++j) {
                if (!(rand.nextFloat() < 0.095f)) continue;
                ++i;
            }
            for (j = 3; j >= 0; --j) {
                ItemStack stack1;
                EntityEquipmentSlot slot = EntityEquipmentSlot.values()[j + 2];
                ItemStack stack = entity.func_184582_a(slot);
                if (j < 3 && rand.nextFloat() < f) break;
                if (stack != null || (stack1 = this.selectArmorForSlot(j + 1, i)) == null) continue;
                entity.func_184201_a(slot, stack1);
            }
        }
        for (EntityLiving slot : EntityEquipmentSlot.values()) {
            ItemStack stack = entityLiving.func_184582_a((EntityEquipmentSlot)slot);
            if (stack == null) continue;
            EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)stack, (int)30, (boolean)false);
        }
        if (ConfigScalingHealth.BLIGHT_SUPERCHARGE_CREEPERS && entityLiving instanceof EntityCreeper) {
            ((EntityCreeper)entityLiving).func_70077_a(new EntityLightningBolt(entityLiving.field_70170_p, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, true));
        }
        MessageMarkBlight message = new MessageMarkBlight(entityLiving);
        NetworkHandler.INSTANCE.sendToAllAround((IMessage)message, new NetworkRegistry.TargetPoint(entityLiving.field_71093_bK, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 128.0));
    }

    private boolean entityBlacklistedFromHealthIncrease(EntityLivingBase entityLiving) {
        if (entityLiving == null) {
            return true;
        }
        if (!ConfigScalingHealth.ALLOW_HOSTILE_EXTRA_HEALTH && entityLiving instanceof EntityMob) {
            return true;
        }
        if (!ConfigScalingHealth.ALLOW_PEACEFUL_EXTRA_HEALTH && entityLiving instanceof EntityAnimal) {
            return true;
        }
        String entityId = EntityList.func_75621_b((Entity)entityLiving);
        List<String> blacklist = ConfigScalingHealth.getMobHealthBlacklist();
        if (entityId == null || blacklist == null) {
            return false;
        }
        return blacklist.contains(entityId);
    }

    private boolean canIncreaseEntityHealth(EntityLivingBase entityLiving) {
        return entityLiving.func_110140_aT() != null && entityLiving.field_70173_aa > 1 && entityLiving.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(ModifierHandler.MODIFIER_ID_HEALTH) == null;
    }

    private boolean entityBlacklistedFromBecomingBlight(EntityLivingBase entityLiving) {
        if (entityLiving == null) {
            return true;
        }
        String entityId = EntityList.func_75621_b((Entity)entityLiving);
        List<String> blacklist = ConfigScalingHealth.getMobBlightBlacklist();
        if (entityId == null || blacklist == null) {
            return false;
        }
        return blacklist.contains(entityId);
    }

    private ItemStack selectArmorForSlot(int slot, int tier) {
        ItemArmor item = null;
        switch (slot) {
            case 4: {
                if (tier == 0) {
                    item = Items.field_151024_Q;
                    break;
                }
                if (tier == 1) {
                    item = Items.field_151169_ag;
                    break;
                }
                if (tier == 2) {
                    item = Items.field_151020_U;
                    break;
                }
                if (tier == 3) {
                    item = Items.field_151028_Y;
                    break;
                }
                if (tier != 4) break;
                item = Items.field_151161_ac;
                break;
            }
            case 3: {
                if (tier == 0) {
                    item = Items.field_151027_R;
                    break;
                }
                if (tier == 1) {
                    item = Items.field_151171_ah;
                    break;
                }
                if (tier == 2) {
                    item = Items.field_151023_V;
                    break;
                }
                if (tier == 3) {
                    item = Items.field_151030_Z;
                    break;
                }
                if (tier != 4) break;
                item = Items.field_151163_ad;
                break;
            }
            case 2: {
                if (tier == 0) {
                    item = Items.field_151026_S;
                    break;
                }
                if (tier == 1) {
                    item = Items.field_151149_ai;
                    break;
                }
                if (tier == 2) {
                    item = Items.field_151022_W;
                    break;
                }
                if (tier == 3) {
                    item = Items.field_151165_aa;
                    break;
                }
                if (tier != 4) break;
                item = Items.field_151173_ae;
                break;
            }
            case 1: {
                if (tier == 0) {
                    item = Items.field_151021_T;
                    break;
                }
                if (tier == 1) {
                    item = Items.field_151151_aj;
                    break;
                }
                if (tier == 2) {
                    item = Items.field_151029_X;
                    break;
                }
                if (tier == 3) {
                    item = Items.field_151167_ab;
                    break;
                }
                if (tier != 4) break;
                item = Items.field_151175_af;
            }
        }
        return item == null ? StackHelper.empty() : new ItemStack((Item)item);
    }
}

