/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.event;

import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;
import net.silentchaos512.scalinghealth.init.ModItems;
import net.silentchaos512.scalinghealth.utils.ModifierHandler;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;

public class ScalingHealthCommonEvents {
    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (!entityLiving.field_70170_p.field_72995_K) {
            Random rand = ScalingHealth.random;
            int stackSize = 0;
            if (event.isRecentlyHit() && rand.nextFloat() <= ConfigScalingHealth.HEART_DROP_CHANCE) {
                ++stackSize;
            }
            if (!entityLiving.func_184222_aU()) {
                int min = ConfigScalingHealth.HEARTS_DROPPED_BY_BOSS_MIN;
                int max = ConfigScalingHealth.HEARTS_DROPPED_BY_BOSS_MAX;
                stackSize += min + rand.nextInt(max - min + 1);
            }
            if (stackSize > 0) {
                entityLiving.func_145779_a((Item)ModItems.heart, stackSize);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get((EntityPlayer)player);
            if (ConfigScalingHealth.PLAYER_HEALTH_LOST_ON_DEATH > 0) {
                float startHealth;
                float newHealth = data.getMaxHealth() - (float)ConfigScalingHealth.PLAYER_HEALTH_LOST_ON_DEATH;
                data.setMaxHealth(newHealth < (startHealth = (float)ConfigScalingHealth.PLAYER_STARTING_HEALTH) ? startHealth : newHealth);
            }
            float health = player.func_110143_aJ();
            float maxHealth = data.getMaxHealth();
            ModifierHandler.setMaxHealth((EntityLivingBase)player, maxHealth, 0);
            if (health != maxHealth && maxHealth > 0.0f) {
                player.func_70606_j(maxHealth);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoinedServer(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get((EntityPlayer)player);
            float health = player.func_110143_aJ();
            float maxHealth = data.getMaxHealth();
            ModifierHandler.setMaxHealth((EntityLivingBase)player, maxHealth, 0);
            if (health > maxHealth && maxHealth > 0.0f) {
                player.func_70606_j(maxHealth);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("scalinghealth")) {
            ConfigScalingHealth.load();
            ConfigScalingHealth.save();
        }
    }
}

