/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.lib;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;

public enum EnumAreaDifficultyMode {
    WEIGHTED_AVERAGE,
    AVERAGE,
    MIN_LEVEL,
    MAX_LEVEL,
    DISTANCE_FROM_SPAWN,
    DISTANCE_FROM_ORIGIN,
    DISTANCE_AND_TIME;


    public static EnumAreaDifficultyMode loadFromConfig(Configuration c, EnumAreaDifficultyMode defaultValue) {
        String[] validValues = new String[EnumAreaDifficultyMode.values().length];
        for (int i = 0; i < EnumAreaDifficultyMode.values().length; ++i) {
            validValues[i] = EnumAreaDifficultyMode.values()[i].name();
        }
        String str = c.getString("Area Mode", "main.difficulty", defaultValue.name(), "Defines how the area difficulty is determined when spawning a mob.\n  AVERAGE - The average difficulty level of all nearby players.\n  WEIGHTED_AVERAGE - Similar to average, but closer players have a greater impact on difficulty.\n  MIN_LEVEL - The lowest difficulty level of all nearby players.\n  MAX_LEVEL - The highest difficulty level of all nearby players.\n  DISTANCE_FROM_SPAWN - Based on the mob's distance from spawn.\n  DISTANCE_FROM_ORIGIN - Based on the mob's distance from the origin.\n  DISTANCE_AND_TIME - Mix of DISTANCE_FROM_SPAWN and WEIGHTED_AVERAGE.", validValues);
        for (EnumAreaDifficultyMode mode : EnumAreaDifficultyMode.values()) {
            if (!mode.name().equals(str)) continue;
            return mode;
        }
        return defaultValue;
    }

    public double getAreaDifficulty(World world, BlockPos pos) {
        return this.getAreaDifficulty(world, pos, true);
    }

    public double getAreaDifficulty(World world, BlockPos pos, boolean addGroupBonus) {
        int radius = ConfigScalingHealth.DIFFICULTY_SEARCH_RADIUS;
        long radiusSquared = radius <= 0 ? Long.MAX_VALUE : (long)(radius * radius);
        radius = radius <= 0 ? Integer.MAX_VALUE : radius;
        List players = world.func_175661_b(EntityPlayer.class, p -> p.func_174818_b(pos) <= (double)radiusSquared);
        if (players.size() == 0) {
            return 0.0;
        }
        double total = 0.0;
        double ret = 0.0;
        BlockPos origin = BlockPos.field_177992_a;
        switch (this) {
            case WEIGHTED_AVERAGE: {
                int totalWeight = 0;
                for (EntityPlayer player : players) {
                    SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get(player);
                    if (data == null) continue;
                    int distance = (int)pos.func_185332_f((int)player.field_70165_t, pos.func_177956_o(), (int)player.field_70161_v);
                    int weight = (radius - distance) / 16 + 1;
                    total += (double)weight * data.getDifficulty();
                    totalWeight += weight;
                }
                ret = totalWeight <= 0 ? 0.0 : total / (double)totalWeight;
                break;
            }
            case AVERAGE: {
                for (EntityPlayer player : players) {
                    SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get(player);
                    if (data == null) continue;
                    total += data.getDifficulty();
                }
                ret = total / (double)players.size();
                break;
            }
            case MAX_LEVEL: {
                double max = 0.0;
                for (EntityPlayer player : players) {
                    SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get(player);
                    if (data == null) continue;
                    double d = data.getDifficulty();
                    max = Math.max(d, max);
                }
                ret = max;
                break;
            }
            case MIN_LEVEL: {
                double min = ConfigScalingHealth.DIFFICULTY_MAX;
                for (EntityPlayer player : players) {
                    SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get(player);
                    if (data == null) continue;
                    double d = data.getDifficulty();
                    min = Math.min(d, min);
                }
                ret = min;
                break;
            }
            case DISTANCE_FROM_SPAWN: {
                origin = world.func_175694_M();
            }
            case DISTANCE_FROM_ORIGIN: {
                int dx = pos.func_177958_n() - origin.func_177958_n();
                int dz = pos.func_177952_p() - origin.func_177952_p();
                double distance = Math.sqrt(dx * dx + dz * dz);
                ret = distance * (double)ConfigScalingHealth.DIFFICULTY_PER_BLOCK;
                break;
            }
            case DISTANCE_AND_TIME: {
                double difficultyFromPlayers = WEIGHTED_AVERAGE.getAreaDifficulty(world, pos, false);
                double difficultyFromDistance = DISTANCE_FROM_SPAWN.getAreaDifficulty(world, pos, false);
                ret = difficultyFromPlayers + difficultyFromDistance;
            }
        }
        double d = ret < 0.0 ? 0.0 : (ret = ret > (double)ConfigScalingHealth.DIFFICULTY_MAX ? (double)ConfigScalingHealth.DIFFICULTY_MAX : ret);
        if (addGroupBonus) {
            ret *= (double)(1.0f + ConfigScalingHealth.DIFFICULTY_GROUP_AREA_BONUS * (float)(players.size() - 1));
        }
        return ret;
    }
}

