/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.world;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.silentchaos512.scalinghealth.block.BlockCrystalOre;
import net.silentchaos512.scalinghealth.config.ConfigScalingHealth;
import net.silentchaos512.scalinghealth.init.ModBlocks;

public class SHWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int posX, int posZ) {
        BlockCrystalOre block = ModBlocks.crystalOre;
        IBlockState state = block.func_176223_P();
        int veinCount = (int)ConfigScalingHealth.HEART_CRYSTAL_ORE_VEIN_COUNT;
        if (random.nextFloat() < ConfigScalingHealth.HEART_CRYSTAL_ORE_VEIN_COUNT - (float)veinCount) {
            ++veinCount;
        }
        int veinSize = ConfigScalingHealth.HEART_CRYSTAL_ORE_VEIN_SIZE;
        int minHeight = ConfigScalingHealth.HEART_CRYSTAL_ORE_MIN_HEIGHT;
        int maxHeight = ConfigScalingHealth.HEART_CRYSTAL_ORE_MAX_HEIGHT;
        for (int i = 0; i < veinCount; ++i) {
            int x = posX + random.nextInt(16);
            int y = random.nextInt(maxHeight - minHeight) + minHeight;
            int z = posZ + random.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            new WorldGenMinable(state, veinSize).func_180709_b(world, random, pos);
        }
    }
}

