/*
 * Decompiled with CFR 0.152.
 */
package net.probossgamers.turtlemod.client.render.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.probossgamers.turtlemod.client.model.block.ModelTurtleShell;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ItemTurtleShellRenderer
implements IItemRenderer {
    public ResourceLocation texture = new ResourceLocation("turtlemod:textures/mobs/Turtle.png");
    public ModelTurtleShell model = new ModelTurtleShell();
    public float scale = 0.0f;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper != IItemRenderer.ItemRendererHelper.BLOCK_3D;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.setScale(0.5f);
                this.renderBlock(0.0f, 1.1f, -0.03125f);
                break;
            }
            case EQUIPPED: {
                this.setScale(1.2f);
                GL11.glRotatef((float)100.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.renderBlock(-1.4f, 1.5f, 0.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.setScale(0.9f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderBlock(0.2f, 2.0f, -0.9f);
                break;
            }
            case INVENTORY: {
                this.setScale(1.2f);
                this.renderBlock(0.0f, 1.0f, 0.0f);
            }
        }
    }

    private void renderBlock(float x, float y, float z) {
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        this.model.render();
        GL11.glPopMatrix();
    }

    private void setScale(float s) {
        this.scale = s;
    }
}

