/*
 * Decompiled with CFR 0.152.
 */
package lumien.hardcoredarkness.network.messages;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import lumien.hardcoredarkness.HardcoreDarkness;
import lumien.hardcoredarkness.config.HardcoreDarknessConfig;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Level;

public class MessageConfig
implements IMessage,
IMessageHandler<MessageConfig, IMessage> {
    HardcoreDarknessConfig config;

    public MessageConfig() {
    }

    public MessageConfig(HardcoreDarknessConfig config) {
        this.config = config;
    }

    public IMessage onMessage(MessageConfig message, MessageContext ctx) {
        HardcoreDarknessConfig config = message.config;
        HardcoreDarkness.INSTANCE.logger.log(Level.DEBUG, "Received Hardcore Darkness Config from Server: " + config.toString());
        HardcoreDarkness.INSTANCE.setServerConfig(config);
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.config = new HardcoreDarknessConfig();
        this.config.setMode(buf.readInt());
        this.config.setDarkNether(buf.readBoolean());
        this.config.setDarkEnd(buf.readBoolean());
        this.config.setAlternativeNightSkylight(buf.readBoolean());
        this.config.setGammaOverride(buf.readFloat());
        float[] moonLightList = new float[5];
        for (int i = 0; i < 5; ++i) {
            moonLightList[i] = buf.readFloat();
        }
        this.config.setMoonLightList(moonLightList);
        int blackListSize = buf.readInt();
        for (int i = 0; i < blackListSize; ++i) {
            this.config.addDimensionToBlacklist(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.config.getMode());
        buf.writeBoolean(this.config.darkNether());
        buf.writeBoolean(this.config.darkEnd());
        buf.writeBoolean(this.config.removeBlue());
        buf.writeFloat(this.config.getGammaOverride());
        float[] moonLightList = this.config.getMoonLightList();
        for (int i = 0; i < 5; ++i) {
            buf.writeFloat(moonLightList[i]);
        }
        HashSet<Integer> blackList = this.config.getDimensionBlackList();
        buf.writeInt(blackList.size());
        for (Integer dimension : blackList) {
            buf.writeInt(dimension.intValue());
        }
    }
}

