/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.config;

import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.wawla.Wawla;
import net.darkhax.wawla.config.Configurable;
import net.darkhax.wawla.utils.AnnotationUtils;
import net.darkhax.wawla.utils.CollectionUtils;
import net.darkhax.wawla.utils.ItemStackUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class WawlaConfiguration {
    public static final Map<Class<?>, Adapter> handlers = new HashMap();
    private final String name;
    private final File file;
    private final Configuration config;
    private Field[] properties;

    public WawlaConfiguration(String name) {
        this.name = name;
        this.file = new File(Loader.instance().getConfigDir(), name.toLowerCase() + ".cfg");
        this.config = new Configuration(this.file);
    }

    public void init(List<Class<?>> providerClasses) {
        this.properties = AnnotationUtils.getAnnotatedFields(providerClasses, Configurable.class).toArray(new Field[0]);
    }

    public void sync() {
        this.config.load();
        for (Field field : this.properties) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) {
                Wawla.LOG.info("Configuration fields must be public, and static!");
                while (true) {
                    System.out.println("Bad field: " + field.getName());
                }
            }
            field.setAccessible(true);
            Configurable configurable = field.getAnnotation(Configurable.class);
            String propName = configurable.name().isEmpty() ? field.getName() : configurable.name();
            Class<?> type = field.getType();
            if (handlers.containsKey(type)) {
                try {
                    Object result = handlers.get(type).read(propName, configurable.category(), configurable.description(), this.config, field.get(null));
                    field.set(null, result);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Wawla.LOG.info("Error handling configurable field! Could not read/write " + field.getName(), (Throwable)e);
                }
                continue;
            }
            Wawla.LOG.info("Unhandled type: " + type.getCanonicalName());
        }
        if (this.hasChanged()) {
            this.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase(this.name)) {
            this.sync();
        }
    }

    public boolean hasChanged() {
        return this.config.hasChanged();
    }

    public void save() {
        this.config.save();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static <T> void addReader(Class<T> type, Adapter<T> reader) {
        handlers.put(type, reader);
    }

    private static boolean readBoolean(String name, String category, String comment, Configuration config, boolean object) {
        return WawlaConfiguration.setComment(config.get(category, name, object), comment).getBoolean();
    }

    private static boolean[] readBooleanArray(String name, String category, String comment, Configuration config, boolean[] object) {
        return WawlaConfiguration.setComment(config.get(category, name, object), comment).getBooleanList();
    }

    private static double readDouble(String name, String category, String comment, Configuration config, double object) {
        return WawlaConfiguration.setComment(config.get(category, name, object), comment).getDouble();
    }

    private static double[] readDoubleArray(String name, String category, String comment, Configuration config, double[] object) {
        return WawlaConfiguration.setComment(config.get(category, name, object), comment).getDoubleList();
    }

    private static float readFloat(String name, String category, String comment, Configuration config, float object) {
        return (float)WawlaConfiguration.readDouble(name, category, comment, config, object);
    }

    private static float[] readFloatArray(String name, String category, String comment, Configuration config, float[] object) {
        return CollectionUtils.toFloat(WawlaConfiguration.readDoubleArray(name, category, comment, config, CollectionUtils.toDouble(object)));
    }

    private static int readInt(String name, String category, String comment, Configuration config, int object) {
        return WawlaConfiguration.setComment(config.get(category, name, object), comment).getInt();
    }

    private static int[] readIntArray(String name, String category, String comment, Configuration config, int[] object) {
        return WawlaConfiguration.setComment(config.get(category, name, object), comment).getIntList();
    }

    private static String readString(String name, String category, String comment, Configuration config, String object) {
        return WawlaConfiguration.setComment(config.get(category, name, object), comment).getString();
    }

    private static String[] readStringArray(String name, String category, String comment, Configuration config, String[] object) {
        return WawlaConfiguration.setComment(config.get(category, name, object), comment).getStringList();
    }

    private static ResourceLocation readIdentifier(String name, String category, String comment, Configuration config, ResourceLocation object) {
        return new ResourceLocation(WawlaConfiguration.readString(name, category, comment, config, object.toString()));
    }

    private static ResourceLocation[] readIdentifierArray(String name, String category, String comment, Configuration config, ResourceLocation[] object) {
        return CollectionUtils.toIdentifier(WawlaConfiguration.readStringArray(name, category, comment, config, CollectionUtils.toString(object)));
    }

    private static Item readItem(String name, String category, String comment, Configuration config, Item object) {
        return (Item)ForgeRegistries.ITEMS.getValue(WawlaConfiguration.readIdentifier(name, category, comment, config, object.getRegistryName()));
    }

    private static Item[] readItemArray(String name, String category, String comment, Configuration config, Item[] object) {
        return CollectionUtils.toItem(WawlaConfiguration.readIdentifierArray(name, category, comment, config, CollectionUtils.toIdentifier(object)));
    }

    private static Block readBlock(String name, String category, String comment, Configuration config, Block object) {
        return (Block)ForgeRegistries.BLOCKS.getValue(WawlaConfiguration.readIdentifier(name, category, comment, config, object.getRegistryName()));
    }

    private static Block[] readBlockArray(String name, String category, String comment, Configuration config, Block[] object) {
        return CollectionUtils.toBlock(WawlaConfiguration.readIdentifierArray(name, category, comment, config, CollectionUtils.toIdentifier(object)));
    }

    private static ItemStack readItemStack(String name, String category, String comment, Configuration config, ItemStack object) {
        return ItemStackUtils.createStackFromString(WawlaConfiguration.readString(name, category, comment, config, ItemStackUtils.writeStackToString(object)));
    }

    private static ItemStack[] readItemStackArray(String name, String category, String comment, Configuration config, ItemStack[] object) {
        return CollectionUtils.toStack(WawlaConfiguration.readStringArray(name, category, comment, config, CollectionUtils.toString(object)));
    }

    private static Color readColor(String name, String category, String comment, Configuration config, Color object) {
        return CollectionUtils.toColor(WawlaConfiguration.readIntArray(name, category, comment, config, CollectionUtils.toInt(object)));
    }

    private static BlockPos readPos(String name, String category, String comment, Configuration config, BlockPos object) {
        return CollectionUtils.toPos(WawlaConfiguration.readIntArray(name, category, comment, config, CollectionUtils.toInt(object)));
    }

    private static Property setComment(Property property, String comment) {
        property.setComment(comment);
        return property;
    }

    static {
        WawlaConfiguration.addReader(Boolean.TYPE, WawlaConfiguration::readBoolean);
        WawlaConfiguration.addReader(boolean[].class, WawlaConfiguration::readBooleanArray);
        WawlaConfiguration.addReader(Double.TYPE, WawlaConfiguration::readDouble);
        WawlaConfiguration.addReader(double[].class, WawlaConfiguration::readDoubleArray);
        WawlaConfiguration.addReader(Float.TYPE, WawlaConfiguration::readFloat);
        WawlaConfiguration.addReader(float[].class, WawlaConfiguration::readFloatArray);
        WawlaConfiguration.addReader(Integer.TYPE, WawlaConfiguration::readInt);
        WawlaConfiguration.addReader(int[].class, WawlaConfiguration::readIntArray);
        WawlaConfiguration.addReader(String.class, WawlaConfiguration::readString);
        WawlaConfiguration.addReader(String[].class, WawlaConfiguration::readStringArray);
        WawlaConfiguration.addReader(ResourceLocation.class, WawlaConfiguration::readIdentifier);
        WawlaConfiguration.addReader(ResourceLocation[].class, WawlaConfiguration::readIdentifierArray);
        WawlaConfiguration.addReader(Item.class, WawlaConfiguration::readItem);
        WawlaConfiguration.addReader(Item[].class, WawlaConfiguration::readItemArray);
        WawlaConfiguration.addReader(Block.class, WawlaConfiguration::readBlock);
        WawlaConfiguration.addReader(Block[].class, WawlaConfiguration::readBlockArray);
        WawlaConfiguration.addReader(ItemStack.class, WawlaConfiguration::readItemStack);
        WawlaConfiguration.addReader(ItemStack[].class, WawlaConfiguration::readItemStackArray);
        WawlaConfiguration.addReader(BlockPos.class, WawlaConfiguration::readPos);
        WawlaConfiguration.addReader(Color.class, WawlaConfiguration::readColor);
    }

    public static interface Adapter<T> {
        public T read(String var1, String var2, String var3, Configuration var4, T var5);
    }
}

