/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.utils;

import net.darkhax.wawla.utils.NBTUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemStackUtils {
    private ItemStackUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static NBTTagCompound prepareDataTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static ItemStack setLore(ItemStack stack, String[] lore) {
        ItemStackUtils.prepareDataTag(stack);
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagList loreList = new NBTTagList();
        if (!tag.func_150297_b("display", 10)) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        for (String line : lore) {
            loreList.func_74742_a((NBTBase)new NBTTagString(line));
        }
        tag.func_74775_l("display").func_74782_a("Lore", (NBTBase)loreList);
        stack.func_77982_d(tag);
        return stack;
    }

    public static String writeStackToString(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString() + "#" + stack.func_77952_i();
    }

    public static ItemStack createStackFromString(String stackString) {
        String[] parts = stackString.split("#");
        Object contents = ItemStackUtils.getThingByName(parts[0]);
        int damage = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        return contents instanceof Item ? new ItemStack((Item)contents, 1, damage) : new ItemStack((Block)contents, 1, damage);
    }

    public static boolean compareStackToOreName(ItemStack stack, String oreName) {
        for (int stackName : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)stackName).equalsIgnoreCase(oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean doStacksShareOreName(ItemStack firstStack, ItemStack secondStack) {
        for (int firstName : OreDictionary.getOreIDs((ItemStack)firstStack)) {
            for (int secondName : OreDictionary.getOreIDs((ItemStack)secondStack)) {
                if (firstName != secondName) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areStacksSimilar(ItemStack firstStack, ItemStack secondStack) {
        return firstStack == null && secondStack == null ? true : !firstStack.func_190926_b() && !secondStack.func_190926_b() && firstStack.func_77952_i() == secondStack.func_77952_i() && firstStack.func_77973_b() == secondStack.func_77973_b();
    }

    public static boolean areStacksSimilarWithSize(ItemStack firstStack, ItemStack secondStack) {
        return firstStack == null && secondStack == null ? true : !firstStack.func_190926_b() && !secondStack.func_190926_b() && firstStack.func_77952_i() == secondStack.func_77952_i() && firstStack.func_77973_b() == secondStack.func_77973_b() && firstStack.func_190916_E() == secondStack.func_190916_E();
    }

    public static ItemStack writePotionEffectsToStack(ItemStack stack, PotionEffect[] effects) {
        NBTTagCompound stackTag = ItemStackUtils.prepareDataTag(stack);
        NBTTagList potionTag = new NBTTagList();
        for (PotionEffect effect : effects) {
            potionTag.func_74742_a((NBTBase)effect.func_82719_a(new NBTTagCompound()));
        }
        stackTag.func_74782_a("CustomPotionEffects", (NBTBase)potionTag);
        return stack;
    }

    public static void writeStackToTag(ItemStack stack, NBTTagCompound tag, String tagName) {
        NBTTagCompound stackTag = new NBTTagCompound();
        stack.func_77955_b(stackTag);
        tag.func_74782_a(tagName, (NBTBase)stackTag);
    }

    public static ItemStack decreaseStackSize(ItemStack stack, int amount) {
        stack.func_190918_g(amount);
        return stack.func_190916_E() <= 0 ? ItemStack.field_190927_a : stack;
    }

    public static boolean areStacksEqual(ItemStack firstStack, ItemStack secondStack, boolean checkNBT) {
        if (firstStack == null || secondStack == null) {
            return firstStack == secondStack;
        }
        Item firstItem = firstStack.func_77973_b();
        Item secondItem = secondStack.func_77973_b();
        if (firstItem == null || secondItem == null) {
            return firstItem == secondItem;
        }
        if (firstItem == secondItem) {
            if (checkNBT && NBTUtils.NBT_COMPARATOR.compare(firstStack.func_77978_p(), secondStack.func_77978_p()) != 0) {
                return false;
            }
            return firstStack.func_77952_i() == Short.MAX_VALUE || secondStack.func_77952_i() == Short.MAX_VALUE || firstStack.func_77952_i() == secondStack.func_77952_i();
        }
        return false;
    }

    public static boolean isStackInArray(ItemStack stack, boolean checkNBT, ItemStack ... stacks) {
        for (ItemStack currentStack : stacks) {
            if (!ItemStackUtils.areStacksEqual(stack, currentStack, checkNBT)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack copyStackWithSize(ItemStack stack, int size) {
        ItemStack output = stack.func_77946_l();
        output.func_190920_e(size);
        return output;
    }

    public static Object getThingByName(String name) {
        Item thing = Item.func_111206_d((String)name);
        if (thing != null) {
            return thing;
        }
        thing = Block.func_149684_b((String)name);
        if (thing != null) {
            return thing;
        }
        return null;
    }

    public static Block getBlockFromStack(ItemStack stack) {
        return !stack.func_190926_b() ? Block.func_149634_a((Item)stack.func_77973_b()) : Blocks.field_150350_a;
    }

    public static ItemStack consumeStack(ItemStack stack) {
        if (stack.func_190916_E() == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return ItemStack.field_190927_a;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static void dropStackInWorld(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float offset = 0.7f;
            double offX = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double offY = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double offZ = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + offX, (double)pos.func_177956_o() + offY, (double)pos.func_177952_p() + offZ, stack);
            entityitem.func_174867_a(10);
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static ItemStack createStackFromTileEntity(TileEntity tile) {
        ItemStack stack = new ItemStack(tile.func_145838_q(), 1, tile.func_145832_p());
        ItemStackUtils.prepareDataTag(stack);
        NBTTagCompound tileTag = tile.func_189515_b(new NBTTagCompound());
        stack.func_77978_p().func_74782_a("TileData", (NBTBase)tileTag);
        return stack;
    }

    public static void readTileEntityFromStack(TileEntity tile, ItemStack stack) {
        tile.func_145839_a(stack.func_77978_p().func_74775_l("TileData"));
    }

    public static ItemStack getStackFromState(IBlockState state, int size) {
        return new ItemStack(state.func_177230_c(), size, state.func_177230_c().func_176201_c(state));
    }
}

