/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.StarvationAhoy.Meat;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dmfmm.StarvationAhoy.Meat.MeatType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MeatRegistry {
    public Map<Integer, MeatType> meatTypeMap = new HashMap<Integer, MeatType>();

    public MeatType getMeatTypeForId(int id) {
        return this.meatTypeMap.get(id);
    }

    public boolean meatTypeExistsAndEditable(int id) {
        return this.meatTypeMap.containsKey(id) && !this.getMeatTypeForId((int)id).constructed;
    }

    public boolean constructedMeatTypeExists(int id) {
        return this.meatTypeExists(id) && this.getMeatTypeForId((int)id).constructed;
    }

    public boolean meatTypeExists(int id) {
        return this.meatTypeMap.containsKey(id);
    }

    public void newMeatType(int id) {
        this.meatTypeMap.put(id, new MeatType(id));
    }

    public void addMeatType(MeatType t) {
        this.meatTypeMap.put(t.id, t);
    }

    @SideOnly(value=Side.CLIENT)
    public void onMeatType(int id, ModelBase modelEntity, String normalTexture, String skinnedTexture, String rottenTexture) {
        if (this.meatTypeExistsAndEditable(id)) {
            this.getMeatTypeForId(id).doMeatType(modelEntity, normalTexture, skinnedTexture, rottenTexture);
        } else {
            if (this.meatTypeExists(id)) {
                throw new IllegalArgumentException("The meat type id has already been constructed, therefore it cannot be edited");
            }
            this.newMeatType(id);
            this.getMeatTypeForId(id).doMeatType(modelEntity, normalTexture, skinnedTexture, rottenTexture);
        }
    }

    public void onDeadEntity(int id, Class<? extends EntityLiving> entity, Item dead, Item skinned, Item meat, Item skin) {
        if (this.meatTypeExistsAndEditable(id)) {
            this.getMeatTypeForId(id).doDeadEntity(entity, dead, skinned, meat, skin);
        } else {
            if (this.meatTypeExists(id)) {
                throw new IllegalArgumentException("The meat type id has already been constructed, therefore it cannot be edited");
            }
            this.newMeatType(id);
            this.getMeatTypeForId(id).doDeadEntity(entity, dead, skinned, meat, skin);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBase getModel(int id) {
        if (this.constructedMeatTypeExists(id)) {
            return this.getMeatTypeForId((int)id).deadModel;
        }
        return null;
    }

    public Collection<Integer> meatIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (MeatType meatType : this.meatTypeMap.values()) {
            ids.add(meatType.id);
        }
        return ids;
    }

    public Class<? extends EntityLiving> getEntity(int id) {
        if (this.constructedMeatTypeExists(id)) {
            return this.getMeatTypeForId((int)id).entity;
        }
        return null;
    }

    public MeatReturn overrideFoodDropsFor(EntityLiving entity) {
        for (int id : this.meatIds()) {
            if (this.getEntity(id) == null || !entity.getClass().equals(this.getEntity(id))) continue;
            return new MeatReturn(true, this.getMeatTypeForId(id), id);
        }
        return new MeatReturn(false, null, 0);
    }

    public MeatReturn isMeatItem(ItemStack is) {
        for (int id : this.meatIds()) {
            if (this.getMeatTypeForId(id) == null || is.func_77973_b().func_77658_a() != this.getMeatTypeForId((int)id).items.dead.func_77658_a()) continue;
            return new MeatReturn(true, this.getMeatTypeForId(id), id);
        }
        return new MeatReturn(false, null, 0);
    }

    public MeatReturn isSkinnedItem(ItemStack is) {
        if (is == null) {
            return new MeatReturn(false, null, 0);
        }
        for (int id : this.meatIds()) {
            if (this.getMeatTypeForId(id) == null || this.getMeatTypeForId((int)id).items.skinned == null || !is.func_77973_b().func_77658_a().equals(this.getMeatTypeForId((int)id).items.skinned.func_77658_a())) continue;
            return new MeatReturn(true, this.getMeatTypeForId(id), id);
        }
        return new MeatReturn(false, null, 0);
    }

    public MeatReturn isCookedItem(ItemStack is) {
        if (is == null) {
            return new MeatReturn(false, null, 0);
        }
        for (int id : this.meatIds()) {
            if (this.getMeatTypeForId(id) == null || this.getMeatTypeForId((int)id).items.meat == null || !is.func_77973_b().func_77658_a().equals(this.getMeatTypeForId((int)id).items.meat.func_77658_a())) continue;
            return new MeatReturn(true, this.getMeatTypeForId(id), id);
        }
        return new MeatReturn(false, null, 0);
    }

    public static class MeatReturn {
        public boolean value;
        public MeatType meat;
        public int meatID;

        public MeatReturn(boolean value, MeatType meat, int meatID) {
            this.value = value;
            this.meat = meat;
            this.meatID = meatID;
        }
    }
}

