/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.StarvationAhoy.FoodStats.PlayerDiet;

import dmfmm.StarvationAhoy.Core.util.SALog;
import dmfmm.StarvationAhoy.FoodStats.FileFormats.IntLoadFormat;
import dmfmm.StarvationAhoy.FoodStats.FileManage.SaveFileLoad;
import dmfmm.StarvationAhoy.FoodStats.FoodStat;
import dmfmm.StarvationAhoy.FoodStats.FoodStatRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.util.MathHelper;

public class Diet {
    public float nutrient1;
    public float nutrient2;
    public float nutrient;
    public float calories;
    public float fat;
    public float weight;
    public String playername;
    public UUID playeruuid;
    public IntLoadFormat t;

    public Diet(String playername, UUID playeruuid, Random r) {
        this.playername = playername;
        this.playeruuid = playeruuid;
        this.t = new IntLoadFormat(SaveFileLoad.getFileFrom("stats/" + playeruuid.toString()));
        try {
            this.load();
        }
        catch (IOException | NullPointerException e) {
            try {
                this.calories = (float)MathHelper.func_82716_a((Random)r, (double)1500.0, (double)1700.0);
                this.nutrient1 = 70.0f;
                this.nutrient2 = 70.0f;
                this.fat = 0.0f;
                this.calculateNutrient();
                this.calculateWeight();
                this.save();
            }
            catch (IOException e1) {
                SALog.fatal("Failed to create a user's diet. THIS IS BAD!!!");
            }
        }
    }

    public void eatFood(Item item) {
        FoodStat t = FoodStatRegistry.instance.registry.get(item);
        this.nutrient1 += t.nutrient1;
        this.nutrient2 += t.nutrient2;
        this.calories += t.calories;
        this.fat += t.fat;
        this.calculateNutrient();
        this.calculateWeight();
        System.out.println(this.weight);
    }

    public void dump() {
        this.t.dump();
    }

    public void load() throws IOException {
        this.t.dump();
        this.t.undump();
        this.t.load();
        this.nutrient1 = this.t.data.get("nut1").floatValue();
        this.nutrient2 = this.t.data.get("nut2").floatValue();
        this.calories = this.t.data.get("cal").floatValue();
        this.fat = this.t.data.get("fat").floatValue();
        this.weight = this.t.data.get("wht").floatValue();
        this.calculateNutrient();
    }

    public void save() throws IOException {
        HashMap<String, Float> data = new HashMap<String, Float>();
        data.put("nut1", Float.valueOf(this.nutrient1));
        data.put("nut2", Float.valueOf(this.nutrient2));
        data.put("cal", Float.valueOf(this.calories));
        data.put("fat", Float.valueOf(this.fat));
        data.put("wht", Float.valueOf(this.weight));
        this.t.data = data;
        this.t.save();
    }

    public void calculateWeight() {
        this.weight = 200.0f;
        float dif = 0.0f;
        dif = 1200.0f <= this.calories && this.calories <= 2000.0f ? (this.calories < 1600.0f ? (float)(-(6.0E-5 * Math.pow(this.calories - 1600.0f, 2.0))) : (float)(6.0E-5 * Math.pow(this.calories - 1600.0f, 2.0))) : (this.calories > 2000.0f ? (float)(9.0E-4 * Math.pow(this.calories - 2000.0f, 2.0) + 10.0) : (float)(-(9.0E-4 * Math.pow(this.calories - 1200.0f, 2.0) + 10.0)));
        this.weight += dif;
        dif = 0.0f;
        dif = (float)(4.0E-4 * Math.pow(this.fat, 2.0));
        this.weight += dif;
        dif = 0.0f;
        if (this.nutrient > 100.0f) {
            dif = (float)(5.0E-4 * Math.pow(this.nutrient - 100.0f, 2.0));
        } else if (this.nutrient < 50.0f) {
            dif = (float)(0.004 * Math.pow(this.nutrient - 50.0f, 2.0));
        }
        System.out.println(dif);
        this.weight += dif;
    }

    public void calculateNutrient() {
        float nut2min = 0.4f * this.nutrient1;
        float nut1min = 0.4f * this.nutrient2;
        float nut2minhar = 0.1f * this.nutrient1;
        float nut1minhar = 0.1f * this.nutrient2;
        ArrayList<Float> vals = new ArrayList<Float>();
        if (this.nutrient1 < nut1min) {
            vals.add(Float.valueOf(this.nutrient1));
        }
        if (this.nutrient1 < nut1minhar) {
            vals.add(Float.valueOf(this.nutrient1));
        }
        vals.add(Float.valueOf(this.nutrient1));
        if (this.nutrient2 < nut2min) {
            vals.add(Float.valueOf(this.nutrient2));
        }
        if (this.nutrient2 < nut2minhar) {
            vals.add(Float.valueOf(this.nutrient2));
        }
        vals.add(Float.valueOf(this.nutrient2));
        float sumy = 0.0f;
        Iterator i$ = vals.iterator();
        while (i$.hasNext()) {
            float i = ((Float)i$.next()).floatValue();
            sumy += i;
        }
        this.nutrient = sumy / (float)vals.size();
    }
}

