/*
 * Decompiled with CFR 0.152.
 */
package radixcore.core;

import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import radixcore.core.RadixCore;

public abstract class ModCrashWatcher {
    private final long startupTimestamp = new Date().getTime();

    public void checkForCrashReports() {
        File crashReportsFolder = new File(RadixCore.getRunningDirectory() + "/crash-reports/");
        try {
            File[] files = crashReportsFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile();
                }
            });
            long lastModifiedTime = Long.MIN_VALUE;
            File lastModifiedFile = null;
            for (File file : files) {
                if (file.lastModified() <= lastModifiedTime) continue;
                lastModifiedFile = file;
                lastModifiedTime = file.lastModified();
            }
            if (lastModifiedTime > this.startupTimestamp) {
                this.onCrash(lastModifiedFile);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected abstract void onCrash(File var1);
}

