/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.List;
import mca.ai.AISleep;
import mca.ai.AbstractAI;
import mca.entity.EntityHuman;
import mca.enums.EnumMovementState;
import mca.enums.EnumWorkdayState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class AIWorkday
extends AbstractAI {
    private EnumWorkdayState state = EnumWorkdayState.IDLE;
    private Vec3 vecTarget;
    private EntityLivingBase lookTarget;
    private int ticksActive;

    public AIWorkday(EntityHuman owner) {
        super(owner);
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (this.owner.getMovementState() == EnumMovementState.STAY || this.owner.getMovementState() == EnumMovementState.FOLLOW || this.owner.getAI(AISleep.class).getIsSleeping() || this.owner.getAIManager().isToggleAIActive()) {
            if (this.owner.getMovementState() == EnumMovementState.STAY) {
                this.handleWatchClosestPlayer();
            }
            return;
        }
        switch (this.state) {
            case MOVE_INDOORS: {
                this.handleMoveIndoors();
                break;
            }
            case WANDER: {
                this.handleWander();
                break;
            }
            case WATCH_CLOSEST_ANYTHING: {
                this.handleWatchClosestAnything();
                break;
            }
            case WATCH_CLOSEST_PLAYER: {
                this.handleWatchClosestPlayer();
                break;
            }
            case IDLE: {
                this.handleIdle();
            }
        }
        ++this.ticksActive;
        if (this.ticksActive % 300 == 0 && RadixLogic.getBooleanWithProbability((int)30)) {
            this.ticksActive = 0;
            this.state = EnumWorkdayState.getRandom();
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("state", this.state.getId());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.state = EnumWorkdayState.getById(nbt.func_74762_e("state"));
    }

    private void handleMoveIndoors() {
        this.handleLook();
        this.handleWander();
    }

    private void handleWander() {
        this.handleLook();
        if (this.vecTarget == null && this.ticksActive % (20 * (this.owner.func_70681_au().nextInt(5) + 5)) == 0) {
            this.vecTarget = RandomPositionGenerator.func_75463_a((EntityCreature)this.owner, (int)7, (int)5);
            this.owner.func_70661_as().func_75484_a(null, 0.0);
        } else if (this.vecTarget != null) {
            if (this.owner.func_70661_as().func_75500_f()) {
                this.owner.func_70661_as().func_75492_a(this.vecTarget.field_72450_a, this.vecTarget.field_72448_b, this.vecTarget.field_72449_c, 0.5);
            }
            if (this.ticksActive % 200 == 0) {
                this.vecTarget = null;
            }
        }
    }

    private void handleWatchClosestAnything() {
        this.efficientGetLookTarget(false);
        this.lookAtLookTarget();
    }

    private void handleWatchClosestPlayer() {
        this.efficientGetLookTarget(true);
        this.lookAtLookTarget();
    }

    private void handleIdle() {
        this.handleLook();
    }

    private void handleLook() {
        this.efficientGetLookTarget(true);
        if (this.lookTarget instanceof EntityPlayer) {
            this.lookAtLookTarget();
        }
    }

    private void efficientGetLookTarget(boolean playerOnly) {
        if (this.ticksActive % 20 / 2 == 0) {
            if (this.lookTarget != null && RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)this.lookTarget) > 3.0) {
                this.lookTarget = null;
            }
            this.getLookTarget(playerOnly);
        }
    }

    private void getLookTarget(boolean playerOnly) {
        Class entityClass = playerOnly ? EntityPlayer.class : EntityLivingBase.class;
        int maxDistanceAway = 3;
        List entitiesAroundMe = this.owner.field_70170_p.func_72872_a(entityClass, AxisAlignedBB.func_72330_a((double)(this.owner.field_70165_t - 3.0), (double)(this.owner.field_70163_u - 3.0), (double)(this.owner.field_70161_v - 3.0), (double)(this.owner.field_70165_t + 3.0), (double)(this.owner.field_70163_u + 3.0), (double)(this.owner.field_70161_v + 3.0)));
        double lastDistance = 100.0;
        Entity target = null;
        for (Entity entity : entitiesAroundMe) {
            double dist;
            if (entity == this.owner || !((dist = RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)entity)) < lastDistance)) continue;
            lastDistance = dist;
            target = entity;
        }
        this.lookTarget = (EntityLivingBase)target;
    }

    private void lookAtLookTarget() {
        if (this.lookTarget != null) {
            this.owner.func_70671_ap().func_75651_a((Entity)this.lookTarget, 9.0f, 3.0f);
        }
    }
}

