/*
 * Decompiled with CFR 0.152.
 */
package mca.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mca.ai.AISleep;
import mca.core.minecraft.ModItems;
import mca.entity.EntityHuman;
import mca.enums.EnumBedColor;
import mca.enums.EnumSleepingState;
import mca.tile.TileVillagerBed;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.Direction;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;

public class BlockVillagerBed
extends BlockDirectional
implements ITileEntityProvider {
    public static final int[][] blockMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] textureEnd;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] textureSide;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] textureTop;
    private EnumBedColor bedColor;

    public BlockVillagerBed(EnumBedColor bedColor) {
        super(Material.field_151580_n);
        this.setBlockBounds();
        this.bedColor = bedColor;
        GameRegistry.registerBlock((Block)this, (String)("BlockVillagerBed" + bedColor.toString()));
    }

    public boolean func_149727_a(World worldObj, int posX, int posY, int posZ, EntityPlayer entityPlayer, int unknown, float unknown2, float unknown3, float unknown4) {
        if (worldObj.field_72995_K) {
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("You cannot sleep in a villager's bed."));
        }
        return true;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return new ItemStack(this.func_149650_a(0, player.func_70681_au(), 0));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int i1;
        if (side == 0) {
            return Blocks.field_150344_f.func_149733_h(side);
        }
        int k = BlockVillagerBed.func_149895_l((int)meta);
        int l = Direction.field_71584_h[k][side];
        int n = i1 = BlockVillagerBed.isBlockHeadOfBed(meta) ? 1 : 0;
        return !(i1 == 1 && l == 2 || i1 == 0 && l == 3) ? (l != 5 && l != 4 ? this.textureTop[i1] : this.textureSide[i1]) : this.textureEnd[i1];
    }

    public int func_149645_b() {
        return 14;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess world, int posX, int posY, int posZ) {
        this.setBlockBounds();
    }

    public void func_149695_a(World worldObj, int posX, int posY, int posZ, Block block) {
        int l = BlockHelper.getBlockMetadata((World)worldObj, (int)posX, (int)posY, (int)posZ);
        int i1 = BlockVillagerBed.func_149895_l((int)l);
        if (BlockVillagerBed.isBlockHeadOfBed(l)) {
            if (BlockHelper.getBlock((World)worldObj, (int)(posX - blockMap[i1][0]), (int)posY, (int)(posZ - blockMap[i1][1])) != this) {
                BlockHelper.setBlock((World)worldObj, (int)posX, (int)posY, (int)posZ, (Block)Blocks.field_150350_a);
            }
        } else if (BlockHelper.getBlock((World)worldObj, (int)(posX + blockMap[i1][0]), (int)posY, (int)(posZ + blockMap[i1][1])) != this) {
            BlockHelper.setBlock((World)worldObj, (int)posX, (int)posY, (int)posZ, (Block)Blocks.field_150350_a);
            if (!worldObj.field_72995_K) {
                this.func_149697_b(worldObj, posX, posY, posZ, l, 0);
            }
        }
    }

    public Item func_149650_a(int id, Random rand, int meta) {
        switch (this.bedColor) {
            case BLUE: {
                return ModItems.bedBlue;
            }
            case GREEN: {
                return ModItems.bedGreen;
            }
            case PINK: {
                return ModItems.bedPink;
            }
            case PURPLE: {
                return ModItems.bedPurple;
            }
            case RED: {
                return ModItems.bedRed;
            }
        }
        return null;
    }

    private void setBlockBounds() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5625f, 1.0f);
    }

    public TileEntity func_149915_a(World world, int unknown) {
        return new TileVillagerBed();
    }

    public static boolean isBlockHeadOfBed(int meta) {
        return (meta & 8) != 0;
    }

    public static boolean isBlockFootOfBed(int meta) {
        return (meta & 4) != 0;
    }

    public void func_149690_a(World world, int posX, int posY, int posZ, int meta, float unknownF, int unknownI) {
        if (!BlockVillagerBed.isBlockHeadOfBed(meta)) {
            super.func_149690_a(world, posX, posY, posZ, meta, unknownF, 0);
        }
    }

    public int func_149656_h() {
        return 1;
    }

    public void func_149681_a(World world, int posX, int posY, int posZ, int meta, EntityPlayer entityPlayer) {
        int direction;
        if (entityPlayer.field_71075_bZ.field_75098_d && BlockVillagerBed.isBlockHeadOfBed(meta) && BlockHelper.getBlock((World)world, (int)(posX -= blockMap[direction = BlockVillagerBed.func_149895_l((int)meta)][0]), (int)posY, (int)(posZ -= blockMap[direction][1])) == this) {
            BlockHelper.setBlock((World)world, (int)posX, (int)posY, (int)posZ, (Block)Blocks.field_150350_a);
        }
    }

    public void func_149725_f(World world, int posX, int posY, int posZ, int meta) {
        TileVillagerBed villagerBed;
        TileEntity tileEntity;
        super.func_149725_f(world, posX, posY, posZ, meta);
        if (!world.field_72995_K && (tileEntity = BlockHelper.getTileEntity((World)world, (int)posX, (int)posY, (int)posZ)) instanceof TileVillagerBed && (villagerBed = (TileVillagerBed)tileEntity).getSleepingVillagerId() != -1) {
            try {
                EntityHuman entity = (EntityHuman)RadixLogic.getEntityByPermanentId((World)world, (int)villagerBed.getSleepingVillagerId());
                if (entity != null) {
                    AISleep sleepAI = entity.getAI(AISleep.class);
                    sleepAI.setSleepingState(EnumSleepingState.INTERRUPTED);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textureTop = new IIcon[]{iconRegister.func_94245_a("mca:VillagerBed-Feet-Top-" + this.bedColor.toString()), iconRegister.func_94245_a("mca:VillagerBed-Head-Top-" + this.bedColor.toString())};
        this.textureEnd = new IIcon[]{iconRegister.func_94245_a("mca:VillagerBed-Feet-End-" + this.bedColor.toString()), iconRegister.func_94245_a("mca:VillagerBed-Head-End")};
        this.textureSide = new IIcon[]{iconRegister.func_94245_a("mca:VillagerBed-Feet-Side-" + this.bedColor.toString()), iconRegister.func_94245_a("mca:VillagerBed-Head-Side-" + this.bedColor.toString())};
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int posX, int posY, int posZ) {
        return Items.field_151104_aV;
    }
}

