/*
 * Decompiled with CFR 0.152.
 */
package radixcore.data;

import java.io.Serializable;
import radixcore.core.RadixCore;
import radixcore.data.DataWatcherEx;
import radixcore.data.WatchedBoolean;

public abstract class AbstractWatched
implements Serializable {
    protected DataWatcherEx dataWatcher;
    protected int dataWatcherId;

    protected AbstractWatched(Object value, DataWatcherEx dataWatcher, int dataWatcherId) {
        if (this.dataWatcher != null) {
            throw new UnsupportedOperationException("Watched object is already initialized!");
        }
        if (this instanceof WatchedBoolean) {
            value = (Boolean)value == false ? 0 : 1;
        }
        this.dataWatcher = dataWatcher;
        this.dataWatcherId = dataWatcherId;
        dataWatcher.addObject(dataWatcherId, value);
    }

    public Byte getByte() {
        return this.dataWatcher.getWatchableObjectByte(this.dataWatcherId);
    }

    public Float getFloat() {
        return Float.valueOf(this.dataWatcher.getWatchableObjectFloat(this.dataWatcherId));
    }

    public String getString() {
        return this.dataWatcher.getWatchableObjectString(this.dataWatcherId);
    }

    public int getInt() {
        return this.dataWatcher.getWatchableObjectInt(this.dataWatcherId);
    }

    public Short getShort() {
        return this.dataWatcher.getWatchableObjectShort(this.dataWatcherId);
    }

    public Boolean getBoolean() {
        return this.dataWatcher.getWatchableObjectInt(this.dataWatcherId) != 0;
    }

    public void setValue(Object value) {
        if (value instanceof Boolean) {
            value = (Boolean)value == false ? 0 : 1;
        }
        this.dataWatcher.updateObject(this.dataWatcherId, value, !RadixCore.isTesting);
    }
}

