/*
 * Decompiled with CFR 0.152.
 */
package radixcore.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import radixcore.core.ModMetadataEx;
import radixcore.core.RadixCore;
import radixcore.data.AbstractPlayerData;
import radixcore.data.DataContainer;
import radixcore.data.DataWatcherEx;
import radixcore.data.IWatchable;
import radixcore.network.ByteBufIO;
import radixcore.packets.AbstractPacket;
import radixcore.util.RadixExcept;
import radixcore.util.RadixReflect;

public class PacketWatchedUpdateC
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketWatchedUpdateC, IMessage> {
    private int entityId;
    private String modId;
    private int watchedId;
    private Object watchedValue;

    public PacketWatchedUpdateC() {
    }

    public PacketWatchedUpdateC(int entityId, int watchedId, Object watchedValue) {
        this.entityId = entityId;
        this.watchedId = watchedId;
        this.watchedValue = watchedValue;
    }

    public PacketWatchedUpdateC(String modId, int watchedId, Object watchedValue) {
        this.modId = modId;
        this.watchedId = watchedId;
        this.watchedValue = watchedValue;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
        this.modId = (String)ByteBufIO.readObject(byteBuf);
        this.watchedId = byteBuf.readInt();
        this.watchedValue = ByteBufIO.readObject(byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        ByteBufIO.writeObject(byteBuf, this.modId);
        byteBuf.writeInt(this.watchedId);
        ByteBufIO.writeObject(byteBuf, this.watchedValue);
    }

    public IMessage onMessage(PacketWatchedUpdateC packet, MessageContext context) {
        try {
            IWatchable watchable = null;
            if (packet.modId != null) {
                ModMetadataEx modData = null;
                for (ModMetadataEx data : RadixCore.getRegisteredMods()) {
                    if (!data.modId.equals(packet.modId)) continue;
                    modData = data;
                }
                if (modData != null) {
                    DataContainer container = RadixReflect.getStaticObjectOfTypeFromClass(DataContainer.class, modData.classContainingClientDataContainer);
                    watchable = container != null ? container.getPlayerData(AbstractPlayerData.class) : null;
                }
            } else {
                watchable = (IWatchable)this.getPlayer((MessageContext)context).field_70170_p.func_73045_a(packet.entityId);
            }
            if (watchable != null) {
                DataWatcherEx dataWatcherEx = watchable.getDataWatcherEx();
                dataWatcherEx.updateObject(packet.watchedId, packet.watchedValue, false);
            }
        }
        catch (Throwable e) {
            RadixExcept.logErrorCatch(e, "Non-fatal error caught while updating watched object server-side.");
        }
        return null;
    }
}

