/*
 * Decompiled with CFR 0.152.
 */
package radixcore.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import radixcore.core.ModMetadataEx;
import radixcore.core.RadixCore;
import radixcore.data.AbstractPlayerData;
import radixcore.data.DataContainer;
import radixcore.data.DataWatcherEx;
import radixcore.data.IWatchable;
import radixcore.network.ByteBufIO;
import radixcore.packets.AbstractPacket;
import radixcore.util.RadixExcept;
import radixcore.util.RadixReflect;

public class PacketWatchedUpdateS
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketWatchedUpdateS, IMessage> {
    private int entityId;
    private String modId;
    private int watchedId;
    private Object watchedValue;

    public PacketWatchedUpdateS() {
    }

    public PacketWatchedUpdateS(int entityId, int watchedId, Object watchedValue) {
        this.entityId = entityId;
        this.watchedId = watchedId;
        this.watchedValue = watchedValue;
    }

    public PacketWatchedUpdateS(String modId, int watchedId, Object watchedValue) {
        this.modId = modId;
        this.watchedId = watchedId;
        this.watchedValue = watchedValue;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
        this.modId = (String)ByteBufIO.readObject(byteBuf);
        this.watchedId = byteBuf.readInt();
        this.watchedValue = ByteBufIO.readObject(byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        ByteBufIO.writeObject(byteBuf, this.modId);
        byteBuf.writeInt(this.watchedId);
        ByteBufIO.writeObject(byteBuf, this.watchedValue);
    }

    public IMessage onMessage(PacketWatchedUpdateS packet, MessageContext context) {
        try {
            EntityPlayer player = this.getPlayer(context);
            IWatchable watchable = null;
            if (packet.modId != null) {
                ModMetadataEx modData = null;
                for (ModMetadataEx data : RadixCore.getRegisteredMods()) {
                    if (!data.modId.equals(packet.modId)) continue;
                    modData = data;
                }
                if (modData != null) {
                    if (!MinecraftServer.func_71276_C().func_71262_S()) {
                        DataContainer container = RadixReflect.getStaticObjectOfTypeFromClass(DataContainer.class, modData.classContainingClientDataContainer);
                        watchable = container.getPlayerData(AbstractPlayerData.class);
                    } else {
                        watchable = modData.getPlayerData(player);
                    }
                }
            } else {
                watchable = (IWatchable)player.field_70170_p.func_73045_a(packet.entityId);
            }
            if (watchable != null) {
                DataWatcherEx dataWatcherEx = watchable.getDataWatcherEx();
                dataWatcherEx.updateObject(packet.watchedId, packet.watchedValue, true);
            }
        }
        catch (Throwable e) {
            RadixExcept.logErrorCatch(e, "Non-fatal error caught while updating watched object server-side.");
        }
        return null;
    }
}

