/*
 * Decompiled with CFR 0.152.
 */
package radixcore.update;

import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import radixcore.core.ModMetadataEx;
import radixcore.core.RadixCore;
import radixcore.update.IUpdateProtocol;
import radixcore.update.UpdateData;

public final class UpdateChecker
implements Runnable {
    private final ModMetadataEx exData;
    private final ICommandSender commandSender;
    private boolean hasCheckedForUpdates;

    public UpdateChecker(ModMetadataEx exData, ICommandSender commandSender) {
        this.exData = exData;
        this.commandSender = commandSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.hasCheckedForUpdates && this.exData.updateProtocolClass != null) {
                RadixCore.getLogger().info("Checking if updates available for " + this.exData.name + "...");
                IUpdateProtocol updateProtocol = this.exData.updateProtocolClass.newInstance();
                UpdateData updateData = updateProtocol.getUpdateData(this.exData);
                if (!(updateData.minecraftVersion + "-" + updateData.modVersion).equals(this.exData.version)) {
                    String messageUpdateVersion = "\u00a72" + this.exData.name + " " + updateData.modVersion + "\u00a7E" + " for " + "\u00a72" + "Minecraft " + updateData.minecraftVersion + "\u00a7E" + " is available.";
                    String messageUpdateURL = "\u00a7EClick \u00a79\u00a7o\u00a7nhere\u00a7r\u00a7E to download the update for " + this.exData.name + ".";
                    ChatComponentText chatComponentUpdate = new ChatComponentText(messageUpdateURL);
                    chatComponentUpdate.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this.exData.url));
                    chatComponentUpdate.func_150256_b().func_150228_d(Boolean.valueOf(true));
                    this.commandSender.func_145747_a((IChatComponent)new ChatComponentText(messageUpdateVersion));
                    this.commandSender.func_145747_a((IChatComponent)chatComponentUpdate);
                }
                updateProtocol.cleanUp();
            }
        }
        catch (Exception e) {
            RadixCore.getLogger().error("Unexpected exception during update checking for " + this.exData.name + ". Error was: " + e.getMessage());
        }
        finally {
            this.hasCheckedForUpdates = true;
        }
    }
}

