/*
 * Decompiled with CFR 0.152.
 */
package radixcore.util;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import radixcore.math.Point3D;

public final class BlockHelper {
    public static void setBlock(World world, Point3D point, Block block) {
        BlockHelper.setBlock(world, point.iPosX, point.iPosY, point.iPosZ, block, 0);
    }

    public static void setBlock(World world, int posX, int posY, int posZ, Block block) {
        BlockHelper.setBlock(world, posX, posY, posZ, block, 0);
    }

    public static void setBlock(World world, int posX, int posY, int posZ, Block block, int meta) {
        world.func_147465_d(posX, posY, posZ, block, meta, 2);
    }

    public static Block getBlock(World world, Point3D point) {
        return BlockHelper.getBlock(world, point.iPosX, point.iPosY, point.iPosZ);
    }

    public static Block getBlock(World world, int posX, int posY, int posZ) {
        return world.func_147439_a(posX, posY, posZ);
    }

    public static void setBlockMetadataWithNotify(World world, int posX, int posY, int posZ, int meta, int flags) {
        world.func_72921_c(posX, posY, posZ, meta, flags);
    }

    public static int getBlockMetadata(World world, Point3D point) {
        return BlockHelper.getBlockMetadata(world, point.iPosX, point.iPosY, point.iPosZ);
    }

    public static int getBlockMetadata(World world, int posX, int posY, int posZ) {
        return world.func_72805_g(posX, posY, posZ);
    }

    public static void updateFurnaceState(boolean stateValue, World world, int posX, int posY, int posZ) {
        BlockFurnace.func_149931_a((boolean)stateValue, (World)world, (int)posX, (int)posY, (int)posZ);
    }

    public static boolean doesBlockHaveSolidTopSurface(World world, int posX, int posY, int posZ) {
        return World.func_147466_a((IBlockAccess)world, (int)posX, (int)posY, (int)posZ);
    }

    public static TileEntity getTileEntity(World world, int posX, int posY, int posZ) {
        return world.func_147438_o(posX, posY, posZ);
    }

    public static boolean canBlockSeeTheSky(World world, int posX, int posY, int posZ) {
        return world.func_72937_j(posX, posY, posZ);
    }

    private BlockHelper() {
    }
}

