/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import mca.ai.AbstractAI;
import mca.entity.EntityHuman;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import radixcore.data.WatchedBoolean;
import radixcore.data.WatchedInt;
import radixcore.util.RadixLogic;

public class AIConverse
extends AbstractAI {
    private static final int START_INTERVAL = 600;
    private static final int PROGRESS_INTERVAL = 80;
    private static final int NUMBER_OF_CONVERSATIONS = 2;
    private final WatchedInt conversationID;
    private final WatchedInt conversationProgress;
    private final WatchedInt conversationTarget;
    private final WatchedBoolean isConversationActive;
    private int timeUntilAdvance = 600;
    private int conversationSize = 0;

    public AIConverse(EntityHuman owner) {
        super(owner);
        this.conversationID = new WatchedInt(0, 33, owner.getDataWatcherEx());
        this.conversationProgress = new WatchedInt(0, 34, owner.getDataWatcherEx());
        this.conversationTarget = new WatchedInt(0, 35, owner.getDataWatcherEx());
        this.isConversationActive = new WatchedBoolean(false, 36, owner.getDataWatcherEx());
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
    }

    @Override
    public void reset() {
        EntityHuman target = (EntityHuman)RadixLogic.getEntityByPermanentId((World)this.owner.field_70170_p, (int)this.conversationTarget.getInt());
        if (target != null) {
            AIConverse otherAI = target.getAI(AIConverse.class);
            otherAI.setConversationTarget(0);
            otherAI.reset();
        }
        this.isConversationActive.setValue((Object)false);
        this.conversationTarget.setValue((Object)0);
        this.conversationProgress.setValue((Object)0);
        this.conversationID.setValue((Object)0);
        this.conversationSize = 0;
        this.timeUntilAdvance = 600;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("conversationID", this.conversationID.getInt());
        nbt.func_74768_a("conversationProgress", this.conversationProgress.getInt());
        nbt.func_74768_a("conversationTarget", this.conversationTarget.getInt());
        nbt.func_74757_a("isConversationActive", this.isConversationActive.getBoolean().booleanValue());
        nbt.func_74768_a("timeUntilAdvance", this.timeUntilAdvance);
        nbt.func_74768_a("conversationSize", this.conversationSize);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.conversationID.setValue((Object)nbt.func_74762_e("conversationID"));
        this.conversationProgress.setValue((Object)nbt.func_74762_e("conversationProgress"));
        this.conversationTarget.setValue((Object)nbt.func_74762_e("conversationTarget"));
        this.isConversationActive.setValue((Object)nbt.func_74767_n("isConversationActive"));
        this.timeUntilAdvance = nbt.func_74762_e("timeUntilAdvance");
        this.conversationSize = nbt.func_74762_e("conversationSize");
    }

    public void setConversationActive(boolean value) {
        this.isConversationActive.setValue((Object)value);
    }

    public void setConversationID(int id) {
        this.conversationID.setValue((Object)id);
    }

    public void setConversationTarget(int id) {
        this.conversationTarget.setValue((Object)id);
    }

    public void setConversationProgress(int id) {
        this.conversationProgress.setValue((Object)id);
    }

    public void setConversationAdvanceTime(int value) {
        this.timeUntilAdvance = value;
    }

    public void setConversationSize(int value) {
        this.conversationSize = value;
    }

    public boolean getConversationActive() {
        return this.isConversationActive.getBoolean();
    }

    public int getConversationID() {
        return this.conversationID.getInt();
    }

    public int getConversationProgress() {
        return this.conversationProgress.getInt();
    }
}

