/*
 * Decompiled with CFR 0.152.
 */
package mca.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mca.core.MCA;
import mca.data.VillagerSaveData;
import mca.entity.EntityHuman;
import mca.packets.PacketCallVillager;
import mca.packets.PacketRequestRelatedVillagers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;
import radixcore.data.DataWatcherEx;

@SideOnly(value=Side.CLIENT)
public class GuiWhistle
extends GuiScreen {
    private EntityHuman dummyHuman;
    private List<VillagerSaveData> villagerDataList;
    private GuiButton selectionLeftButton;
    private GuiButton selectionRightButton;
    private GuiButton villagerNameButton;
    private GuiButton callButton;
    private GuiButton callAllButton;
    private GuiButton exitButton;
    private int loadingAnimationTicks;
    private int selectedIndex;

    public GuiWhistle(EntityPlayer player) {
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.loadingAnimationTicks != -1) {
            ++this.loadingAnimationTicks;
        }
        if (this.loadingAnimationTicks >= 20) {
            this.loadingAnimationTicks = 0;
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.selectionLeftButton = new GuiButton(1, this.field_146294_l / 2 - 123, this.field_146295_m / 2 + 65, 20, 20, "<<");
        this.field_146292_n.add(this.selectionLeftButton);
        this.selectionRightButton = new GuiButton(2, this.field_146294_l / 2 + 103, this.field_146295_m / 2 + 65, 20, 20, ">>");
        this.field_146292_n.add(this.selectionRightButton);
        this.villagerNameButton = new GuiButton(3, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 65, 200, 20, "");
        this.field_146292_n.add(this.villagerNameButton);
        this.callButton = new GuiButton(4, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 90, 60, 20, MCA.getLanguageManager().getString("gui.button.call"));
        this.field_146292_n.add(this.callButton);
        this.callAllButton = new GuiButton(5, this.field_146294_l / 2 - 30, this.field_146295_m / 2 + 90, 60, 20, MCA.getLanguageManager().getString("gui.button.callall"));
        this.field_146292_n.add(this.callAllButton);
        this.exitButton = new GuiButton(6, this.field_146294_l / 2 + 40, this.field_146295_m / 2 + 90, 60, 20, MCA.getLanguageManager().getString("gui.button.exit"));
        this.field_146292_n.add(this.exitButton);
        MCA.getPacketHandler().sendPacketToServer(new PacketRequestRelatedVillagers());
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton == this.exitButton) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        if (this.villagerDataList.size() > 0) {
            if (guibutton == this.selectionLeftButton) {
                this.selectedIndex = this.selectedIndex == 1 ? this.villagerDataList.size() : --this.selectedIndex;
            } else if (guibutton == this.selectionRightButton) {
                this.selectedIndex = this.selectedIndex == this.villagerDataList.size() ? 1 : ++this.selectedIndex;
            } else if (guibutton == this.callButton) {
                MCA.getPacketHandler().sendPacketToServer(new PacketCallVillager(this.villagerDataList.get((int)(this.selectedIndex - 1)).uuid));
                Minecraft.func_71410_x().func_147108_a(null);
            } else if (guibutton == this.callAllButton) {
                MCA.getPacketHandler().sendPacketToServer(new PacketCallVillager(true));
                Minecraft.func_71410_x().func_147108_a(null);
            }
            VillagerSaveData data = this.villagerDataList.get(this.selectedIndex - 1);
            this.villagerNameButton.field_146126_j = data.displayTitle;
            this.updateDummyVillagerWithData(data);
        }
    }

    public void func_73863_a(int sizeX, int sizeY, float offset) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, MCA.getLanguageManager().getString("gui.title.whistle"), this.field_146294_l / 2, this.field_146295_m / 2 - 110, 0xFFFFFF);
        if (this.loadingAnimationTicks != -1) {
            this.func_73731_b(this.field_146289_q, "Loading" + StringUtils.repeat((String)".", (int)(this.loadingAnimationTicks % 10)), this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 10, 0xFFFFFF);
        } else if (this.villagerDataList.size() == 0) {
            this.func_73732_a(this.field_146289_q, "No family members could be found in the area.", this.field_146294_l / 2, this.field_146295_m / 2 + 50, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, this.selectedIndex + " / " + this.villagerDataList.size(), this.field_146294_l / 2, this.field_146295_m / 2 + 50, 0xFFFFFF);
        }
        if (this.dummyHuman != null) {
            this.drawDummyVillager();
        }
        super.func_73863_a(sizeX, sizeY, offset);
    }

    private void drawDummyVillager() {
        int posX = this.field_146294_l / 2;
        int posY = this.field_146295_m / 2 + 45;
        int scale = 70;
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)posX, (float)posY, (float)50.0f);
        GL11.glScalef((float)-70.0f, (float)70.0f, (float)70.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float yawOffset = this.dummyHuman.field_70761_aq;
        float rotationYaw = this.dummyHuman.field_70177_z;
        float rotationPitch = this.dummyHuman.field_70125_A;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(0.0)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.dummyHuman.field_70761_aq = (float)Math.atan(0.0) * 20.0f;
        this.dummyHuman.field_70177_z = (float)Math.atan(0.0) * 40.0f;
        this.dummyHuman.field_70125_A = -((float)Math.atan(0.0)) * 20.0f;
        this.dummyHuman.field_70759_as = this.dummyHuman.field_70177_z;
        GL11.glTranslatef((float)0.0f, (float)this.dummyHuman.field_70129_M, (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)this.dummyHuman, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        this.dummyHuman.field_70761_aq = yawOffset;
        this.dummyHuman.field_70177_z = rotationYaw;
        this.dummyHuman.field_70125_A = rotationPitch;
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public void setVillagerDataList(List<VillagerSaveData> dataList) {
        this.villagerDataList = dataList;
        this.loadingAnimationTicks = -1;
        this.selectedIndex = 1;
        try {
            VillagerSaveData firstData = dataList.get(0);
            this.villagerNameButton.field_146126_j = firstData.displayTitle;
            this.dummyHuman = new EntityHuman((World)Minecraft.func_71410_x().field_71441_e);
            this.updateDummyVillagerWithData(firstData);
        }
        catch (IndexOutOfBoundsException e) {
            this.callButton.field_146124_l = false;
            this.callAllButton.field_146124_l = false;
        }
    }

    private void updateDummyVillagerWithData(VillagerSaveData data) {
        DataWatcherEx.allowClientSideModification = true;
        this.dummyHuman.setIsMale(data.isMale);
        this.dummyHuman.setProfessionId(data.professionId);
        this.dummyHuman.setHeadTexture(data.headTexture);
        this.dummyHuman.setClothesTexture(data.clothesTexture);
        this.dummyHuman.setIsChild(data.isChild);
        this.dummyHuman.setAge(data.age);
        this.dummyHuman.setGirth(data.scaleGirth);
        this.dummyHuman.setHeight(data.scaleHeight);
        this.dummyHuman.setDoDisplay(true);
        DataWatcherEx.allowClientSideModification = false;
    }
}

