/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.recipe;

import com.creativemd.creativecore.common.recipe.entry.RecipeEntry;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CreativeRecipe {
    public ItemStack output;
    public Object[] input;
    public int width;
    public int height;

    public CreativeRecipe(ItemStack output, int width, int height, Object ... input) {
        this.output = output;
        this.input = input;
        this.width = width;
        this.height = height;
    }

    public void consumeRecipe(IInventory inventory, int width, int heigt) {
        this.consumeRecipe(inventory, width, heigt, 1);
    }

    public void consumeRecipe(IInventory inventory, int width, int heigt, int amount) {
        ItemStack[] inv = this.getObjectInValidOrder(inventory, width, heigt);
        for (int i = 0; i < inv.length; ++i) {
            int decrease;
            ItemStack stack;
            int index;
            if (inv[i] == null || (index = CreativeRecipe.getIndexInInventory(inventory, stack = inv[i])) == -1) continue;
            if (this.input[i] instanceof RecipeEntry) {
                decrease = ((RecipeEntry)this.input[i]).getStackSize(inv[i]);
                ((RecipeEntry)this.input[i]).consumeItemStack(decrease, index, inventory);
                continue;
            }
            decrease = 1;
            if (this.input[i] instanceof ItemStack) {
                decrease = ((ItemStack)this.input[i]).field_77994_a;
            }
            stack.field_77994_a -= decrease * amount;
            if (stack.field_77994_a != 0) continue;
            inventory.func_70299_a(index, null);
        }
    }

    public ItemStack getCraftingResult(IInventory inventory, int width, int heigt) {
        if (this.isValidRecipe(inventory, width, heigt)) {
            return this.output;
        }
        return null;
    }

    public int getNumberofResults(IInventory inventory, int InvWidth, int InvHeigt) {
        ItemStack[] inv = this.getObjectInValidOrder(inventory, InvWidth, InvHeigt);
        if (this.isValidRecipe(inv)) {
            int number = Integer.MAX_VALUE;
            for (int i = 0; i < this.input.length; ++i) {
                int uses = 0;
                uses = this.input[i] instanceof RecipeEntry ? ((RecipeEntry)this.input[i]).getStackSize(inv[i]) : (this.input[i] instanceof ItemStack ? inv[i].field_77994_a / ((ItemStack)this.input[i]).field_77994_a : inv[i].field_77994_a);
                number = Math.min(uses, number);
            }
            return number;
        }
        return 0;
    }

    protected ItemStack[] getObjectInValidOrder(IInventory inventory, int InvWidth, int InvHeigt) {
        int y;
        if (InvWidth < this.width || InvHeigt < this.height) {
            return null;
        }
        int posX = 0;
        int posY = 0;
        int posX2 = -1;
        int posY2 = -1;
        boolean foundX = false;
        for (int x = 0; x < InvWidth; ++x) {
            for (y = 0; y < InvHeigt; ++y) {
                if (inventory.func_70301_a(x + y * InvHeigt) == null) continue;
                foundX = true;
                posX2 = x;
            }
            if (foundX) continue;
            ++posX;
        }
        boolean foundY = false;
        for (y = 0; y < InvHeigt; ++y) {
            for (int x = 0; x < InvWidth; ++x) {
                if (inventory.func_70301_a(x + y * InvHeigt) == null) continue;
                foundY = true;
                posY2 = y;
            }
            if (foundY) continue;
            ++posY;
        }
        if (posX2 < 0 || posY2 < 0) {
            return null;
        }
        int gridWidth = posX2 - posX + 1;
        int gridHeight = posY2 - posY + 1;
        if (gridWidth != this.width || gridWidth != this.height) {
            return null;
        }
        ItemStack[] inv = new ItemStack[this.input.length];
        for (int y2 = 0; y2 < this.height; ++y2) {
            for (int x = 0; x < this.width; ++x) {
                inv[y2 * this.height + x] = inventory.func_70301_a(x + y2 * InvHeigt);
            }
        }
        return inv;
    }

    public boolean isValidRecipe(IInventory inventory, int InvWidth, int InvHeigt) {
        ItemStack[] inv = this.getObjectInValidOrder(inventory, InvWidth, InvHeigt);
        if (inv == null) {
            return false;
        }
        return this.isValidRecipe(inv);
    }

    public boolean isStackValid(ItemStack stack, Object input) {
        return !(input instanceof RecipeEntry ? !((RecipeEntry)input).isEntry(stack) : !RecipeEntry.isObject(stack, input));
    }

    public boolean isValidRecipe(ItemStack[] inv) {
        for (int i = 0; i < this.input.length; ++i) {
            if (this.isStackValid(inv[i], this.input[i])) continue;
            return false;
        }
        return true;
    }

    public static int getIndexInInventory(IInventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) != stack) continue;
            return i;
        }
        return -1;
    }
}

