/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.network.packets;

import duelmonster.superminer.util.BlockPos;
import io.netty.buffer.Unpooled;
import java.util.LinkedList;
import net.minecraft.network.PacketBuffer;

public class AutoFurrowPacket {
    public int packetID = -99;
    public BlockPos oPos;
    public LinkedList<BlockPos> lstPositions = new LinkedList();

    public AutoFurrowPacket() {
    }

    public AutoFurrowPacket(int iPacketID, BlockPos oPos) {
        this.packetID = iPacketID;
        this.oPos = oPos;
    }

    public void readPacketData(PacketBuffer oBuffer) {
        this.packetID = oBuffer.readInt();
        this.oPos = BlockPos.fromLong(oBuffer.readLong());
    }

    public PacketBuffer writePacketData() {
        PacketBuffer oBuffer = new PacketBuffer(Unpooled.buffer());
        oBuffer.writeInt(this.packetID);
        oBuffer.writeLong(this.oPos.toLong());
        return oBuffer;
    }

    public AutoFurrowPacket getClone() {
        AutoFurrowPacket pClone = new AutoFurrowPacket(this.packetID, this.oPos);
        pClone.readPacketData(this.writePacketData());
        return pClone;
    }

    public boolean isPositionConnected(BlockPos sourcePos) {
        if (this.lstPositions.size() > 0) {
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                        BlockPos comparePos = new BlockPos(sourcePos.getX() + xOffset, sourcePos.getY() + yOffset, sourcePos.getZ() + zOffset);
                        if (sourcePos.equals(comparePos)) continue;
                        for (BlockPos oPos : this.lstPositions) {
                            if (!comparePos.equals(oPos)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }
        return true;
    }
}

