/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.objects;

import cpw.mods.fml.common.event.FMLInterModComms;
import duelmonster.superminer.config.SettingsExcavator;
import duelmonster.superminer.config.SettingsShaftanator;
import duelmonster.superminer.config.SettingsVeinator;
import duelmonster.superminer.network.packets.IlluminatorPacket;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.objects.LogHelper;
import duelmonster.superminer.submods.Veinator;
import duelmonster.superminer.util.BlockPos;
import duelmonster.superminer.util.EnumFacing;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ExcavationHelper {
    private final int SECTION_LIMIT = 4;
    World world;
    EntityPlayerMP player;
    SMPacket oPacket;
    BlockPos oInitialPos = null;
    boolean bLayerOnlyToggled = false;
    EnumFacing sideHit;
    int iBlocksFound = 0;
    int iUnconnectedCount = 0;
    LinkedList<BlockPos> oPositions = new LinkedList();
    int iSpiral = 1;
    boolean bIsExcavating = true;
    int iLowestY = 0;
    int iFeetPos = 0;
    int iLengthStart = 0;
    int iLengthEnd = 0;
    int iWidthStart = 0;
    int iWidthEnd = 0;
    boolean bCallerIsVeinator = false;

    private boolean bAutoIlluminate() {
        return SettingsExcavator.bAutoIlluminate || SettingsShaftanator.bAutoIlluminate;
    }

    private boolean bMineVeins() {
        return !this.bCallerIsVeinator && SettingsShaftanator.bMineVeins;
    }

    public boolean isExcavating() {
        return this.bIsExcavating;
    }

    public ExcavationHelper(World world, EntityPlayerMP player, SMPacket oPacket) {
        this.world = world;
        this.player = player;
        this.oPacket = oPacket;
        this.oInitialPos = new BlockPos(oPacket.oPos);
        this.bLayerOnlyToggled = oPacket.bLayerOnlyToggled;
        this.sideHit = oPacket.sideHit;
    }

    public boolean ExcavateSection() {
        if (!this.oPositions.isEmpty()) {
            if (!this.bIsExcavating) {
                this.bIsExcavating = true;
            }
            for (int indx = 0; indx <= 4; ++indx) {
                boolean bHarvested;
                if (this.oPositions.isEmpty()) continue;
                BlockPos workingPos = null;
                try {
                    workingPos = this.oPositions.removeFirst();
                }
                catch (NoSuchElementException e) {
                    this.bIsExcavating = false;
                    return false;
                }
                if (workingPos == null || this.world.func_147437_c(workingPos.getX(), workingPos.getY(), workingPos.getZ())) continue;
                Block block = this.world.func_147439_a(workingPos.getX(), workingPos.getY(), workingPos.getZ());
                int metadata = this.world.func_72805_g(workingPos.getX(), workingPos.getY(), workingPos.getZ());
                if (this.bMineVeins() && Globals.isIdInList(block, Veinator.myGlobals.lBlockIDs)) {
                    SMPacket oVeinPacket = new SMPacket();
                    oVeinPacket.oPos = new BlockPos(workingPos);
                    oVeinPacket.sideHit = this.sideHit;
                    oVeinPacket.block = block;
                    oVeinPacket.metadata = metadata;
                    oVeinPacket.nanoTime = System.nanoTime();
                    oVeinPacket.flag_rs = block == Blocks.field_150450_ax || block == Blocks.field_150439_ay;
                    oVeinPacket.playerID = this.player.func_145782_y();
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74773_a("MineVein", oVeinPacket.writePacketData().array());
                    FMLInterModComms.sendRuntimeMessage((Object)"superminer_shaftanator", (String)"superminer_veinator", (String)"MineVein", (NBTTagCompound)nbt);
                    continue;
                }
                if (this.world.func_147437_c(workingPos.getX(), workingPos.getY(), workingPos.getZ()) || !(bHarvested = this.player.field_71134_c.func_73084_b(workingPos.getX(), workingPos.getY(), workingPos.getZ())) || !this.bAutoIlluminate() || workingPos.getY() != this.iLowestY) continue;
                IlluminatorPacket iPacket = new IlluminatorPacket();
                iPacket.oPos = new BlockPos(this.sideHit == EnumFacing.EAST ? workingPos.north() : (this.sideHit == EnumFacing.WEST ? workingPos.north() : workingPos));
                iPacket.playerID = this.player.func_145782_y();
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74773_a("IlluminateShaftData", iPacket.writePacketData().array());
                FMLInterModComms.sendRuntimeMessage((Object)"superminer_shaftanator", (String)"superminer_illuminator", (String)"IlluminateShaft", (NBTTagCompound)nbt);
            }
        }
        if (this.oPositions.isEmpty()) {
            this.bIsExcavating = false;
        }
        return this.bIsExcavating;
    }

    public void getExcavationBlocks() {
        this.oPositions.offer(this.oInitialPos);
        this.iLowestY = this.oInitialPos.getY();
        this.iBlocksFound = 1;
        boolean bHasConnected = false;
        block0 : switch (this.sideHit) {
            case NORTH: {
                for (int excavateZ = this.oInitialPos.getZ(); excavateZ <= this.oInitialPos.getZ() + SettingsExcavator.iBlockRadius; ++excavateZ) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        int zOffset;
                        int n = zOffset = excavateZ != this.oInitialPos.getZ() ? -1 : 0;
                        block9: while (zOffset <= 1) {
                            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                                for (int yOffset = !this.bLayerOnlyToggled ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                                    BlockPos oPos = new BlockPos(this.oInitialPos.getX() + xOffset, this.oInitialPos.getY() + yOffset, excavateZ + zOffset);
                                    if (!Globals.checkBlock(this.world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ()), this.oPacket)) continue;
                                    bHasConnected = true;
                                    break block9;
                                }
                            }
                            ++zOffset;
                        }
                    }
                    if (!bHasConnected || !this.SpiralNorthSouth(excavateZ)) break block0;
                }
                break;
            }
            case SOUTH: {
                for (int excavateZ = this.oInitialPos.getZ(); excavateZ >= this.oInitialPos.getZ() - SettingsExcavator.iBlockRadius; --excavateZ) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        int zOffset;
                        int n = zOffset = excavateZ != this.oInitialPos.getZ() ? -1 : 0;
                        block13: while (zOffset <= 1) {
                            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                                for (int yOffset = !this.bLayerOnlyToggled ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                                    BlockPos oPos = new BlockPos(this.oInitialPos.getX() + xOffset, this.oInitialPos.getY() + yOffset, excavateZ - zOffset);
                                    if (!Globals.checkBlock(this.world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ()), this.oPacket)) continue;
                                    bHasConnected = true;
                                    break block13;
                                }
                            }
                            ++zOffset;
                        }
                    }
                    if (!bHasConnected || !this.SpiralNorthSouth(excavateZ)) break block0;
                }
                break;
            }
            case EAST: {
                for (int excavateX = this.oInitialPos.getX(); excavateX >= this.oInitialPos.getX() - SettingsExcavator.iBlockRadius; --excavateX) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        int xOffset;
                        int n = xOffset = excavateX != this.oInitialPos.getX() ? -1 : 0;
                        block17: while (xOffset <= 1) {
                            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                                for (int yOffset = !this.bLayerOnlyToggled ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                                    BlockPos oPos = new BlockPos(excavateX - xOffset, this.oInitialPos.getY() + yOffset, this.oInitialPos.getZ() + zOffset);
                                    if (!Globals.checkBlock(this.world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ()), this.oPacket)) continue;
                                    bHasConnected = true;
                                    break block17;
                                }
                            }
                            ++xOffset;
                        }
                    }
                    if (!bHasConnected || !this.SpiralEastWest(excavateX)) break block0;
                }
                break;
            }
            case WEST: {
                for (int excavateX = this.oInitialPos.getX(); excavateX <= this.oInitialPos.getX() + SettingsExcavator.iBlockRadius; ++excavateX) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        int xOffset;
                        int n = xOffset = excavateX != this.oInitialPos.getX() ? -1 : 0;
                        block21: while (xOffset <= 1) {
                            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                                for (int yOffset = !this.bLayerOnlyToggled ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                                    BlockPos oPos = new BlockPos(excavateX + xOffset, this.oInitialPos.getY() + yOffset, this.oInitialPos.getZ() + zOffset);
                                    if (!Globals.checkBlock(this.world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ()), this.oPacket)) continue;
                                    bHasConnected = true;
                                    break block21;
                                }
                            }
                            ++xOffset;
                        }
                    }
                    if (!bHasConnected || !this.SpiralEastWest(excavateX)) break block0;
                }
                break;
            }
            case UP: {
                for (int excavateY = this.oInitialPos.getY(); excavateY >= this.oInitialPos.getY() - (!this.bLayerOnlyToggled ? SettingsExcavator.iBlockRadius : 0); --excavateY) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        block25: for (int yOffset = excavateY != this.oInitialPos.getY() ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                                    BlockPos oPos = new BlockPos(this.oInitialPos.getX() + xOffset, excavateY - yOffset, this.oInitialPos.getZ() + zOffset);
                                    if (!Globals.checkBlock(this.world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ()), this.oPacket)) continue;
                                    bHasConnected = true;
                                    break block25;
                                }
                            }
                        }
                    }
                    if (!bHasConnected || !this.SpiralUpDown(excavateY)) break block0;
                }
                break;
            }
            case DOWN: {
                for (int excavateY = this.oInitialPos.getY(); excavateY <= this.oInitialPos.getY() + (!this.bLayerOnlyToggled ? SettingsExcavator.iBlockRadius : 0); ++excavateY) {
                    bHasConnected = false;
                    if (!bHasConnected) {
                        block29: for (int yOffset = excavateY != this.oInitialPos.getY() ? -1 : 0; yOffset <= (!this.bLayerOnlyToggled ? 1 : 0); ++yOffset) {
                            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                                    BlockPos oPos = new BlockPos(this.oInitialPos.getX() + xOffset, excavateY - yOffset, this.oInitialPos.getZ() + zOffset);
                                    if (!Globals.checkBlock(this.world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ()), this.oPacket)) continue;
                                    bHasConnected = true;
                                    break block29;
                                }
                            }
                        }
                    }
                    if (!bHasConnected || !this.SpiralUpDown(excavateY)) break block0;
                }
                break;
            }
        }
    }

    private boolean SpiralNorthSouth(int excavateZ) {
        for (int iSpiral = 1; iSpiral <= SettingsExcavator.iBlockRadius / 2; ++iSpiral) {
            this.iUnconnectedCount = 0;
            for (int xOffset = -iSpiral; xOffset <= iSpiral; ++xOffset) {
                for (int yOffset = !this.bLayerOnlyToggled ? -iSpiral : 0; yOffset <= (!this.bLayerOnlyToggled ? iSpiral : 0); ++yOffset) {
                    for (int zOffset = 0; zOffset <= (excavateZ == this.oInitialPos.getZ() ? 0 : 1); ++zOffset) {
                        BlockPos curPos = new BlockPos(this.oInitialPos.getX() + xOffset, this.oInitialPos.getY() + yOffset, excavateZ + (this.sideHit == EnumFacing.NORTH ? -zOffset : zOffset));
                        if (Globals.checkBlock(this.world.func_147439_a(curPos.getX(), curPos.getY(), curPos.getZ()), this.oPacket)) {
                            this.AddCoordsToList(curPos);
                        }
                        if (this.iBlocksFound < SettingsExcavator.iBlockLimit) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean SpiralEastWest(int excavateX) {
        for (int iSpiral = 1; iSpiral <= SettingsExcavator.iBlockRadius / 2; ++iSpiral) {
            this.iUnconnectedCount = 0;
            for (int zOffset = -iSpiral; zOffset <= iSpiral; ++zOffset) {
                for (int yOffset = !this.bLayerOnlyToggled ? -iSpiral : 0; yOffset <= (!this.bLayerOnlyToggled ? iSpiral : 0); ++yOffset) {
                    for (int xOffset = 0; xOffset <= (excavateX == this.oInitialPos.getX() ? 0 : 1); ++xOffset) {
                        BlockPos curPos = new BlockPos(excavateX + (this.sideHit == EnumFacing.EAST ? xOffset : -xOffset), this.oInitialPos.getY() + yOffset, this.oInitialPos.getZ() + zOffset);
                        if (Globals.checkBlock(this.world.func_147439_a(curPos.getX(), curPos.getY(), curPos.getZ()), this.oPacket)) {
                            this.AddCoordsToList(curPos);
                        }
                        if (this.iBlocksFound < SettingsExcavator.iBlockLimit) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean SpiralUpDown(int excavateY) {
        for (int iSpiral = 1; iSpiral <= SettingsExcavator.iBlockRadius / 2; ++iSpiral) {
            this.iUnconnectedCount = 0;
            for (int xOffset = -iSpiral; xOffset <= iSpiral; ++xOffset) {
                for (int zOffset = -iSpiral; zOffset <= iSpiral; ++zOffset) {
                    for (int yOffset = 0; yOffset <= (excavateY == this.oInitialPos.getY() ? 0 : 1); ++yOffset) {
                        BlockPos curPos = new BlockPos(this.oInitialPos.getX() + xOffset, excavateY + (this.sideHit == EnumFacing.UP ? yOffset : -yOffset), this.oInitialPos.getZ() + zOffset);
                        if (Globals.checkBlock(this.world.func_147439_a(curPos.getX(), curPos.getY(), curPos.getZ()), this.oPacket)) {
                            this.AddCoordsToList(curPos);
                        }
                        if (this.iBlocksFound < SettingsExcavator.iBlockLimit) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private void AddCoordsToList(BlockPos oPos) {
        boolean bValidBlock = false;
        if (!this.oPositions.contains(oPos)) {
            block0: for (int xOffsetCheck = -1; xOffsetCheck <= 1; ++xOffsetCheck) {
                for (int zOffsetCheck = -1; zOffsetCheck <= 1; ++zOffsetCheck) {
                    for (int yOffsetCheck = 1; yOffsetCheck >= -1; --yOffsetCheck) {
                        if (!this.oPositions.contains(new BlockPos(oPos.getX() + xOffsetCheck, oPos.getY() + yOffsetCheck, oPos.getZ() + zOffsetCheck))) continue;
                        bValidBlock = true;
                        break block0;
                    }
                }
            }
            if (bValidBlock) {
                this.oPositions.offer(oPos);
                if (oPos.getY() < this.iLowestY) {
                    this.iLowestY = oPos.getY();
                }
                ++this.iBlocksFound;
            } else {
                ++this.iUnconnectedCount;
            }
        } else {
            ++this.iUnconnectedCount;
        }
    }

    private static boolean isAllowedToMine(EntityPlayer player, Block block) {
        if (null == block || Blocks.field_150350_a == block || block.func_149688_o().func_76224_d() || Blocks.field_150357_h == block) {
            return false;
        }
        return player.func_146099_a(block);
    }

    public void getShaftBlocks() {
        this.oPositions.offer(this.oInitialPos);
        this.iLowestY = this.iFeetPos = (int)this.player.field_70121_D.field_72338_b;
        int iHeightStart = this.iFeetPos;
        int iHeightEnd = this.iFeetPos + (SettingsShaftanator.iShaftHeight - 1);
        double dDivision = (SettingsShaftanator.iShaftWidth & 1) != 0 ? 0.0 : 0.5;
        switch (this.oPacket.sideHit) {
            case NORTH: {
                this.iWidthStart = this.oPacket.oPos.getX() - SettingsShaftanator.iShaftWidth / 2;
                this.iWidthEnd = this.oPacket.oPos.getX() + (int)((double)(SettingsShaftanator.iShaftWidth / 2) - dDivision);
                this.iLengthStart = this.oPacket.oPos.getZ();
                this.iLengthEnd = this.oPacket.oPos.getZ() + SettingsShaftanator.iShaftLength;
                break;
            }
            case SOUTH: {
                this.iWidthStart = this.oPacket.oPos.getX() + (int)((double)(SettingsShaftanator.iShaftWidth / 2) - dDivision);
                this.iWidthEnd = this.oPacket.oPos.getX() - SettingsShaftanator.iShaftWidth / 2;
                this.iLengthStart = this.oPacket.oPos.getZ();
                this.iLengthEnd = this.oPacket.oPos.getZ() - SettingsShaftanator.iShaftLength;
                break;
            }
            case WEST: {
                this.iWidthStart = this.oPacket.oPos.getZ() - SettingsShaftanator.iShaftWidth / 2;
                this.iWidthEnd = this.oPacket.oPos.getZ() + (int)((double)(SettingsShaftanator.iShaftWidth / 2) - dDivision);
                this.iLengthStart = this.oPacket.oPos.getX();
                this.iLengthEnd = this.oPacket.oPos.getX() + SettingsShaftanator.iShaftLength;
                break;
            }
            case EAST: {
                this.iWidthStart = this.oPacket.oPos.getZ() + (int)((double)(SettingsShaftanator.iShaftWidth / 2) - dDivision);
                this.iWidthEnd = this.oPacket.oPos.getZ() - SettingsShaftanator.iShaftWidth / 2;
                this.iLengthStart = this.oPacket.oPos.getX();
                this.iLengthEnd = this.oPacket.oPos.getX() - SettingsShaftanator.iShaftLength;
                break;
            }
        }
        int iAirCount = 0;
        block6 : switch (this.oPacket.sideHit) {
            case NORTH: 
            case WEST: {
                for (int iLengthPos = this.iLengthStart; iLengthPos <= this.iLengthEnd; ++iLengthPos) {
                    iAirCount = 0;
                    for (int iWidthPos = this.iWidthStart; iWidthPos <= this.iWidthEnd; ++iWidthPos) {
                        for (int iHeightPos = iHeightStart; iHeightPos <= iHeightEnd; ++iHeightPos) {
                            BlockPos curPos = new BlockPos(this.oPacket.sideHit == EnumFacing.NORTH ? iWidthPos : iLengthPos, iHeightPos, this.oPacket.sideHit == EnumFacing.NORTH ? iLengthPos : iWidthPos);
                            if (ExcavationHelper.isAllowedToMine((EntityPlayer)this.player, this.world.func_147439_a(curPos.getX(), curPos.getY(), curPos.getZ()))) {
                                this.AddCoordsToList(curPos);
                            } else {
                                ++iAirCount;
                            }
                            if (iAirCount >= SettingsShaftanator.iShaftHeight * SettingsShaftanator.iShaftWidth) break block6;
                        }
                    }
                }
                break;
            }
            case SOUTH: 
            case EAST: {
                for (int iLengthPos = this.iLengthStart; iLengthPos >= this.iLengthEnd; --iLengthPos) {
                    iAirCount = 0;
                    for (int iWidthPos = this.iWidthStart; iWidthPos >= this.iWidthEnd; --iWidthPos) {
                        for (int iHeightPos = iHeightStart; iHeightPos <= iHeightEnd; ++iHeightPos) {
                            BlockPos curPos = new BlockPos(this.oPacket.sideHit == EnumFacing.SOUTH ? iWidthPos : iLengthPos, iHeightPos, this.oPacket.sideHit == EnumFacing.SOUTH ? iLengthPos : iWidthPos);
                            if (ExcavationHelper.isAllowedToMine((EntityPlayer)this.player, this.world.func_147439_a(curPos.getX(), curPos.getY(), curPos.getZ()))) {
                                this.AddCoordsToList(curPos);
                            } else {
                                ++iAirCount;
                            }
                            if (iAirCount >= SettingsShaftanator.iShaftHeight * SettingsShaftanator.iShaftWidth) break block6;
                        }
                    }
                }
                break;
            }
        }
    }

    public void getOreVein() {
        this.bCallerIsVeinator = true;
        this.oPositions.offer(this.oInitialPos);
        for (int iSearchRadius = 1; iSearchRadius <= 8; ++iSearchRadius) {
            for (int xOffset = -iSearchRadius; xOffset <= iSearchRadius; ++xOffset) {
                for (int zOffset = -iSearchRadius; zOffset <= iSearchRadius; ++zOffset) {
                    for (int yOffset = -iSearchRadius; yOffset <= iSearchRadius; ++yOffset) {
                        BlockPos oPos = new BlockPos(this.oInitialPos.getX() + xOffset, this.oInitialPos.getY() + yOffset, this.oInitialPos.getZ() + zOffset);
                        if (!Globals.checkBlock(this.world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ()), this.oPacket)) continue;
                        this.AddCoordsToList(oPos);
                    }
                }
            }
        }
        LogHelper.log(Level.INFO, "Found (" + this.oPositions.size() + ") blocks in Ore Vein");
    }

    public void FinalizeExcavation() {
        List<Entity> list;
        if (SettingsExcavator.bGatherDrops && null != (list = Globals.getNearbyEntities(this.world, this.player.field_70121_D.func_72314_b((double)(SettingsExcavator.iBlockRadius + 2), (double)(SettingsExcavator.iBlockRadius + 2), (double)(SettingsExcavator.iBlockRadius + 2)))) && !list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.field_70128_L) continue;
                entity.func_70107_b((double)this.oInitialPos.getX(), (double)this.oInitialPos.getY(), (double)this.oInitialPos.getZ());
            }
        }
    }

    public void FinalizeShaft() {
        List<Entity> list;
        if (SettingsShaftanator.bGatherDrops && null != (list = Globals.getNearbyEntities(this.world, this.player.field_70121_D.func_72314_b((double)(this.oPacket.sideHit == EnumFacing.NORTH || this.oPacket.sideHit == EnumFacing.SOUTH ? SettingsShaftanator.iShaftWidth + 2 : SettingsShaftanator.iShaftLength + 4), (double)(SettingsShaftanator.iShaftHeight + 2), (double)(this.oPacket.sideHit == EnumFacing.NORTH || this.oPacket.sideHit == EnumFacing.SOUTH ? SettingsShaftanator.iShaftLength + 4 : SettingsShaftanator.iShaftWidth + 2)))) && !list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.field_70128_L) continue;
                entity.func_70107_b((double)this.oInitialPos.getX(), (double)this.oInitialPos.getY(), (double)this.oInitialPos.getZ());
            }
        }
    }

    public void FinalizeVeination() {
        List<Entity> list;
        if (SettingsVeinator.bGatherDrops && null != (list = Globals.getNearbyEntities(this.world, this.player.field_70121_D.func_72314_b(16.0, 16.0, 16.0))) && !list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.field_70128_L) continue;
                entity.func_70107_b((double)this.oInitialPos.getX(), (double)this.oInitialPos.getY(), (double)this.oInitialPos.getZ());
            }
        }
        LogHelper.log(Level.INFO, "Finalized Vein");
    }
}

