/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.objects;

import cpw.mods.fml.client.FMLClientHandler;
import duelmonster.superminer.objects.NotSoRandom;
import duelmonster.superminer.util.BlockPos;
import duelmonster.superminer.util.ClickType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class SubstitutionHelper {
    private static final Minecraft mc = FMLClientHandler.instance().getClient();
    private static ItemStack prevHeldItem = null;
    private static Random prevWorldRandom = null;

    public static float getDigSpeed(ItemStack itemstack, Block block, int metadata) {
        return itemstack == null ? 1.0f : itemstack.func_77973_b().getDigSpeed(itemstack, block, metadata);
    }

    public static float getBlockHardness(World world, BlockPos oPos) {
        Block block = world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ());
        if (block == null) {
            return 0.0f;
        }
        return block.func_149712_f(world, oPos.getX(), oPos.getY(), oPos.getZ());
    }

    public static float getBlockStrength(ItemStack itemstack, World world, BlockPos oPos) {
        Block block = world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ());
        SubstitutionHelper.ChangeHeldItem(itemstack);
        float strength = block.func_149737_a((EntityPlayer)SubstitutionHelper.mc.field_71439_g, world, oPos.getX(), oPos.getY(), oPos.getZ());
        SubstitutionHelper.RestoreHeldItem();
        return strength;
    }

    public static int getAdjustedBlockStrength(double blockStrength) {
        return blockStrength <= 0.0 ? Integer.MIN_VALUE : -MathHelper.func_76143_f((double)(1.0 / blockStrength));
    }

    public static float getEfficiency(float digSpeed, ItemStack itemstack) {
        if (digSpeed <= 1.5f) {
            return digSpeed;
        }
        SubstitutionHelper.ChangeHeldItem(itemstack);
        float efficiencyLevel = EnchantmentHelper.func_77509_b((EntityLivingBase)SubstitutionHelper.mc.field_71439_g);
        SubstitutionHelper.RestoreHeldItem();
        if (efficiencyLevel == 0.0f) {
            return digSpeed;
        }
        return digSpeed + efficiencyLevel * efficiencyLevel + 1.0f;
    }

    public static int getHarvestLevel(ItemStack itemstack, Block block, int metadata) {
        SubstitutionHelper.ChangeHeldItem(null);
        boolean noTool = SubstitutionHelper.mc.field_71439_g.func_146099_a(block);
        SubstitutionHelper.RestoreHeldItem();
        if (noTool) {
            return 0;
        }
        SubstitutionHelper.ChangeHeldItem(itemstack);
        boolean canHarvest = block.canHarvestBlock((EntityPlayer)SubstitutionHelper.mc.field_71439_g, metadata);
        SubstitutionHelper.RestoreHeldItem();
        return canHarvest ? 1 : -1;
    }

    public static boolean isBlockSilkTouchable(World world, BlockPos oPos) {
        Block block = world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ());
        if (block == null) {
            return false;
        }
        int metadata = world.func_72805_g(oPos.getX(), oPos.getY(), oPos.getZ());
        boolean silkHarvest = block.canSilkHarvest(world, (EntityPlayer)SubstitutionHelper.mc.field_71439_g, oPos.getX(), oPos.getY(), oPos.getZ(), metadata);
        if (!silkHarvest) {
            return false;
        }
        NotSoRandom zeroRandom = new NotSoRandom(true);
        NotSoRandom maxRandom = new NotSoRandom(false);
        ItemStack stackedBlock = SubstitutionHelper.createBlockStack(block, metadata);
        List<ItemStack> stackedBlockList = Collections.singletonList(stackedBlock);
        SubstitutionHelper.ChangeWorldRandom(world, maxRandom);
        ArrayList maxRandomDrops = block.getDrops(world, oPos.getX(), oPos.getY(), oPos.getZ(), metadata, 0);
        SubstitutionHelper.ChangeWorldRandom(world, zeroRandom);
        ArrayList zeroRandomDrops = block.getDrops(world, oPos.getX(), oPos.getY(), oPos.getZ(), metadata, 0);
        SubstitutionHelper.RestoreWorldRandom(world);
        return !SubstitutionHelper.areItemStackListsIdentical(stackedBlockList, maxRandomDrops) || !SubstitutionHelper.areItemStackListsIdentical(stackedBlockList, zeroRandomDrops);
    }

    public static boolean isBlockFortunable(World world, BlockPos oPos) {
        Block block = world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ());
        if (block == null) {
            return false;
        }
        int metadata = world.func_72805_g(oPos.getX(), oPos.getY(), oPos.getZ());
        NotSoRandom zeroRandom = new NotSoRandom(true);
        NotSoRandom maxRandom = new NotSoRandom(false);
        SubstitutionHelper.ChangeWorldRandom(world, maxRandom);
        ArrayList defaultMaxDrops = block.getDrops(world, oPos.getX(), oPos.getY(), oPos.getZ(), metadata, 0);
        ArrayList fortuneMaxDrops = block.getDrops(world, oPos.getX(), oPos.getY(), oPos.getZ(), metadata, 3);
        SubstitutionHelper.ChangeWorldRandom(world, zeroRandom);
        ArrayList defaultZeroDrops = block.getDrops(world, oPos.getX(), oPos.getY(), oPos.getZ(), metadata, 0);
        ArrayList fortuneZeroDrops = block.getDrops(world, oPos.getX(), oPos.getY(), oPos.getZ(), metadata, 3);
        SubstitutionHelper.RestoreWorldRandom(world);
        return !SubstitutionHelper.areItemStackListsIdentical(defaultMaxDrops, fortuneMaxDrops) || !SubstitutionHelper.areItemStackListsIdentical(defaultZeroDrops, fortuneZeroDrops);
    }

    private static void ChangeHeldItem(ItemStack itemstack) {
        int iSlot = SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70461_c;
        prevHeldItem = SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70462_a[iSlot];
        SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70462_a[iSlot] = itemstack;
        if (prevHeldItem != null) {
            SubstitutionHelper.mc.field_71439_g.func_110140_aT().func_111148_a(prevHeldItem.func_111283_C());
        }
        if (itemstack != null) {
            SubstitutionHelper.mc.field_71439_g.func_110140_aT().func_111147_b(itemstack.func_111283_C());
        }
    }

    private static void RestoreHeldItem() {
        int iSlot = SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70461_c;
        ItemStack itemstack = SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70462_a[iSlot];
        SubstitutionHelper.mc.field_71439_g.field_71071_by.field_70462_a[iSlot] = prevHeldItem;
        if (itemstack != null) {
            SubstitutionHelper.mc.field_71439_g.func_110140_aT().func_111148_a(itemstack.func_111283_C());
        }
        if (prevHeldItem != null) {
            SubstitutionHelper.mc.field_71439_g.func_110140_aT().func_111147_b(prevHeldItem.func_111283_C());
        }
    }

    private static void ChangeWorldRandom(World world, Random random) {
        if (prevWorldRandom == null) {
            prevWorldRandom = world.field_73012_v;
        }
        world.field_73012_v = random;
    }

    private static void RestoreWorldRandom(World world) {
        world.field_73012_v = prevWorldRandom;
        prevWorldRandom = null;
    }

    private static ItemStack createBlockStack(Block block, int metadata) {
        int itemMetadata = 0;
        Item item = Item.func_150898_a((Block)block);
        if (item != null && item.func_77614_k()) {
            itemMetadata = metadata;
        }
        return new ItemStack(item, 1, itemMetadata);
    }

    public static boolean areItemStackListsIdentical(Collection<? extends ItemStack> stackCollection_1, Collection<? extends ItemStack> stackCollection_2) {
        if (stackCollection_1.size() != stackCollection_2.size()) {
            return false;
        }
        ArrayList<? extends ItemStack> stackList_1 = new ArrayList<ItemStack>(stackCollection_1);
        ArrayList<? extends ItemStack> stackList_2 = new ArrayList<ItemStack>(stackCollection_2);
        Iterator stackIterator_1 = stackList_1.iterator();
        block0: while (stackIterator_1.hasNext()) {
            ItemStack stack_1 = (ItemStack)stackIterator_1.next();
            Iterator stackIterator_2 = stackList_2.iterator();
            while (stackIterator_2.hasNext()) {
                ItemStack stack_2 = (ItemStack)stackIterator_2.next();
                if (!ItemStack.func_77989_b((ItemStack)stack_1, (ItemStack)stack_2)) continue;
                if (stackList_1.size() > 0) {
                    stackIterator_1.remove();
                }
                if (stackList_2.size() <= 0) continue block0;
                stackIterator_2.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean isItemStackDamageable(ItemStack itemstack) {
        return itemstack != null && itemstack.func_77973_b().func_77645_m();
    }

    public static boolean isSameTool(ItemStack stack_1, ItemStack stack_2) {
        return stack_1 != null && stack_2 != null && stack_2.func_77973_b().getClass() == stack_1.func_77973_b().getClass();
    }

    public static boolean isSword(ItemStack itemstack) {
        return itemstack != null && (itemstack.func_77973_b() instanceof ItemSword || itemstack.func_77977_a().toLowerCase().contains("sword"));
    }

    public static Set<Enchantment> getMultiToolEnchantments(ItemStack Tool_1, ItemStack Tool_2) {
        HashSet enchantments = new HashSet();
        HashSet<Enchantment> returnSet = new HashSet<Enchantment>();
        if (Tool_1 != null) {
            enchantments.addAll(EnchantmentHelper.func_82781_a((ItemStack)Tool_1).keySet());
        }
        if (Tool_2 != null) {
            enchantments.addAll(EnchantmentHelper.func_82781_a((ItemStack)Tool_2).keySet());
        }
        for (Integer enchant : enchantments) {
            Enchantment enchantment;
            if (enchant == Enchantment.field_77349_p.field_77352_x || enchant == Enchantment.field_77348_q.field_77352_x || enchant == Enchantment.field_77346_s.field_77352_x || enchant == Enchantment.field_77347_r.field_77352_x || enchant == Enchantment.field_77335_o.field_77352_x || enchant == Enchantment.field_77337_m.field_77352_x || enchant == Enchantment.field_77334_n.field_77352_x || (enchantment = Enchantment.field_77331_b[enchant]).func_77320_a().startsWith("enchantment.damage.")) continue;
            returnSet.add(enchantment);
        }
        return returnSet;
    }

    public static double getVanillaStackDamage(ItemStack itemStack, EntityLivingBase entity) {
        SubstitutionHelper.ChangeHeldItem(itemStack);
        double attackDamage = SubstitutionHelper.mc.field_71439_g.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        double enchantModifier = EnchantmentHelper.func_77512_a((EntityLivingBase)SubstitutionHelper.mc.field_71439_g, (EntityLivingBase)entity);
        if (attackDamage > 0.0 || enchantModifier > 0.0) {
            boolean isCritical;
            boolean bl = isCritical = SubstitutionHelper.mc.field_71439_g.field_70143_R > 0.0f && !SubstitutionHelper.mc.field_71439_g.field_70122_E && !SubstitutionHelper.mc.field_71439_g.func_70617_f_() && !SubstitutionHelper.mc.field_71439_g.func_70090_H() && !SubstitutionHelper.mc.field_71439_g.func_70644_a(Potion.field_76440_q) && SubstitutionHelper.mc.field_71439_g.field_70154_o == null;
            if (isCritical && attackDamage > 0.0) {
                attackDamage *= 1.5;
            }
            attackDamage += enchantModifier;
        }
        SubstitutionHelper.RestoreHeldItem();
        return attackDamage;
    }

    public static boolean transferStackFromTo(Container container, Minecraft mc, int slotFrom, int slotTo) {
        EntityClientPlayerMP player = mc.field_71439_g;
        mc.field_71442_b.func_78753_a(container.field_75152_c, slotFrom, 0, ClickType.PICKUP.getIndex(), (EntityPlayer)player);
        if (player.field_71071_by.func_70445_o() == null) {
            return false;
        }
        boolean bRtrn = true;
        int size = player.field_71071_by.func_70445_o().field_77994_a;
        mc.field_71442_b.func_78753_a(container.field_75152_c, slotTo, 0, ClickType.PICKUP.getIndex(), (EntityPlayer)player);
        if (player.field_71071_by.func_70445_o() != null) {
            bRtrn = player.field_71071_by.func_70445_o().field_77994_a != size;
            mc.field_71442_b.func_78753_a(container.field_75152_c, slotFrom, 0, ClickType.PICKUP.getIndex(), (EntityPlayer)player);
        }
        return bRtrn;
    }
}

