/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsCaptivator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.submods.Excavator;
import duelmonster.superminer.submods.Shaftanator;
import duelmonster.superminer.submods.Veinator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

@Mod(modid="superminer_captivator", name="Captivator", version="[1.7.10]-2.1.6.214", acceptedMinecraftVersions="[1.7.10]")
public class Captivator {
    public static final String MODID = "superminer_captivator";
    public static final String MODName = "Captivator";
    public static final String ChannelName = "superminer_captivator".substring(0, "superminer_captivator".length() < 20 ? "superminer_captivator".length() : 20);
    private long packetEnableTime = System.currentTimeMillis() + 200L;
    public static boolean bShouldSyncSettings = true;
    private static List<Object> lItemIDs = null;

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static void syncConfig() {
        SettingsCaptivator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.captivator.enabled"), MODID, true, Globals.localize("superminer.captivator.enabled.desc"));
        SettingsCaptivator.bAllowInGUI = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.captivator.allow_in_gui"), MODID, true, Globals.localize("superminer.captivator.allow_in_gui.desc"));
        SettingsCaptivator.fHorizontal = SuperMiner_Core.configFile.getFloat(Globals.localize("superminer.captivator.h_radius"), MODID, 16.0f, 0.0f, 128.0f, Globals.localize("superminer.captivator.h_radius.desc"));
        SettingsCaptivator.fVertical = SuperMiner_Core.configFile.getFloat(Globals.localize("superminer.captivator.v_radius"), MODID, 16.0f, 0.0f, 128.0f, Globals.localize("superminer.captivator.v_radius.desc"));
        SettingsCaptivator.bIsWhitelist = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.captivator.whitelist"), MODID, true, Globals.localize("superminer.captivator.whitelist.desc"));
        SettingsCaptivator.lItemIDs = SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.captivator.item_ids"), MODID, SettingsCaptivator.lItemIDDefaults, Globals.localize("superminer.captivator.item_ids.desc"));
        lItemIDs = Globals.IDListToArray(SettingsCaptivator.lItemIDs, false);
        ArrayList<String> order = new ArrayList<String>(6);
        order.add(Globals.localize("superminer.captivator.enabled"));
        order.add(Globals.localize("superminer.captivator.allow_in_gui"));
        order.add(Globals.localize("superminer.captivator.h_radius"));
        order.add(Globals.localize("superminer.captivator.v_radius"));
        order.add(Globals.localize("superminer.captivator.whitelist"));
        order.add(Globals.localize("superminer.captivator.item_ids"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player;
        if (!PlayerEvents.IsPlayerInWorld() || !SettingsCaptivator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase) || Excavator.isExcavating().booleanValue() || Shaftanator.isExcavating().booleanValue() || Veinator.isExcavating().booleanValue()) {
            return;
        }
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        if (minecraft.field_71439_g == null || minecraft.field_71441_e == null || minecraft.func_147113_T()) {
            return;
        }
        if (!SettingsCaptivator.bAllowInGUI && !minecraft.field_71415_G) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)SettingsCaptivator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = minecraft.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = minecraft.field_71441_e;
        if (null != world && System.currentTimeMillis() >= this.packetEnableTime && player.func_110143_aJ() > 0.0f) {
            List<Entity> list = Globals.getNearbyEntities((World)world, player.field_70121_D.func_72314_b((double)SettingsCaptivator.fHorizontal, (double)SettingsCaptivator.fVertical, (double)SettingsCaptivator.fHorizontal));
            if (null == list || list.isEmpty()) {
                return;
            }
            for (Entity entity : list) {
                if (entity.field_70128_L || !(entity instanceof EntityXPOrb) && !lItemIDs.isEmpty() && Globals.isIdInList(((EntityItem)entity).func_92059_d().func_77973_b(), lItemIDs) != SettingsCaptivator.bIsWhitelist) continue;
                this.packetEnableTime = System.currentTimeMillis() + 200L;
                PacketBuffer packetData = new PacketBuffer(Unpooled.buffer());
                packetData.writeInt(PacketIDs.BLOCKINFO.value());
                Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)packetData));
            }
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.packet.payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Captivator.value()) {
            SettingsCaptivator.readPacketData(payLoad);
        } else if (SettingsCaptivator.bEnabled) {
            EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
            if (null == player) {
                return;
            }
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (null == server) {
                return;
            }
            WorldServer world = server.func_71218_a(player.field_71093_bK);
            List<Entity> list = Globals.getNearbyEntities((World)world, player.field_70121_D.func_72314_b((double)SettingsCaptivator.fHorizontal, (double)SettingsCaptivator.fVertical, (double)SettingsCaptivator.fHorizontal));
            if (null == list || list.isEmpty()) {
                return;
            }
            for (Entity entity : list) {
                if (entity.field_70128_L || !(entity instanceof EntityXPOrb) && lItemIDs != null && !lItemIDs.isEmpty() && Globals.isIdInList(((EntityItem)entity).func_92059_d().func_77973_b(), lItemIDs) != SettingsCaptivator.bIsWhitelist) continue;
                entity.func_70100_b_((EntityPlayer)player);
            }
        }
    }
}

