/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsCropinator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.network.packets.AutoFurrowPacket;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.util.BlockPos;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;

@Mod(modid="superminer_cropinator", name="Cropinator", version="[1.7.10]-2.1.6.214", acceptedMinecraftVersions="[1.7.10]")
public class Cropinator {
    public static final String MODID = "superminer_cropinator";
    public static final String MODName = "Cropinator";
    public static final String ChannelName = "superminer_cropinator".substring(0, "superminer_cropinator".length() < 20 ? "superminer_cropinator".length() : 20);
    private boolean bHungerNotified = false;
    public static boolean bShouldSyncSettings = true;
    private static List<Object> lHoeIDs = null;

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static void syncConfig() {
        SettingsCropinator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.cropinator.enabled"), MODID, true, Globals.localize("superminer.cropinator.enabled.desc"));
        SettingsCropinator.bHarvestSeeds = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.cropinator.harvest_seeds"), MODID, false, Globals.localize("superminer.cropinator.harvest_seeds.desc"));
        SettingsCropinator.lHoeIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.cropinator.hoe_ids"), MODID, SettingsCropinator.lHoeIDDefaults.toArray(new String[0]), Globals.localize("superminer.cropinator.hoe_ids.desc"))));
        lHoeIDs = Globals.IDListToArray(SettingsCropinator.lHoeIDs, false);
        ArrayList<String> order = new ArrayList<String>(9);
        order.add(Globals.localize("superminer.cropinator.enabled"));
        order.add(Globals.localize("superminer.cropinator.harvest_seeds"));
        order.add(Globals.localize("superminer.cropinator.hoe_ids"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isStringMessage() || !message.key.equalsIgnoreCase("addHoe") || SettingsCropinator.lHoeIDs.contains(message.getStringValue())) continue;
            SettingsCropinator.lHoeIDs.add(message.getStringValue());
            SuperMiner_Core.configFile.get(MODID, Globals.localize("superminer.cropinator.hoe_ids"), SettingsCropinator.lHoeIDDefaults.toArray(new String[0]), Globals.localize("superminer.cropinator.hoe_ids.desc")).set(SettingsCropinator.lHoeIDs.toArray(new String[0]));
            SuperMiner_Core.configFile.save();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player;
        if (!(PlayerEvents.IsPlayerInWorld() && SettingsCropinator.bEnabled && TickEvent.Phase.END.equals((Object)event.phase))) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71439_g == null || mc.field_71441_e == null || mc.func_147113_T() || !mc.field_71415_G) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)SettingsCropinator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (world != null) {
            Block block = null;
            BlockPos oPos = null;
            if (player.func_110143_aJ() > 0.0f && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                oPos = new BlockPos(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
                block = world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ());
                if (!Globals.isAttacking(mc) && block != null && block == Blocks.field_150350_a) {
                    block = null;
                }
                if (block != null) {
                    if (!this.bHungerNotified && player.func_71024_bL().func_75116_a() <= 1) {
                        Globals.NotifyClient(Globals.tooHungry() + MODName);
                        this.bHungerNotified = true;
                        return;
                    }
                    if (Globals.isUsingItem(mc) && player.func_71024_bL().func_75116_a() > 1 && player.func_70694_bm() != null && Globals.isIdInList(player.func_71045_bC().func_77973_b(), lHoeIDs)) {
                        if (block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak) {
                            Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)new AutoFurrowPacket(PacketIDs.Cropinator_HoePacket.value(), oPos).writePacketData()));
                        } else if (block instanceof IPlantable) {
                            Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)new AutoFurrowPacket(PacketIDs.Cropinator_CropPacket.value(), oPos).writePacketData()));
                        }
                    }
                } else {
                    this.bHungerNotified = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.packet.payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Cropinator.value()) {
            SettingsCropinator.readPacketData(payLoad);
        } else if (SettingsCropinator.bEnabled) {
            EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
            AutoFurrowPacket packet = new AutoFurrowPacket();
            packet.readPacketData(payLoad);
            if (iPacketID == PacketIDs.Cropinator_HoePacket.value()) {
                Cropinator.HoeTheFarm(packet, (EntityPlayer)player);
            } else if (iPacketID == PacketIDs.Cropinator_CropPacket.value()) {
                Cropinator.FarmTheCrops(packet, (EntityPlayer)player);
            }
        }
    }

    private static void HoeTheFarm(AutoFurrowPacket oPacket, EntityPlayer player) {
        BlockPos blockPos;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null) {
            return;
        }
        Cropinator.getFarmLand((World)world, oPacket);
        ItemStack curItem = player.func_70694_bm();
        int iFarmableFound = oPacket.lstPositions.size();
        int iFarmed = 0;
        while (iFarmed <= iFarmableFound && (blockPos = oPacket.lstPositions.poll()) != null) {
            Block blockAbove = world.func_147439_a(blockPos.getX(), blockPos.up().getY(), blockPos.getZ());
            if (blockPos.getY() == oPacket.oPos.getY() && (blockAbove == Blocks.field_150350_a || blockAbove instanceof IPlantable) && Cropinator.hasWaterSource((World)world, blockPos)) {
                world.func_147465_d(blockPos.getX(), blockPos.getY(), blockPos.getZ(), Blocks.field_150458_ak, 7, 2);
                Globals.playSound((World)world, Blocks.field_150458_ak.field_149762_H, blockPos);
                if (blockAbove instanceof IPlantable) {
                    int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)curItem);
                    int metadata = world.func_72805_g(blockPos.getX(), blockPos.up().getY(), blockPos.getZ());
                    blockAbove.func_149697_b((World)world, blockPos.getX(), blockPos.up().getY(), blockPos.getZ(), metadata, fortune);
                    world.func_147449_b(blockPos.getX(), blockPos.up().getY(), blockPos.getZ(), Blocks.field_150350_a);
                }
                if (curItem != null && curItem.func_77984_f()) {
                    curItem.func_77972_a(1, (EntityLivingBase)player);
                }
                if (curItem.func_77958_k() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    player.field_71070_bA.func_75142_b();
                    break;
                }
            }
            if (++iFarmed <= iFarmableFound) continue;
            break;
        }
        oPacket.lstPositions.clear();
    }

    private static void getFarmLand(World world, AutoFurrowPacket oPacket) {
        int iRadius = 8;
        for (int xOffset = -iRadius; xOffset <= iRadius; ++xOffset) {
            for (int zOffset = -iRadius; zOffset <= iRadius; ++zOffset) {
                BlockPos blockPos = oPacket.oPos.add(xOffset, 0, zOffset);
                Block oBlock = world.func_147439_a(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                if (oBlock == null || oBlock == Blocks.field_150350_a || oBlock != Blocks.field_150349_c && oBlock != Blocks.field_150346_d) continue;
                oPacket.lstPositions.offer(blockPos);
            }
        }
    }

    private static boolean hasWaterSource(World world, BlockPos oPos) {
        for (int xOffset = oPos.getX() - 4; xOffset <= oPos.getX() + 4; ++xOffset) {
            for (int yOffset = oPos.getY(); yOffset <= oPos.getY() + 1; ++yOffset) {
                for (int zOffset = oPos.getZ() - 4; zOffset <= oPos.getZ() + 4; ++zOffset) {
                    if (world.func_147439_a(xOffset, yOffset, zOffset).func_149688_o() != Material.field_151586_h) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void FarmTheCrops(AutoFurrowPacket oPacket, EntityPlayer player) {
        BlockPos blockPos;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null) {
            return;
        }
        Cropinator.getCrops((World)world, oPacket);
        ItemStack curItem = player.func_70694_bm();
        int iFarmableFound = oPacket.lstPositions.size();
        int iFarmed = 0;
        while (iFarmed <= iFarmableFound && (blockPos = oPacket.lstPositions.poll()) != null) {
            Block blkCrop = world.func_147439_a(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            if (blkCrop instanceof BlockCrops && !((BlockCrops)blkCrop).func_149851_a((World)world, blockPos.getX(), blockPos.getY(), blockPos.getZ(), false)) {
                int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)curItem);
                int metadata = world.func_72805_g(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                if (SettingsCropinator.bHarvestSeeds) {
                    blkCrop.func_149697_b((World)world, blockPos.getX(), blockPos.getY(), blockPos.getZ(), metadata, fortune);
                } else {
                    ArrayList drops = blkCrop.getDrops((World)world, blockPos.getX(), blockPos.getY(), blockPos.getZ(), metadata, fortune);
                    for (ItemStack item : drops) {
                        if (item.func_77973_b() instanceof ItemSeeds) continue;
                        float f = 0.7f;
                        double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        EntityItem entityitem = new EntityItem((World)world, (double)blockPos.getX() + d0, (double)blockPos.getY() + d1, (double)blockPos.getZ() + d2, item);
                        entityitem.field_145804_b = 10;
                        world.func_72838_d((Entity)entityitem);
                    }
                }
                world.func_147465_d(blockPos.getX(), blockPos.getY(), blockPos.getZ(), blkCrop, 0, 2);
                Globals.playSound((World)world, blkCrop.field_149762_H, blockPos);
                if (iFarmed > 0 && (iFarmed % 4 == 0 || iFarmed >= iFarmableFound) && curItem != null && curItem.func_77984_f()) {
                    curItem.func_77972_a(1, (EntityLivingBase)player);
                }
                if (curItem.func_77958_k() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    player.field_71070_bA.func_75142_b();
                    break;
                }
            }
            if (++iFarmed <= iFarmableFound) continue;
            break;
        }
        oPacket.lstPositions.clear();
    }

    private static void getCrops(World world, AutoFurrowPacket oPacket) {
        int iPosStartEnd = 32;
        for (int iSpiral = 1; iSpiral <= iPosStartEnd; ++iSpiral) {
            for (int xOffset = -iSpiral; xOffset <= iSpiral; ++xOffset) {
                for (int zOffset = -iSpiral; zOffset <= iSpiral; ++zOffset) {
                    BlockPos blockPos = oPacket.oPos.add(xOffset, 0, zOffset);
                    Block oBlock = world.func_147439_a(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                    if (oBlock == null || oBlock == Blocks.field_150350_a || !(oBlock instanceof BlockCrops) || !oPacket.isPositionConnected(blockPos)) continue;
                    oPacket.lstPositions.offer(blockPos);
                }
            }
        }
    }
}

