/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.objects;

import duelmonster.superminer.config.SettingsLumbinator;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.util.BlockPos;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;

public class TreeHelper {
    public static final int MAX_TREE_WIDTH = 64;
    private EntityPlayer oPlayer;
    private Globals myGlobals;
    public int iTreeWidthPlusX = 0;
    public int iTreeWidthMinusX = 0;
    public int iTreeWidthPlusZ = 0;
    public int iTreeWidthMinusZ = 0;
    private BlockPos oFirstLeafPos = null;

    public TreeHelper(EntityPlayer player, Globals globals) {
        this.oPlayer = player;
        this.myGlobals = globals;
    }

    public void DetectTreeWidth(SMPacket currentPacket) {
        if (this.oFirstLeafPos != null) {
            int yLevel;
            for (int yLeaf = yLevel = this.oFirstLeafPos.getY(); yLeaf < this.oPlayer.field_70170_p.func_72800_K(); ++yLeaf) {
                String sUID = "";
                boolean bIsValidWood = false;
                boolean bIsValidLeaf = false;
                int iWidthPlusX = 0;
                int iWidthMinusX = 0;
                int iWidthPlusZ = 0;
                int iWidthMinusZ = 0;
                int iLastWoodPlus = 0;
                int iLastWoodMinus = 0;
                for (int xOffset = 0; xOffset < 64; ++xOffset) {
                    sUID = this.getUniqueIdentifier(new BlockPos(currentPacket.oPos.getX() + xOffset, yLevel, currentPacket.oPos.getZ()));
                    bIsValidWood = currentPacket.sWoodName.equalsIgnoreCase(sUID);
                    bIsValidLeaf = currentPacket.sLeafName.equalsIgnoreCase(sUID);
                    if (bIsValidWood) {
                        iLastWoodPlus = xOffset;
                    }
                    if (bIsValidLeaf && xOffset - iLastWoodPlus > SettingsLumbinator.iLeafRange) break;
                    if (bIsValidWood || bIsValidLeaf) {
                        ++iWidthPlusX;
                    }
                    sUID = this.getUniqueIdentifier(new BlockPos(currentPacket.oPos.getX() - xOffset, yLevel, currentPacket.oPos.getZ()));
                    bIsValidWood = currentPacket.sWoodName.equalsIgnoreCase(sUID);
                    bIsValidLeaf = currentPacket.sLeafName.equalsIgnoreCase(sUID);
                    if (bIsValidWood) {
                        iLastWoodMinus = xOffset;
                    }
                    if (bIsValidLeaf && xOffset - iLastWoodMinus > SettingsLumbinator.iLeafRange) break;
                    if (!bIsValidWood && !bIsValidLeaf) continue;
                    ++iWidthMinusX;
                }
                iLastWoodPlus = 0;
                iLastWoodMinus = 0;
                for (int zOffset = 0; zOffset < 64; ++zOffset) {
                    sUID = this.getUniqueIdentifier(new BlockPos(currentPacket.oPos.getX(), yLevel, currentPacket.oPos.getZ() + zOffset));
                    bIsValidWood = currentPacket.sWoodName.equalsIgnoreCase(sUID);
                    bIsValidLeaf = currentPacket.sLeafName.equalsIgnoreCase(sUID);
                    if (bIsValidWood) {
                        iLastWoodPlus = zOffset;
                    }
                    if (bIsValidLeaf && zOffset - iLastWoodPlus > SettingsLumbinator.iLeafRange) break;
                    if (bIsValidWood || bIsValidLeaf) {
                        ++iWidthPlusZ;
                    }
                    sUID = this.getUniqueIdentifier(new BlockPos(currentPacket.oPos.getX(), yLevel, currentPacket.oPos.getZ() - zOffset));
                    bIsValidWood = currentPacket.sWoodName.equalsIgnoreCase(sUID);
                    bIsValidLeaf = currentPacket.sLeafName.equalsIgnoreCase(sUID);
                    if (bIsValidWood) {
                        iLastWoodMinus = zOffset;
                    }
                    if (bIsValidLeaf && zOffset - iLastWoodMinus > SettingsLumbinator.iLeafRange) break;
                    if (!bIsValidWood && !bIsValidLeaf) continue;
                    ++iWidthMinusZ;
                }
                if (iWidthPlusX > this.iTreeWidthPlusX) {
                    this.iTreeWidthPlusX = iWidthPlusX;
                }
                if (iWidthMinusX > this.iTreeWidthMinusX) {
                    this.iTreeWidthMinusX = iWidthMinusX;
                }
                if (iWidthPlusZ > this.iTreeWidthPlusZ) {
                    this.iTreeWidthPlusZ = iWidthPlusZ;
                }
                if (iWidthMinusZ <= this.iTreeWidthMinusZ) continue;
                this.iTreeWidthMinusZ = iWidthMinusZ;
            }
        }
    }

    public String getLeafName(SMPacket currentPacket) {
        for (int yLeaf = currentPacket.oPos.getY() - 1; yLeaf < this.oPlayer.field_70170_p.func_72800_K(); ++yLeaf) {
            for (int xLeaf = -1; xLeaf < 1; ++xLeaf) {
                for (int zLeaf = -1; zLeaf < 1; ++zLeaf) {
                    BlockPos nextPos = new BlockPos(currentPacket.oPos.getX() + xLeaf, yLeaf, currentPacket.oPos.getZ() + zLeaf);
                    Block nextBlock = this.oPlayer.field_70170_p.func_147439_a(nextPos.getX(), nextPos.getY(), nextPos.getZ());
                    if (nextBlock.func_149688_o() != Material.field_151584_j || !Globals.isIdInList(nextBlock, this.myGlobals.lLeafIDs)) continue;
                    this.oFirstLeafPos = nextPos;
                    return this.getUniqueIdentifier(nextPos);
                }
            }
        }
        return "unknown";
    }

    public String getUniqueIdentifier(BlockPos oPos) {
        return this.getUniqueIdentifier(this.oPlayer.field_70170_p.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ()), this.oPlayer.field_70170_p.func_72805_g(oPos.getX(), oPos.getY(), oPos.getZ()));
    }

    public String getUniqueIdentifier(Block block, int iMetadata) {
        boolean bIsValidLeaves;
        String sResult = "";
        sResult = block.func_149739_a() + "_";
        boolean bIsValidWood = block.func_149688_o() == Material.field_151575_d && Globals.isIdInList(block, this.myGlobals.lBlockIDs);
        boolean bl = bIsValidLeaves = block.func_149688_o() == Material.field_151584_j && Globals.isIdInList(block, this.myGlobals.lLeafIDs);
        if (bIsValidWood) {
            int iWoodType = 0;
            if (block instanceof BlockOldLog) {
                iWoodType = iMetadata >> 0 & 1 & (iMetadata >> 0 & 2);
                sResult = sResult + BlockOldLog.field_150168_M[iWoodType];
            } else if (block instanceof BlockNewLog) {
                iWoodType = iMetadata >> 0 & 1;
                sResult = sResult + BlockNewLog.field_150169_M[iWoodType];
            }
        } else if (bIsValidLeaves) {
            int iLeafType = 0;
            if (block instanceof BlockOldLeaf) {
                iLeafType = iMetadata >> 0 & 1 & (iMetadata >> 0 & 2);
                sResult = sResult + BlockOldLeaf.field_150130_N[0][iLeafType];
            } else if (block instanceof BlockNewLeaf) {
                iLeafType = iMetadata >> 0 & 1;
                sResult = sResult + BlockNewLeaf.field_150132_N[0][iLeafType];
            }
        }
        return sResult;
    }

    public boolean ensureIsConnectedToTree(SMPacket currentPacket, BlockPos nextPos) {
        for (int yConOffset = -1; yConOffset <= 1; ++yConOffset) {
            for (int xConOffset = -1; xConOffset <= 1; ++xConOffset) {
                for (int zConOffset = -1; zConOffset <= 1; ++zConOffset) {
                    BlockPos oConPos = new BlockPos(nextPos.getX() + xConOffset, nextPos.getY() + yConOffset, nextPos.getZ() + zConOffset);
                    if (!currentPacket.positions.contains(oConPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean processPosition(SMPacket currentPacket, BlockPos nextPos, boolean bIsTree) {
        Block nextBlock = this.oPlayer.field_70170_p.func_147439_a(nextPos.getX(), nextPos.getY(), nextPos.getZ());
        if (nextBlock != null && nextBlock != Blocks.field_150350_a && this.ensureIsConnectedToTree(currentPacket, nextPos)) {
            boolean bIsValidWood = nextBlock.func_149688_o() == Material.field_151575_d && Globals.isIdInList(nextBlock, this.myGlobals.lBlockIDs);
            boolean bIsValidLeaves = nextBlock.func_149688_o() == Material.field_151584_j && Globals.isIdInList(nextBlock, this.myGlobals.lLeafIDs);
            String sNextName = this.getUniqueIdentifier(nextPos);
            if (bIsValidWood && currentPacket.sWoodName.equalsIgnoreCase(sNextName) || bIsValidLeaves && (currentPacket.sLeafName.isEmpty() || currentPacket.sLeafName.equalsIgnoreCase(sNextName))) {
                if (bIsValidLeaves && currentPacket.sLeafName.isEmpty()) {
                    currentPacket.sLeafName = sNextName;
                }
                if (bIsValidWood || bIsValidLeaves && SettingsLumbinator.bDestroyLeaves) {
                    currentPacket.positions.offer(nextPos);
                }
                if (bIsValidLeaves && !bIsTree) {
                    return true;
                }
            } else if (SettingsLumbinator.bDestroyLeaves && nextBlock instanceof BlockSnow) {
                currentPacket.positions.offer(nextPos);
            }
        }
        return bIsTree;
    }
}

