/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsExcavator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.keys.KeyBindings;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.ExcavationHelper;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.objects.GodItems;
import duelmonster.superminer.submods.Shaftanator;
import duelmonster.superminer.util.BlockPos;
import duelmonster.superminer.util.EnumFacing;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

@Mod(modid="superminer_excavator", name="Excavator", version="[1.7.10]-2.1.6.214", acceptedMinecraftVersions="[1.7.10]")
public class Excavator {
    public static final String MODID = "superminer_excavator";
    public static final String MODName = "Excavator";
    public static final String ChannelName = "superminer_excavator".substring(0, "superminer_excavator".length() < 20 ? "superminer_excavator".length() : 20);
    public static boolean bToggled = false;
    public static boolean bLayerOnlyToggled = false;
    public static Globals myGlobals = new Globals();
    private boolean bHungerNotified = false;
    public static boolean bShouldSyncSettings = true;
    private static List<ExcavationHelper> myExcavationHelpers = new ArrayList<ExcavationHelper>();

    public static boolean isToggled() {
        return bToggled || bLayerOnlyToggled;
    }

    private static List<ExcavationHelper> getMyExcavationHelpers() {
        return new ArrayList<ExcavationHelper>(myExcavationHelpers);
    }

    public static Boolean isExcavating() {
        boolean bIsExcavating = false;
        for (ExcavationHelper oEH : Excavator.getMyExcavationHelpers()) {
            if (bIsExcavating) continue;
            bIsExcavating = oEH != null && oEH.isExcavating();
        }
        return bIsExcavating;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static void syncConfig() {
        SettingsExcavator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.excavator.enabled"), MODID, true, Globals.localize("superminer.excavator.enabled.desc"));
        SettingsExcavator.bGatherDrops = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.excavator.gather_drops"), MODID, true, Globals.localize("superminer.excavator.gather_drops.desc"));
        SettingsExcavator.bAutoIlluminate = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.excavator.auto_illum"), MODID, true, Globals.localize("superminer.excavator.auto_illum.desc"));
        SettingsExcavator.lToolIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.excavator.tool_ids"), MODID, SettingsExcavator.lToolIDDefaults.toArray(new String[0]), Globals.localize("superminer.excavator.tool_ids.desc"))));
        SettingsExcavator.iBlockRadius = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.excavator.radius"), MODID, 3, 3, 16, Globals.localize("superminer.excavator.radius.desc"));
        SettingsExcavator.iBlockLimit = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.excavator.limit"), MODID, 27, 27, 4096, Globals.localize("superminer.excavator.limit.desc"));
        Excavator.myGlobals.lToolIDs = Globals.IDListToArray(SettingsExcavator.lToolIDs, false);
        Excavator.myGlobals.iBlockRadius = SettingsExcavator.iBlockRadius;
        Excavator.myGlobals.iBlockLimit = SettingsExcavator.iBlockLimit;
        ArrayList<String> order = new ArrayList<String>(7);
        order.add(Globals.localize("superminer.excavator.enabled"));
        order.add(Globals.localize("superminer.excavator.gather_drops"));
        order.add(Globals.localize("superminer.excavator.auto_illum"));
        order.add(Globals.localize("superminer.excavator.tool_ids"));
        order.add(Globals.localize("superminer.excavator.radius"));
        order.add(Globals.localize("superminer.excavator.limit"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isStringMessage()) continue;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player;
        if (!PlayerEvents.IsPlayerInWorld() || Shaftanator.bToggled || !SettingsExcavator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (!mc.field_71415_G || mc.func_147113_T()) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)SettingsExcavator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (world != null) {
            bToggled = Globals.isKeyDownEx(KeyBindings.excavator_toggle.func_151463_i());
            bLayerOnlyToggled = Globals.isKeyDownEx(KeyBindings.excavator_layer_only_toggle.func_151463_i());
            GodItems.isWorthy(bToggled);
            Block block = null;
            int metadata = -1;
            BlockPos oPos = null;
            if (Excavator.isToggled() && (Globals.isAttacking(mc) || Globals.isUsingItem(mc)) && player.func_110143_aJ() > 0.0f && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                oPos = new BlockPos(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
                block = world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ());
                metadata = world.func_72805_g(oPos.getX(), oPos.getY(), oPos.getZ());
                if (!Globals.isAttacking(mc) && block != null && block == Blocks.field_150350_a) {
                    block = null;
                }
                if (block != null) {
                    if (!this.bHungerNotified && player.func_71024_bL().func_75116_a() <= 1) {
                        Globals.NotifyClient(Globals.tooHungry() + MODName);
                        this.bHungerNotified = true;
                        return;
                    }
                    if (player.func_71024_bL().func_75116_a() > 1) {
                        myGlobals.addAttackBlock((EntityPlayer)player, block, metadata, oPos, EnumFacing.getFront(mc.field_71476_x.field_72310_e), false, false, false, bLayerOnlyToggled);
                    }
                } else {
                    this.bHungerNotified = false;
                }
            }
            Iterator attackPackets = Excavator.myGlobals.attackHistory.iterator();
            while (attackPackets.hasNext()) {
                SMPacket packet = (SMPacket)attackPackets.next();
                if (System.nanoTime() - packet.nanoTime >= 3000000000L) {
                    attackPackets.remove();
                    continue;
                }
                block = world.func_147439_a(packet.oPos.getX(), packet.oPos.getY(), packet.oPos.getZ());
                if (block != null && block != Blocks.field_150350_a) continue;
                attackPackets.remove();
                packet.block = packet.prevBlock;
                packet.bLayerOnlyToggled = bLayerOnlyToggled;
                Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)packet.writePacketData()));
            }
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.packet.payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Excavator.value()) {
            SettingsExcavator.readPacketData(payLoad);
            Excavator.myGlobals.lToolIDs = Globals.IDListToArray(SettingsExcavator.lToolIDs, false);
            Excavator.myGlobals.iBlockRadius = SettingsExcavator.iBlockRadius;
            Excavator.myGlobals.iBlockLimit = SettingsExcavator.iBlockLimit;
        } else if (SettingsExcavator.bEnabled) {
            EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
            if (iPacketID == PacketIDs.BLOCKINFO.value()) {
                SMPacket packet = new SMPacket();
                packet.readPacketData(payLoad);
                this.Excavate(packet, player);
            } else if (iPacketID == PacketIDs.GODITEMS.value()) {
                GodItems.GiveGodTools((EntityPlayer)player);
            }
        }
    }

    protected void Excavate(SMPacket packet, EntityPlayerMP player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null || !Excavator.isAllowedToMine((EntityPlayer)player, packet.block)) {
            return;
        }
        ExcavationHelper oEH = new ExcavationHelper((World)world, player, packet);
        myExcavationHelpers.add(oEH);
        oEH.getExcavationBlocks();
        if (!oEH.ExcavateSection()) {
            oEH.FinalizeExcavation();
            myExcavationHelpers.remove(oEH);
        }
    }

    @SubscribeEvent
    public void tickEvent_Server(TickEvent.ServerTickEvent event) {
        if (TickEvent.Phase.END.equals((Object)event.phase) && myExcavationHelpers.size() > 0) {
            for (ExcavationHelper oEH : Excavator.getMyExcavationHelpers()) {
                if (!oEH.isExcavating() || oEH.ExcavateSection()) continue;
                oEH.FinalizeExcavation();
                myExcavationHelpers.remove(oEH);
            }
        }
    }

    private static boolean isAllowedToMine(EntityPlayer player, Block block) {
        if (null == block || Blocks.field_150350_a == block || block.func_149688_o().func_76224_d() || Blocks.field_150357_h == block) {
            return false;
        }
        return player.func_146099_a(block);
    }
}

