/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsIlluminator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.keys.KeyBindings;
import duelmonster.superminer.network.packets.IlluminatorPacket;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.util.BlockPos;
import duelmonster.superminer.util.EnumFacing;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

@Mod(modid="superminer_illuminator", name="Illuminator", version="[1.7.10]-2.1.6.214", acceptedMinecraftVersions="[1.7.10]")
public class Illuminator {
    public static final String MODID = "superminer_illuminator";
    public static final String MODName = "Illuminator";
    public static final String ChannelName = "superminer_illuminator".substring(0, "superminer_illuminator".length() < 20 ? "superminer_illuminator".length() : 20);
    @Mod.Instance(value="superminer_illuminator")
    private Illuminator instance;
    private static BlockPos lastTorchLocation = null;
    public static boolean bShouldSyncSettings = true;
    private static boolean bIsPlacingTorch = false;

    public static boolean isPlacingTorch() {
        return bIsPlacingTorch;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static void syncConfig() {
        SettingsIlluminator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.illuminator.enabled"), MODID, true, Globals.localize("superminer.illuminator.enabled.desc"));
        SettingsIlluminator.iLowestLightLevel = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.illuminator.light_level"), MODID, 7, 0, 16, Globals.localize("superminer.illuminator.light_level.desc"));
        ArrayList<String> order = new ArrayList<String>(2);
        order.add(Globals.localize("superminer.illuminator.enabled"));
        order.add(Globals.localize("superminer.illuminator.light_level"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player;
        if (!PlayerEvents.IsPlayerInWorld() || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (!mc.field_71415_G || mc.func_147113_T()) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)SettingsIlluminator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (world != null) {
            if (KeyBindings.illuminator_place.func_151468_f()) {
                Illuminator.PlaceTorch(mc, (EntityPlayer)player);
            } else if (bIsPlacingTorch) {
                bIsPlacingTorch = false;
            } else if (SettingsIlluminator.bEnabled && Globals.isAttacking(mc) && player.func_110143_aJ() > 0.0f) {
                int x = (int)(player.field_70121_D.field_72340_a + 0.5);
                int y = (int)player.field_70121_D.field_72338_b;
                int z = (int)(player.field_70121_D.field_72339_c + 0.5);
                BlockPos oPos = new BlockPos(x, y, z);
                if (!(world.func_147437_c(oPos.getX(), oPos.getY(), oPos.getZ()) || world.func_147439_a(oPos.getX(), oPos.down().getY(), oPos.getZ()).canPlaceTorchOnTop((World)world, oPos.getX(), oPos.down().getY(), oPos.getZ()) || world.func_147437_c((oPos = new BlockPos(x = (int)(player.field_70121_D.field_72340_a - 0.5), y, z = (int)(player.field_70121_D.field_72339_c - 0.5))).getX(), oPos.getY(), oPos.getZ()) || world.func_147439_a(oPos.getX(), oPos.down().getY(), oPos.getZ()).canPlaceTorchOnTop((World)world, oPos.getX(), oPos.down().getY(), oPos.getZ()) || world.func_147437_c((oPos = new BlockPos(x = (int)(player.field_70121_D.field_72340_a + 0.5), y, z = (int)(player.field_70121_D.field_72339_c - 0.5))).getX(), oPos.getY(), oPos.getZ()) || world.func_147439_a(oPos.getX(), oPos.down().getY(), oPos.getZ()).canPlaceTorchOnTop((World)world, oPos.getX(), oPos.down().getY(), oPos.getZ()))) {
                    x = (int)(player.field_70121_D.field_72340_a - 0.5);
                    z = (int)(player.field_70121_D.field_72339_c + 0.5);
                    oPos = new BlockPos(x, y, z);
                }
                if (world.func_72957_l(oPos.getX(), oPos.getY(), oPos.getZ()) <= SettingsIlluminator.iLowestLightLevel && world.func_147437_c(oPos.getX(), oPos.getY(), oPos.getZ()) && world.func_147439_a(oPos.getX(), oPos.down().getY(), oPos.getZ()).canPlaceTorchOnTop((World)world, oPos.getX(), oPos.down().getY(), oPos.getZ())) {
                    Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)new IlluminatorPacket(oPos).writePacketData()));
                }
            }
        } else {
            lastTorchLocation = null;
        }
    }

    @SubscribeEvent
    public void severTickEvent(TickEvent.ServerTickEvent event) {
        if (!SettingsIlluminator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        for (FMLInterModComms.IMCMessage imcMessage : FMLInterModComms.fetchRuntimeMessages((Object)this.instance)) {
            this.processIMC(imcMessage);
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.packet.payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Illuminator.value()) {
            SettingsIlluminator.readPacketData(payLoad);
        } else if (SettingsIlluminator.bEnabled && iPacketID == 1) {
            IlluminatorPacket iPacket = new IlluminatorPacket();
            iPacket.readPacketData(payLoad);
            Illuminator.Illuminate((EntityPlayer)((NetHandlerPlayServer)event.handler).field_147369_b, iPacket.oPos, iPacket.sideHit);
        }
    }

    protected static void Illuminate(EntityPlayer player, BlockPos oPos, EnumFacing sideHit) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (world == null) {
            return;
        }
        int iTorchStackCount = 0;
        int iTorchIndx = -1;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null || !stack.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150478_aa))) continue;
            ++iTorchStackCount;
            iTorchIndx = i;
        }
        if (iTorchIndx >= 0 && !oPos.equals(lastTorchLocation)) {
            lastTorchLocation = new BlockPos(oPos);
            int torchFacing = 5;
            if (sideHit == EnumFacing.NORTH) {
                torchFacing = 4;
            } else if (sideHit == EnumFacing.SOUTH) {
                torchFacing = 3;
            } else if (sideHit == EnumFacing.WEST) {
                torchFacing = 2;
            } else if (sideHit == EnumFacing.EAST) {
                torchFacing = 1;
            }
            world.func_147465_d(oPos.getX(), oPos.getY(), oPos.getZ(), Blocks.field_150478_aa, torchFacing, 2);
            Globals.playSound((World)world, Blocks.field_150478_aa.field_149762_H, oPos);
            ItemStack torchStack = player.field_71071_by.func_70298_a(iTorchIndx, 1);
            if (torchStack.field_77994_a <= 0) {
                lastTorchLocation = null;
                --iTorchStackCount;
            }
            if (iTorchStackCount == 0) {
                player.func_145747_a((IChatComponent)new ChatComponentText("\u00a75[SuperMiner] \u00a76Illuminator: \u00a7c" + Globals.localize("superminer.illuminator.no_torches")));
            }
        }
    }

    public void processIMC(FMLInterModComms.IMCMessage imcMessage) {
        if (imcMessage.key.equalsIgnoreCase("IlluminateShaft") && imcMessage.isNBTMessage()) {
            int z;
            int y;
            NBTTagCompound nbt = imcMessage.getNBTValue();
            IlluminatorPacket iPacket = new IlluminatorPacket();
            iPacket.readPacketData(new PacketBuffer(Unpooled.copiedBuffer((byte[])nbt.func_74770_j("IlluminateShaftData"))));
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (null == server) {
                return;
            }
            EntityPlayer player = (EntityPlayer)server.func_130014_f_().func_73045_a(iPacket.playerID);
            if (player == null) {
                return;
            }
            WorldServer world = server.func_71218_a(player.field_71093_bK);
            if (world == null) {
                return;
            }
            int x = (int)((float)iPacket.oPos.getX() + 0.5f);
            BlockPos oPos = new BlockPos(x, y = iPacket.oPos.getY(), z = (int)((float)iPacket.oPos.getZ() + 0.5f));
            if (!(world.func_147437_c(oPos.getX(), oPos.getY(), oPos.getZ()) || world.func_147439_a(oPos.getX(), oPos.down().getY(), oPos.getZ()).canPlaceTorchOnTop((World)world, oPos.getX(), oPos.down().getY(), oPos.getZ()) || world.func_147437_c((oPos = new BlockPos(x = (int)((float)iPacket.oPos.getX() - 0.5f), y, z = (int)((float)iPacket.oPos.getZ() - 0.5f))).getX(), oPos.getY(), oPos.getZ()) || world.func_147439_a(oPos.getX(), oPos.down().getY(), oPos.getZ()).canPlaceTorchOnTop((World)world, oPos.getX(), oPos.down().getY(), oPos.getZ()) || world.func_147437_c((oPos = new BlockPos(x = (int)((float)iPacket.oPos.getX() + 0.5f), y, z = (int)((float)iPacket.oPos.getZ() - 0.5f))).getX(), oPos.getY(), oPos.getZ()) || world.func_147439_a(oPos.getX(), oPos.down().getY(), oPos.getZ()).canPlaceTorchOnTop((World)world, oPos.getX(), oPos.down().getY(), oPos.getZ()))) {
                x = (int)((float)iPacket.oPos.getX() - 0.5f);
                z = (int)((float)iPacket.oPos.getZ() + 0.5f);
                oPos = new BlockPos(x, y, z);
            }
            if (world.func_72957_l(oPos.getX(), oPos.getY(), oPos.getZ()) <= SettingsIlluminator.iLowestLightLevel && world.func_147437_c(oPos.getX(), oPos.getY(), oPos.getZ()) && world.func_147439_a(oPos.getX(), oPos.down().getY(), oPos.getZ()).canPlaceTorchOnTop((World)world, oPos.getX(), oPos.down().getY(), oPos.getZ())) {
                Illuminator.Illuminate(player, oPos, EnumFacing.UP);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void PlaceTorch(Minecraft mc, EntityPlayer player) {
        BlockPos oPos;
        if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mc.field_71441_e.func_147439_a((oPos = new BlockPos(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d)).getX(), oPos.getY(), oPos.getZ()) != Blocks.field_150478_aa) {
            EnumFacing sideHit = EnumFacing.getFront(mc.field_71476_x.field_72310_e);
            BlockPos oSidePos = new BlockPos(oPos);
            if (sideHit == EnumFacing.DOWN) {
                return;
            }
            if (sideHit == EnumFacing.UP) {
                oSidePos = oPos.up();
            } else if (sideHit == EnumFacing.NORTH) {
                oSidePos = oPos.north();
            } else if (sideHit == EnumFacing.SOUTH) {
                oSidePos = oPos.south();
            } else if (sideHit == EnumFacing.EAST) {
                oSidePos = oPos.east();
            } else if (sideHit == EnumFacing.WEST) {
                oSidePos = oPos.west();
            }
            BlockPos oPosDown = oPos.down();
            Block block = mc.field_71441_e.func_147439_a(oPosDown.getX(), oPosDown.getY(), oPosDown.getZ());
            if (mc.field_71441_e.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ()).isReplaceable((IBlockAccess)mc.field_71441_e, oPos.getX(), oPos.getY(), oPos.getZ()) && block.isSideSolid((IBlockAccess)mc.field_71441_e, oPosDown.getX(), oPosDown.getY(), oPosDown.getZ(), ForgeDirection.UP)) {
                Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)new IlluminatorPacket(oPos, EnumFacing.UP).writePacketData()));
            } else if (mc.field_71441_e.func_147437_c(oSidePos.getX(), oSidePos.getY(), oSidePos.getZ()) && block.isSideSolid((IBlockAccess)mc.field_71441_e, oPos.getX(), oPos.getY(), oPos.getZ(), ForgeDirection.getOrientation((int)sideHit.getIndex()))) {
                Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)new IlluminatorPacket(oSidePos, sideHit).writePacketData()));
            }
        }
    }
}

