/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsLumbinator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.objects.TreeHelper;
import duelmonster.superminer.submods.Excavator;
import duelmonster.superminer.submods.Shaftanator;
import duelmonster.superminer.util.BlockPos;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;

@Mod(modid="superminer_lumbinator", name="Lumbinator", version="[1.7.10]-2.1.6.214", acceptedMinecraftVersions="[1.7.10]")
public class Lumbinator {
    public static final String MODID = "superminer_lumbinator";
    public static final String MODName = "Lumbinator";
    public static final String ChannelName = "superminer_lumbinator".substring(0, "superminer_lumbinator".length() < 20 ? "superminer_lumbinator".length() : 20);
    public static final int BREAK_LIMIT = 16;
    public static Globals myGlobals = new Globals();
    private static List<SMPacket> myPackets = new ArrayList<SMPacket>();
    private static EntityPlayerMP oPlayer = null;
    private boolean bHungerNotified = false;
    public static boolean bShouldSyncSettings = true;
    private static ItemStack oHeldItem = null;
    private static int iHeldSlot = -99;

    private static List<SMPacket> getMyPackets() {
        return new ArrayList<SMPacket>(myPackets);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static void syncConfig() {
        SettingsLumbinator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.lumbinator.enabled"), MODID, true, Globals.localize("superminer.lumbinator.enabled.desc"));
        SettingsLumbinator.bGatherDrops = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.lumbinator.gather_drops"), MODID, false, Globals.localize("superminer.lumbinator.gather_drops.desc"));
        SettingsLumbinator.bChopTreeBelow = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.lumbinator.chop_below"), MODID, false, Globals.localize("superminer.lumbinator.chop_below.desc"));
        SettingsLumbinator.bDestroyLeaves = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.lumbinator.destroy_leaves"), MODID, true, Globals.localize("superminer.lumbinator.destroy_leaves.desc"));
        SettingsLumbinator.bLeavesAffectDurability = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.lumbinator.leaves_affect_durability"), MODID, false, Globals.localize("superminer.lumbinator.leaves_affect_durability.desc"));
        SettingsLumbinator.lToolIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.lumbinator.tool_ids"), MODID, SettingsLumbinator.lToolIDDefaults.toArray(new String[0]), Globals.localize("superminer.lumbinator.tool_ids.desc"))));
        SettingsLumbinator.lWoodIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.lumbinator.wood_ids"), MODID, SettingsLumbinator.lWoodIDDefaults.toArray(new String[0]), Globals.localize("superminer.lumbinator.wood_ids.desc"))));
        SettingsLumbinator.lLeafIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.lumbinator.leaf_ids"), MODID, SettingsLumbinator.lLeafIDDefaults.toArray(new String[0]), Globals.localize("superminer.lumbinator.leaf_ids.desc"))));
        SettingsLumbinator.iLeafRange = SuperMiner_Core.configFile.getInt(Globals.localize("superminer.lumbinator.leaf_range"), MODID, 3, 0, Integer.MAX_VALUE, Globals.localize("superminer.lumbinator.leaf_range.desc"));
        Lumbinator.myGlobals.lToolIDs = Globals.IDListToArray(SettingsLumbinator.lToolIDs, false);
        Lumbinator.myGlobals.lBlockIDs = Globals.IDListToArray(SettingsLumbinator.lWoodIDs, true);
        Lumbinator.myGlobals.lLeafIDs = Globals.IDListToArray(SettingsLumbinator.lLeafIDs, true);
        ArrayList<String> order = new ArrayList<String>(9);
        order.add(Globals.localize("superminer.lumbinator.enabled"));
        order.add(Globals.localize("superminer.lumbinator.gather_drops"));
        order.add(Globals.localize("superminer.lumbinator.chop_below"));
        order.add(Globals.localize("superminer.lumbinator.destroy_leaves"));
        order.add(Globals.localize("superminer.lumbinator.leaves_affect_durability"));
        order.add(Globals.localize("superminer.lumbinator.tool_ids"));
        order.add(Globals.localize("superminer.lumbinator.wood_ids"));
        order.add(Globals.localize("superminer.lumbinator.leaf_ids"));
        order.add(Globals.localize("superminer.lumbinator.leaf_range"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isStringMessage()) continue;
            if (message.key.equalsIgnoreCase("addAxe") && !SettingsLumbinator.lToolIDs.contains(message.getStringValue())) {
                SettingsLumbinator.lToolIDs.add(message.getStringValue());
                SuperMiner_Core.configFile.get(MODID, Globals.localize("superminer.lumbinator.tool_ids"), SettingsLumbinator.lToolIDDefaults.toArray(new String[0]), Globals.localize("superminer.lumbinator.tool_ids.desc")).set(SettingsLumbinator.lToolIDs.toArray(new String[0]));
                SuperMiner_Core.configFile.save();
                continue;
            }
            if (message.key.equalsIgnoreCase("addWood") && !SettingsLumbinator.lWoodIDs.contains(message.getStringValue())) {
                SettingsLumbinator.lWoodIDs.add(message.getStringValue());
                SuperMiner_Core.configFile.get(MODID, Globals.localize("superminer.lumbinator.wood_ids"), SettingsLumbinator.lWoodIDDefaults.toArray(new String[0]), Globals.localize("superminer.lumbinator.wood_ids.desc")).set(SettingsLumbinator.lWoodIDs.toArray(new String[0]));
                SuperMiner_Core.configFile.save();
                continue;
            }
            if (!message.key.equalsIgnoreCase("addLeaves") || SettingsLumbinator.lLeafIDs.contains(message.getStringValue())) continue;
            SettingsLumbinator.lLeafIDs.add(message.getStringValue());
            SuperMiner_Core.configFile.get(MODID, Globals.localize("superminer.lumbinator.leaf_ids"), SettingsLumbinator.lLeafIDDefaults.toArray(new String[0]), Globals.localize("superminer.lumbinator.leaf_ids.desc")).set(SettingsLumbinator.lLeafIDs.toArray(new String[0]));
            SuperMiner_Core.configFile.save();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player;
        if (!PlayerEvents.IsPlayerInWorld() || Excavator.isToggled() || Shaftanator.bToggled || !SettingsLumbinator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (!mc.field_71415_G || mc.func_147113_T()) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)SettingsLumbinator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g)) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (world != null) {
            Block block = null;
            int x = 0;
            int y = 0;
            int z = 0;
            if (player.func_110143_aJ() > 0.0f && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                x = mc.field_71476_x.field_72311_b;
                y = mc.field_71476_x.field_72312_c;
                z = mc.field_71476_x.field_72309_d;
                block = world.func_147439_a(x, y, z);
                if (!Globals.isAttacking(mc) && block != null && block == Blocks.field_150350_a) {
                    block = null;
                }
            }
            if (block != null && Globals.isIdInList(block, Lumbinator.myGlobals.lBlockIDs)) {
                if (!this.bHungerNotified && player.func_71024_bL().func_75116_a() <= 1) {
                    Globals.NotifyClient(Globals.tooHungry() + MODName);
                    this.bHungerNotified = true;
                    return;
                }
                if (player.func_71024_bL().func_75116_a() > 1) {
                    int metadata = world.func_72805_g(x, y, z);
                    myGlobals.addAttackBlock((EntityPlayer)player, block, metadata, new BlockPos(x, y, z), false, true, true, false);
                }
            } else {
                this.bHungerNotified = false;
            }
            Iterator attackPackets = Lumbinator.myGlobals.attackHistory.iterator();
            while (attackPackets.hasNext()) {
                SMPacket packet = (SMPacket)attackPackets.next();
                if (System.nanoTime() - packet.nanoTime >= 3000000000L) {
                    attackPackets.remove();
                    continue;
                }
                block = world.func_147439_a(packet.oPos.getX(), packet.oPos.getY(), packet.oPos.getZ());
                if (block != null && block != Blocks.field_150350_a) continue;
                attackPackets.remove();
                Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)packet.writePacketData()));
            }
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.packet.payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Lumbinator.value()) {
            SettingsLumbinator.readPacketData(payLoad);
            Lumbinator.myGlobals.lToolIDs = Globals.IDListToArray(SettingsLumbinator.lToolIDs, false);
            Lumbinator.myGlobals.lBlockIDs = Globals.IDListToArray(SettingsLumbinator.lWoodIDs, true);
            Lumbinator.myGlobals.lLeafIDs = Globals.IDListToArray(SettingsLumbinator.lLeafIDs, true);
        } else if (SettingsLumbinator.bEnabled && iPacketID == PacketIDs.BLOCKINFO.value()) {
            SMPacket packet = new SMPacket();
            packet.readPacketData(payLoad);
            if (oPlayer == null) {
                oPlayer = ((NetHandlerPlayServer)event.handler).field_147369_b;
            }
            if (Lumbinator.isChoppableTree(packet)) {
                myPackets.add(packet);
                Lumbinator.chopTree(packet);
            }
        }
    }

    private static boolean isChoppableTree(SMPacket currentPacket) {
        int yStart;
        Block block = currentPacket.block;
        if (block == null || block.func_149688_o() != Material.field_151575_d || !Globals.isIdInList(block, Lumbinator.myGlobals.lBlockIDs)) {
            return false;
        }
        ItemStack oEquippedItem = oPlayer.func_70694_bm();
        if (oEquippedItem == null || oEquippedItem.field_77994_a <= 0 || !Globals.isIdInList(oEquippedItem.func_77973_b(), Lumbinator.myGlobals.lToolIDs) || !Globals.isIdInList(block, Lumbinator.myGlobals.lBlockIDs)) {
            return false;
        }
        if (!currentPacket.positions.contains(currentPacket.oPos)) {
            currentPacket.positions.offer(currentPacket.oPos);
        }
        TreeHelper oTreeHelper = new TreeHelper((EntityPlayer)oPlayer, myGlobals);
        int yLevel = yStart = currentPacket.oPos.getY();
        currentPacket.sWoodName = oTreeHelper.getUniqueIdentifier(block, currentPacket.metadata);
        currentPacket.sLeafName = oTreeHelper.getLeafName(currentPacket);
        oTreeHelper.DetectTreeWidth(currentPacket);
        boolean bIsTree = false;
        if (!currentPacket.sLeafName.isEmpty()) {
            int iMinX = currentPacket.oPos.getX() - SettingsLumbinator.iLeafRange - (oTreeHelper.iTreeWidthMinusX == 0 ? 1 : oTreeHelper.iTreeWidthMinusX);
            int iMaxX = currentPacket.oPos.getX() + SettingsLumbinator.iLeafRange + (oTreeHelper.iTreeWidthPlusX == 0 ? 1 : oTreeHelper.iTreeWidthPlusX);
            int iMinZ = currentPacket.oPos.getZ() - SettingsLumbinator.iLeafRange - (oTreeHelper.iTreeWidthMinusZ == 0 ? 1 : oTreeHelper.iTreeWidthMinusZ);
            int iMaxZ = currentPacket.oPos.getZ() + SettingsLumbinator.iLeafRange + (oTreeHelper.iTreeWidthPlusZ == 0 ? 1 : oTreeHelper.iTreeWidthPlusZ);
            boolean bBelowGot = false;
            while (yLevel < Lumbinator.oPlayer.field_70170_p.func_72800_K()) {
                for (int xPos = iMinX; xPos <= iMaxX; ++xPos) {
                    for (int zPos = iMinZ; zPos <= iMaxZ; ++zPos) {
                        bIsTree = oTreeHelper.processPosition(currentPacket, new BlockPos(xPos, yLevel, zPos), bIsTree);
                    }
                }
                if (SettingsLumbinator.bChopTreeBelow && yLevel <= yStart && !bBelowGot) {
                    if (--yLevel > 0) continue;
                    yLevel = yStart;
                    bBelowGot = true;
                    continue;
                }
                ++yLevel;
            }
        }
        return bIsTree;
    }

    @SubscribeEvent
    public void tickEvent_Server(TickEvent.ServerTickEvent event) {
        if (TickEvent.Phase.END.equals((Object)event.phase) && !myPackets.isEmpty()) {
            for (SMPacket currentPacket : Lumbinator.getMyPackets()) {
                if (currentPacket == null) continue;
                Lumbinator.chopTree(currentPacket);
            }
        }
    }

    private static void chopTree(SMPacket currentPacket) {
        int iCount = 0;
        if (oHeldItem == null) {
            oHeldItem = oPlayer.func_70694_bm().func_77946_l();
            iHeldSlot = Lumbinator.oPlayer.field_71071_by.field_70461_c;
        }
        while (iCount < 16 && !currentPacket.positions.isEmpty()) {
            if (!Lumbinator.breakBlock(currentPacket)) continue;
            ++iCount;
        }
        if (currentPacket.positions.isEmpty()) {
            List<Entity> list;
            if (oHeldItem != null && Lumbinator.oPlayer.field_71071_by.func_70301_a(iHeldSlot) != oHeldItem) {
                Lumbinator.oPlayer.field_71071_by.func_70299_a(iHeldSlot, oHeldItem);
                Lumbinator.oPlayer.field_71070_bA.func_75142_b();
            }
            Globals.stackItems(Lumbinator.oPlayer.field_70170_p, (EntityPlayer)oPlayer, AxisAlignedBB.func_72330_a((double)currentPacket.oPos.getX(), (double)currentPacket.oPos.getZ(), (double)currentPacket.oPos.getZ(), (double)currentPacket.oPos.getX(), (double)currentPacket.oPos.getZ(), (double)currentPacket.oPos.getZ()).func_72314_b(8.0, 8.0, 8.0));
            if (SettingsLumbinator.bGatherDrops && null != (list = Globals.getNearbyEntities(Lumbinator.oPlayer.field_70170_p, Lumbinator.oPlayer.field_70121_D.func_72314_b(8.0, 8.0, 8.0))) && !list.isEmpty()) {
                for (Entity entity : list) {
                    if (entity.field_70128_L) continue;
                    entity.func_70107_b((double)currentPacket.oPos.getX(), (double)currentPacket.oPos.getZ(), (double)currentPacket.oPos.getZ());
                }
            }
            myPackets.remove(currentPacket);
            oHeldItem = null;
            iHeldSlot = -99;
        }
    }

    private static boolean breakBlock(SMPacket currentPacket) {
        BlockPos blockPos = currentPacket.positions.poll();
        if (blockPos == null) {
            return false;
        }
        Block block = Lumbinator.oPlayer.field_70170_p.func_147439_a(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        boolean bIsLeaves = block.func_149688_o() == Material.field_151584_j && Globals.isIdInList(block, Lumbinator.myGlobals.lLeafIDs);
        boolean bRtrn = false;
        if (!Lumbinator.oPlayer.field_70170_p.func_147437_c(blockPos.getX(), blockPos.getY(), blockPos.getZ())) {
            if (bIsLeaves && !SettingsLumbinator.bLeavesAffectDurability) {
                Lumbinator.oPlayer.field_71071_by.func_70299_a(iHeldSlot, null);
                Lumbinator.oPlayer.field_71070_bA.func_75142_b();
            }
            bRtrn = Lumbinator.oPlayer.field_71134_c.func_73084_b(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            if (oHeldItem != null && Lumbinator.oPlayer.field_71071_by.func_70301_a(iHeldSlot) != oHeldItem) {
                Lumbinator.oPlayer.field_71071_by.func_70299_a(iHeldSlot, oHeldItem);
                Lumbinator.oPlayer.field_71070_bA.func_75142_b();
            }
        }
        return bRtrn;
    }
}

