/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsSubstitutor;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.objects.SubstitutionHelper;
import duelmonster.superminer.submods.Excavator;
import duelmonster.superminer.submods.Illuminator;
import duelmonster.superminer.submods.Shaftanator;
import duelmonster.superminer.submods.Veinator;
import duelmonster.superminer.util.BlockPos;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

@Mod(modid="superminer_substitutor", name="Substitutor", version="[1.7.10]-2.1.6.214", acceptedMinecraftVersions="[1.7.10]")
public class Substitutor {
    public static final String MODID = "superminer_substitutor";
    public static final String MODName = "Substitutor";
    public static final String ChannelName = "superminer_substitutor".substring(0, "superminer_substitutor".length() < 20 ? "superminer_substitutor".length() : 20);
    public static FMLEventChannel eventChannel;
    public static List<Object> lExcludedBlockIDs;
    public static boolean bShouldSyncSettings;
    private static boolean wasAttacking;
    private static boolean bSwitchback;
    private static int iSubstitueTool;
    private static int iPrevItem;
    private EntityLivingBase entityAttacking = null;

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static void syncConfig() {
        SettingsSubstitutor.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.substitutor.enabled"), MODID, true, Globals.localize("superminer.substitutor.enabled.desc"));
        SettingsSubstitutor.bSwitchbackEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.substitutor.switchback"), MODID, true, Globals.localize("superminer.substitutor.switchback.desc"));
        SettingsSubstitutor.bFavourSilkTouch = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.substitutor.silk"), MODID, true, Globals.localize("superminer.substitutor.silk.desc"));
        SettingsSubstitutor.bIgnoreIfValidTool = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.substitutor.ignore_valid"), MODID, true, Globals.localize("superminer.substitutor.ignore_valid.desc"));
        SettingsSubstitutor.bIgnorePassiveMobs = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.substitutor.ignore_passive"), MODID, true, Globals.localize("superminer.substitutor.ignore_passive.desc"));
        SettingsSubstitutor.saExcludedBlockIDs = SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.substitutor.excluded_ids"), MODID, SettingsSubstitutor.saExcludedBlockIDDefaults, Globals.localize("superminer.substitutor.excluded_ids.desc"));
        lExcludedBlockIDs = Globals.IDListToArray(SettingsSubstitutor.saExcludedBlockIDs, true);
        ArrayList<String> order = new ArrayList<String>(6);
        order.add(Globals.localize("superminer.substitutor.enabled"));
        order.add(Globals.localize("superminer.substitutor.switchback"));
        order.add(Globals.localize("superminer.substitutor.silk"));
        order.add(Globals.localize("superminer.substitutor.ignore_valid"));
        order.add(Globals.localize("superminer.substitutor.ignore_passive"));
        order.add(Globals.localize("superminer.substitutor.excluded_ids"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.packet.payload());
        PacketBuffer payLoadClone = new PacketBuffer(payLoad.copy());
        int iPacketID = payLoadClone.readInt();
        if (iPacketID == PacketIDs.Settings_Substitutor.value()) {
            SettingsSubstitutor.readPacketData(payLoad);
            lExcludedBlockIDs = Globals.IDListToArray(SettingsSubstitutor.saExcludedBlockIDs, true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player;
        if (!PlayerEvents.IsPlayerInWorld() || !SettingsSubstitutor.bEnabled || !TickEvent.Phase.START.equals((Object)event.phase) || Excavator.isExcavating().booleanValue() || Illuminator.isPlacingTorch() || Shaftanator.isExcavating().booleanValue() || Veinator.isExcavating().booleanValue()) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (!mc.field_71415_G || mc.func_147113_T() || mc.field_71442_b.func_78758_h()) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)SettingsSubstitutor.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (null == world) {
            return;
        }
        boolean isAttacking = Globals.isAttacking(mc);
        if (!isAttacking && wasAttacking && bSwitchback && player.field_71071_by.field_70461_c != iPrevItem) {
            if (System.getProperty("DEBUG") != null) {
                Globals.NotifyClient(" Substitutor = Restoring item from {" + player.field_71071_by.field_70461_c + "} to {" + iPrevItem + "}");
            }
            player.field_71071_by.field_70461_c = iPrevItem;
            iSubstitueTool = -99;
            iPrevItem = -99;
            bSwitchback = false;
        } else if (isAttacking && !wasAttacking) {
            iPrevItem = player.field_71071_by.field_70461_c;
        }
        if (isAttacking && mc.field_71476_x != null) {
            if (mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                int x = mc.field_71476_x.field_72311_b;
                int y = mc.field_71476_x.field_72312_c;
                int z = mc.field_71476_x.field_72309_d;
                Block block = world.func_147439_a(x, y, z);
                if (!Globals.isIdInList(block, lExcludedBlockIDs)) {
                    this.SubstitueTool((World)world, new BlockPos(x, y, z));
                }
            } else if (mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mc.field_71476_x.field_72308_g instanceof EntityLivingBase) {
                this.SubstitueWeapon((EntityLivingBase)mc.field_71476_x.field_72308_g);
            }
        }
        wasAttacking = isAttacking;
    }

    private void SubstitueTool(World world, BlockPos oPos) {
        try {
            iSubstitueTool = iPrevItem;
            Minecraft mc = FMLClientHandler.instance().getClient();
            ItemStack[] inventory = mc.field_71439_g.field_71071_by.field_70462_a;
            for (int i = 0; i < 9; ++i) {
                if (i == iSubstitueTool || inventory[i] == null || !this.determineTool(inventory[iSubstitueTool], inventory[i], world, oPos)) continue;
                iSubstitueTool = i;
            }
            if (!(SettingsSubstitutor.bIgnoreIfValidTool && SubstitutionHelper.isSameTool(inventory[iPrevItem], inventory[iSubstitueTool]) || mc.field_71439_g.field_71071_by.field_70461_c == iSubstitueTool)) {
                if (System.getProperty("DEBUG") != null) {
                    Globals.NotifyClient(" Substitutor = Switching item from {" + mc.field_71439_g.field_71071_by.field_70461_c + "} to {" + iSubstitueTool + "}");
                }
                mc.field_71439_g.field_71071_by.field_70461_c = iSubstitueTool;
                mc.field_71439_g.field_71070_bA.func_75142_b();
                if (SettingsSubstitutor.bSwitchbackEnabled) {
                    bSwitchback = true;
                } else {
                    iPrevItem = iSubstitueTool;
                }
            }
        }
        catch (Throwable e) {
            System.out.println("Error switching tools - " + e.getMessage());
        }
    }

    private void SubstitueWeapon(EntityLivingBase entity) {
        if (SettingsSubstitutor.bIgnorePassiveMobs && !(entity instanceof EntityMob)) {
            return;
        }
        try {
            this.entityAttacking = entity;
            Minecraft mc = FMLClientHandler.instance().getClient();
            ItemStack[] inventory = mc.field_71439_g.field_71071_by.field_70462_a;
            int iSubstitueWeapon = iPrevItem;
            for (int i = 0; i < 9; ++i) {
                if (i == iSubstitueWeapon || !this.determineWeapon(inventory[iSubstitueWeapon], inventory[i], entity)) continue;
                iSubstitueWeapon = i;
            }
            if (mc.field_71439_g.field_71071_by.field_70461_c != iSubstitueWeapon) {
                if (System.getProperty("DEBUG") != null) {
                    Globals.NotifyClient(" Substitutor = Switching item from {" + mc.field_71439_g.field_71071_by.field_70461_c + "} to {" + iSubstitueWeapon + "}");
                }
                mc.field_71439_g.field_71071_by.field_70461_c = iSubstitueWeapon;
                mc.field_71439_g.field_71070_bA.func_75142_b();
                iPrevItem = iSubstitueWeapon;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean determineTool(ItemStack CurrentTool, ItemStack CompareTool, World world, BlockPos oPos) {
        Block block = world.func_147439_a(oPos.getX(), oPos.getY(), oPos.getZ());
        if (block == null || Blocks.field_150350_a == block || Blocks.field_150357_h == block) {
            return false;
        }
        float currentBlockStrength = SubstitutionHelper.getBlockStrength(CurrentTool, world, oPos);
        float compareBlockStrength = SubstitutionHelper.getBlockStrength(CompareTool, world, oPos);
        if (currentBlockStrength <= 0.0f && compareBlockStrength <= 0.0f) {
            return false;
        }
        int metadata = world.func_72805_g(oPos.getX(), oPos.getY(), oPos.getZ());
        float currentDigSpeed = SubstitutionHelper.getDigSpeed(CurrentTool, block, metadata);
        float compareDigSpeed = SubstitutionHelper.getDigSpeed(CompareTool, block, metadata);
        boolean currentToolDamageable = SubstitutionHelper.isItemStackDamageable(CurrentTool);
        boolean compareToolDamageable = SubstitutionHelper.isItemStackDamageable(CompareTool);
        if (currentToolDamageable && !compareToolDamageable && compareDigSpeed >= currentDigSpeed) {
            return true;
        }
        if (compareDigSpeed >= currentDigSpeed) {
            return true;
        }
        if (compareDigSpeed < currentDigSpeed) {
            return false;
        }
        if (SettingsSubstitutor.bFavourSilkTouch) {
            boolean compareToolHasSilkTouch;
            boolean blockIsSilkTouchable = SubstitutionHelper.isBlockSilkTouchable(world, oPos);
            boolean currentToolHasSilkTouch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)CurrentTool) > 0;
            boolean bl = compareToolHasSilkTouch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)CompareTool) > 0;
            if (blockIsSilkTouchable) {
                if (compareToolHasSilkTouch && !currentToolHasSilkTouch) {
                    return true;
                }
                if (currentToolHasSilkTouch && !compareToolHasSilkTouch) {
                    return false;
                }
            }
        }
        int currentFortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)CurrentTool);
        int compareFortuneLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)CompareTool);
        int currentAdjustedBlockStrength = SubstitutionHelper.getAdjustedBlockStrength(currentBlockStrength);
        int compareAdjustedBlockStrength = SubstitutionHelper.getAdjustedBlockStrength(compareBlockStrength);
        if (new Integer(compareAdjustedBlockStrength).compareTo(currentAdjustedBlockStrength) > 0) {
            return true;
        }
        Set<Enchantment> MutilToolEnchantments = SubstitutionHelper.getMultiToolEnchantments(CurrentTool, CompareTool);
        for (Enchantment enchantment : MutilToolEnchantments) {
            int currentLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)CurrentTool);
            int compareLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)CompareTool);
            if (compareLevel > currentLevel) {
                return true;
            }
            if (compareLevel >= currentLevel) continue;
            return false;
        }
        if (currentToolDamageable && compareToolDamageable) {
            if (compareFortuneLevel > currentFortuneLevel) {
                return false;
            }
            if (compareFortuneLevel < currentFortuneLevel) {
                return true;
            }
            int currentUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)CurrentTool);
            int compareUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)CompareTool);
            if (compareUnbreakingLevel > currentUnbreakingLevel) {
                return true;
            }
            if (compareUnbreakingLevel < currentUnbreakingLevel) {
                return false;
            }
        } else {
            int blockStrengthComparison = Float.compare(compareBlockStrength, currentBlockStrength);
            if (blockStrengthComparison > 0) {
                return true;
            }
            if (blockStrengthComparison < 0) {
                return false;
            }
        }
        return false;
    }

    private boolean determineWeapon(ItemStack CurrentWeapon, ItemStack CompareWeapon, EntityLivingBase entity) {
        boolean isPlayer = entity instanceof EntityPlayer;
        double currentWeaponDamage = SubstitutionHelper.getVanillaStackDamage(CurrentWeapon, entity);
        double compareWeaponDamage = SubstitutionHelper.getVanillaStackDamage(CompareWeapon, entity);
        if (isPlayer) {
            if (compareWeaponDamage > currentWeaponDamage) {
                return true;
            }
            if (compareWeaponDamage < currentWeaponDamage) {
                return false;
            }
        } else {
            int currentWeaponHits;
            if (SubstitutionHelper.isSword(CompareWeapon) && !SubstitutionHelper.isSword(CurrentWeapon)) {
                return true;
            }
            if (!SubstitutionHelper.isSword(CompareWeapon) && SubstitutionHelper.isSword(CurrentWeapon)) {
                return false;
            }
            if (!SubstitutionHelper.isSword(CompareWeapon) && !SubstitutionHelper.isSword(CurrentWeapon)) {
                return false;
            }
            int compareWeaponHits = compareWeaponDamage == 0.0 ? Integer.MAX_VALUE : MathHelper.func_76143_f((double)((double)this.entityAttacking.func_110138_aP() / compareWeaponDamage));
            if (compareWeaponHits < (currentWeaponHits = currentWeaponDamage == 0.0 ? Integer.MAX_VALUE : MathHelper.func_76143_f((double)((double)this.entityAttacking.func_110138_aP() / currentWeaponDamage)))) {
                return true;
            }
            if (compareWeaponHits > currentWeaponHits) {
                return false;
            }
        }
        int currentWeaponLootingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)CurrentWeapon);
        int currentWeaponFireAspectLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)CurrentWeapon);
        int currentWeaponKnockbackLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)CurrentWeapon);
        int currentWeaponUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)CurrentWeapon);
        int compareWeaponLootingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)CompareWeapon);
        int compareWeaponFireAspectLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)CompareWeapon);
        int compareWeaponKnockbackLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77337_m.field_77352_x, (ItemStack)CompareWeapon);
        int compareWeaponUnbreakingLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)CompareWeapon);
        if (!isPlayer) {
            if (compareWeaponLootingLevel > currentWeaponLootingLevel) {
                return true;
            }
            if (compareWeaponLootingLevel < currentWeaponLootingLevel) {
                return false;
            }
        }
        if (compareWeaponFireAspectLevel > currentWeaponFireAspectLevel) {
            return true;
        }
        if (compareWeaponFireAspectLevel < currentWeaponFireAspectLevel) {
            return false;
        }
        if (compareWeaponKnockbackLevel > currentWeaponKnockbackLevel) {
            return true;
        }
        if (compareWeaponKnockbackLevel < currentWeaponKnockbackLevel) {
            return false;
        }
        Set<Enchantment> MutilToolEnchantments = SubstitutionHelper.getMultiToolEnchantments(CurrentWeapon, CompareWeapon);
        for (Enchantment enchantment : MutilToolEnchantments) {
            int currentLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)CurrentWeapon);
            int compareLevel = EnchantmentHelper.func_77506_a((int)enchantment.field_77352_x, (ItemStack)CompareWeapon);
            if (compareLevel > currentLevel) {
                return true;
            }
            if (compareLevel >= currentLevel) continue;
            return false;
        }
        if (compareWeaponDamage > currentWeaponDamage) {
            return true;
        }
        if (compareWeaponDamage < currentWeaponDamage) {
            return false;
        }
        boolean currentWeaponDamageable = SubstitutionHelper.isItemStackDamageable(CurrentWeapon);
        boolean compareWeaponDamageable = SubstitutionHelper.isItemStackDamageable(CompareWeapon);
        if (compareWeaponDamageable && !currentWeaponDamageable) {
            return false;
        }
        if (currentWeaponDamageable && !compareWeaponDamageable) {
            return true;
        }
        if (currentWeaponDamageable && compareWeaponDamageable) {
            if (compareWeaponUnbreakingLevel > currentWeaponUnbreakingLevel) {
                return true;
            }
            if (compareWeaponUnbreakingLevel < currentWeaponUnbreakingLevel) {
                return false;
            }
        }
        if (CompareWeapon == null && CurrentWeapon != null) {
            return true;
        }
        if (CurrentWeapon == null && CompareWeapon != null) {
            return false;
        }
        return false;
    }

    static {
        lExcludedBlockIDs = null;
        bShouldSyncSettings = true;
        wasAttacking = false;
        bSwitchback = true;
        iSubstitueTool = -99;
        iPrevItem = -99;
    }
}

