/*
 * Decompiled with CFR 0.152.
 */
package duelmonster.superminer.submods;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import duelmonster.superminer.SuperMiner_Core;
import duelmonster.superminer.config.SettingsVeinator;
import duelmonster.superminer.events.PlayerEvents;
import duelmonster.superminer.network.packets.PacketIDs;
import duelmonster.superminer.network.packets.SMPacket;
import duelmonster.superminer.objects.ExcavationHelper;
import duelmonster.superminer.objects.Globals;
import duelmonster.superminer.submods.Excavator;
import duelmonster.superminer.submods.Shaftanator;
import duelmonster.superminer.util.BlockPos;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="superminer_veinator", name="Veinator", version="[1.7.10]-2.1.6.214", acceptedMinecraftVersions="[1.7.10]")
public class Veinator {
    public static final String MODID = "superminer_veinator";
    public static final String MODName = "Veinator";
    public static final String ChannelName = "superminer_veinator".substring(0, "superminer_veinator".length() < 20 ? "superminer_veinator".length() : 20);
    @Mod.Instance(value="superminer_veinator")
    private Veinator instance;
    private static boolean bOresGot = false;
    public static Globals myGlobals = new Globals();
    private boolean bHungerNotified = false;
    public static boolean bShouldSyncSettings = true;
    private static List<ExcavationHelper> myExcavationHelpers = new ArrayList<ExcavationHelper>();

    private static List<ExcavationHelper> getMyExcavationHelpers() {
        return new ArrayList<ExcavationHelper>(myExcavationHelpers);
    }

    public static Boolean isExcavating() {
        boolean bIsExcavating = false;
        for (ExcavationHelper oEH : Veinator.getMyExcavationHelpers()) {
            if (bIsExcavating) continue;
            bIsExcavating = oEH != null && oEH.isExcavating();
        }
        return bIsExcavating;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLEventChannel eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelName);
        eventChannel.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static void syncConfig() {
        SettingsVeinator.bEnabled = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.veinator.enabled"), MODID, true, Globals.localize("superminer.veinator.enabled.desc"));
        SettingsVeinator.bGatherDrops = SuperMiner_Core.configFile.getBoolean(Globals.localize("superminer.veinator.gather_drops"), MODID, false, Globals.localize("superminer.veinator.gather_drops"));
        SettingsVeinator.lToolIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.veinator.tool_ids"), MODID, SettingsVeinator.lToolIDDefaults.toArray(new String[0]), Globals.localize("superminer.veinator.tool_ids.desc"))));
        SettingsVeinator.lOreIDs = new ArrayList<String>(Arrays.asList(SuperMiner_Core.configFile.getStringList(Globals.localize("superminer.veinator.ore_ids"), MODID, SettingsVeinator.lOreIDDefaults.toArray(new String[0]), Globals.localize("superminer.veinator.ore_ids.desc"))));
        Veinator.myGlobals.lToolIDs = Globals.IDListToArray(SettingsVeinator.lToolIDs, false);
        Veinator.myGlobals.lBlockIDs = Globals.IDListToArray(SettingsVeinator.lOreIDs, true);
        ArrayList<String> order = new ArrayList<String>(4);
        order.add(Globals.localize("superminer.veinator.enabled"));
        order.add(Globals.localize("superminer.veinator.gather_drops"));
        order.add(Globals.localize("superminer.veinator.tool_ids"));
        order.add(Globals.localize("superminer.veinator.ore_ids"));
        SuperMiner_Core.configFile.setCategoryPropertyOrder(MODID, order);
        if (!bShouldSyncSettings) {
            bShouldSyncSettings = SuperMiner_Core.configFile.hasChanged();
        }
        if (!bOresGot) {
            String[] saOreNames;
            bOresGot = true;
            for (String sOreName : saOreNames = OreDictionary.getOreNames()) {
                if (!sOreName.startsWith("ore")) continue;
                for (ItemStack item : OreDictionary.getOres((String)sOreName)) {
                    String sID;
                    boolean bMCIncluded;
                    if (!(item.func_77973_b() instanceof ItemBlock) || (!(bMCIncluded = (sID = Item.field_150901_e.func_148750_c((Object)item.func_77973_b()).toString().trim()).startsWith("minecraft:")) || SettingsVeinator.lOreIDs.contains(sID.substring(10))) && (bMCIncluded || SettingsVeinator.lOreIDs.contains(sID))) continue;
                    SettingsVeinator.lOreIDs.add(sID);
                    SuperMiner_Core.configFile.get(MODID, Globals.localize("superminer.veinator.ore_ids"), SettingsVeinator.lOreIDDefaults.toArray(new String[0]), Globals.localize("superminer.veinator.ore_ids.desc")).set(SettingsVeinator.lOreIDs.toArray(new String[0]));
                    SuperMiner_Core.configFile.save();
                    try {
                        int id = Integer.parseInt(sID.trim());
                        Veinator.myGlobals.lBlockIDs.add(Block.field_149771_c.func_148754_a(id));
                    }
                    catch (NumberFormatException e) {
                        ResourceLocation rlID = new ResourceLocation(sID);
                        Veinator.myGlobals.lBlockIDs.add(Block.field_149771_c.func_82594_a(rlID.toString()));
                    }
                }
            }
        }
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!message.isStringMessage() || !message.key.equalsIgnoreCase("addPickaxe") || SettingsVeinator.lToolIDs.contains(message.getStringValue())) continue;
            SettingsVeinator.lToolIDs.add(message.getStringValue());
            SuperMiner_Core.configFile.get(MODID, Globals.localize("superminer.veinator.tool_ids"), SettingsVeinator.lToolIDDefaults.toArray(new String[0]), Globals.localize("superminer.veinator.tool_ids.desc")).set(SettingsVeinator.lToolIDs.toArray(new String[0]));
            SuperMiner_Core.configFile.save();
            try {
                int id = Integer.parseInt(message.getStringValue());
                Veinator.myGlobals.lToolIDs.add(Item.field_150901_e.func_148754_a(id));
            }
            catch (NumberFormatException e) {
                Object item = Item.field_150901_e.func_82594_a(message.getStringValue());
                if (item == null) continue;
                Veinator.myGlobals.lToolIDs.add(item);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickEvent(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player;
        if (!PlayerEvents.IsPlayerInWorld() || Excavator.isToggled() || Shaftanator.bToggled || !SettingsVeinator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (!mc.field_71415_G || mc.func_147113_T()) {
            return;
        }
        if (bShouldSyncSettings) {
            Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)SettingsVeinator.writePacketData()));
            bShouldSyncSettings = false;
        }
        if (null == (player = mc.field_71439_g) || player.field_70128_L || player.func_70608_bn()) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (world != null) {
            Block block = null;
            int x = -1;
            int y = -1;
            int z = -1;
            if (player.func_110143_aJ() > 0.0f && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                x = mc.field_71476_x.field_72311_b;
                y = mc.field_71476_x.field_72312_c;
                z = mc.field_71476_x.field_72309_d;
                block = world.func_147439_a(x, y, z);
                if (!Globals.isAttacking(mc) && block != null && block == Blocks.field_150350_a) {
                    block = null;
                }
            }
            if (block != null && Globals.isIdInList(block, Veinator.myGlobals.lBlockIDs)) {
                if (!this.bHungerNotified && player.func_71024_bL().func_75116_a() <= 1) {
                    Globals.NotifyClient(Globals.tooHungry() + MODName);
                    this.bHungerNotified = true;
                    return;
                }
                if (player.func_71024_bL().func_75116_a() > 1) {
                    int metadata = world.func_72805_g(x, y, z);
                    myGlobals.addAttackBlock((EntityPlayer)player, block, metadata, new BlockPos(x, y, z), false, true, true, false);
                }
            } else {
                this.bHungerNotified = false;
            }
            Iterator attackPackets = Veinator.myGlobals.attackHistory.iterator();
            while (attackPackets.hasNext()) {
                SMPacket packet = (SMPacket)attackPackets.next();
                if (System.nanoTime() - packet.nanoTime >= 3000000000L) {
                    attackPackets.remove();
                    continue;
                }
                block = world.func_147439_a(packet.oPos.getX(), packet.oPos.getZ(), packet.oPos.getZ());
                if (block != null && block != Blocks.field_150350_a) continue;
                attackPackets.remove();
                packet.block = packet.prevBlock;
                Globals.sendPacket((Packet)new C17PacketCustomPayload(ChannelName, (ByteBuf)packet.writePacketData()));
            }
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer payLoad = new PacketBuffer(event.packet.payload());
        int iPacketID = payLoad.copy().readInt();
        if (iPacketID == PacketIDs.Settings_Veinator.value()) {
            SettingsVeinator.readPacketData(payLoad);
            Veinator.myGlobals.lToolIDs = Globals.IDListToArray(SettingsVeinator.lToolIDs, false);
            Veinator.myGlobals.lBlockIDs = Globals.IDListToArray(SettingsVeinator.lOreIDs, true);
        } else if (SettingsVeinator.bEnabled && iPacketID == PacketIDs.BLOCKINFO.value()) {
            SMPacket packet = new SMPacket();
            packet.readPacketData(payLoad);
            Veinator.executeVeinator(packet, ((NetHandlerPlayServer)event.handler).field_147369_b);
        }
    }

    protected static void executeVeinator(SMPacket packet, EntityPlayerMP player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (null == server) {
            return;
        }
        WorldServer world = server.func_71218_a(player.field_71093_bK);
        if (!Veinator.isAllowedToMine((EntityPlayer)player, packet)) {
            return;
        }
        ExcavationHelper oEH = new ExcavationHelper((World)world, player, packet);
        myExcavationHelpers.add(oEH);
        oEH.getOreVein();
        if (!oEH.ExcavateSection()) {
            oEH.FinalizeVeination();
            myExcavationHelpers.remove(oEH);
        }
        myGlobals.clearHistory();
    }

    @SubscribeEvent
    public void tickEvent_Server(TickEvent.ServerTickEvent event) {
        if (!SettingsVeinator.bEnabled || !TickEvent.Phase.END.equals((Object)event.phase)) {
            return;
        }
        for (FMLInterModComms.IMCMessage imcMessage : FMLInterModComms.fetchRuntimeMessages((Object)this.instance)) {
            this.processIMC(imcMessage);
        }
        if (myExcavationHelpers.size() > 0) {
            for (ExcavationHelper oEH : Veinator.getMyExcavationHelpers()) {
                if (!oEH.isExcavating() || oEH.ExcavateSection()) continue;
                oEH.FinalizeVeination();
                myExcavationHelpers.remove(oEH);
            }
        }
    }

    private static boolean isAllowedToMine(EntityPlayer player, SMPacket p) {
        Block block = p.block;
        if (null == block || Blocks.field_150350_a == block || Blocks.field_150357_h == block) {
            return false;
        }
        ItemStack oEquippedItem = player.func_71045_bC();
        if (block.func_149688_o().func_76229_l() || oEquippedItem == null || oEquippedItem.field_77994_a <= 0 || !Globals.isIdInList(oEquippedItem.func_77973_b(), Veinator.myGlobals.lToolIDs) || !ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)p.metadata) || !ForgeHooks.canToolHarvestBlock((Block)block, (int)p.metadata, (ItemStack)oEquippedItem)) {
            return false;
        }
        if (p.flag_rs) {
            return Globals.isIdInList(Blocks.field_150450_ax, Veinator.myGlobals.lBlockIDs) || Globals.isIdInList(Blocks.field_150439_ay, Veinator.myGlobals.lBlockIDs);
        }
        return Globals.isIdInList(block, Veinator.myGlobals.lBlockIDs);
    }

    public void processIMC(FMLInterModComms.IMCMessage imcMessage) {
        if (imcMessage.key.equalsIgnoreCase("MineVein") && imcMessage.isNBTMessage()) {
            NBTTagCompound nbt = imcMessage.getNBTValue();
            SMPacket iPacket = new SMPacket();
            iPacket.readPacketData(new PacketBuffer(Unpooled.copiedBuffer((byte[])nbt.func_74770_j("MineVein"))));
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (null == server) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)server.func_130014_f_().func_73045_a(iPacket.playerID);
            if (player == null) {
                return;
            }
            Veinator.executeVeinator(iPacket, player);
        }
    }
}

