/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.movement;

import com.creativemd.cmdcam.movement.Movement;
import com.creativemd.cmdcam.utils.CamPoint;
import com.creativemd.cmdcam.utils.interpolation.CubicInterpolation;
import com.creativemd.cmdcam.utils.interpolation.Vec;
import com.creativemd.cmdcam.utils.interpolation.Vec1;
import com.creativemd.cmdcam.utils.interpolation.Vec3;
import java.util.ArrayList;

public class CubicMovement
extends Movement {
    public CubicInterpolation<Vec1> rollSpline;
    public CubicInterpolation<Vec1> zoomSpline;
    public CubicInterpolation<Vec1> pitchSpline;
    public CubicInterpolation<Vec1> yawSpline;
    public CubicInterpolation<Vec3> positionSpline;

    @Override
    public void initMovement(ArrayList<CamPoint> points) {
        Vec[] rollPoints = new Vec1[points.size()];
        Vec[] zoomPoints = new Vec1[points.size()];
        Vec[] yawPoints = new Vec1[points.size()];
        Vec[] pitchPoints = new Vec1[points.size()];
        Vec[] positionPoints = new Vec3[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            rollPoints[i] = new Vec1(points.get((int)i).roll);
            zoomPoints[i] = new Vec1(points.get((int)i).zoom);
            yawPoints[i] = new Vec1(points.get((int)i).rotationYaw);
            pitchPoints[i] = new Vec1(points.get((int)i).rotationPitch);
            positionPoints[i] = new Vec3(points.get((int)i).x, points.get((int)i).y, points.get((int)i).z);
        }
        this.rollSpline = new CubicInterpolation(rollPoints);
        this.zoomSpline = new CubicInterpolation(zoomPoints);
        this.pitchSpline = new CubicInterpolation(pitchPoints);
        this.yawSpline = new CubicInterpolation(yawPoints);
        this.positionSpline = new CubicInterpolation(positionPoints);
    }

    @Override
    public CamPoint getPointInBetween(CamPoint point1, CamPoint point2, double percent, double wholeProgress) {
        CamPoint point = point1.getPointBetween(point2, percent);
        if (this.rollSpline != null) {
            point.roll = ((Vec1)this.rollSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.zoomSpline != null) {
            point.zoom = ((Vec1)this.zoomSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.yawSpline != null) {
            point.rotationYaw = ((Vec1)this.yawSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.pitchSpline != null) {
            point.rotationPitch = ((Vec1)this.pitchSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.positionSpline != null) {
            Vec3 position = (Vec3)this.positionSpline.valueAt(wholeProgress);
            point.x = position.x;
            point.y = position.y;
            point.z = position.z;
        }
        return point;
    }
}

