/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.utils.interpolation;

import com.creativemd.cmdcam.utils.interpolation.Vec;
import java.util.ArrayList;

public abstract class Interpolation<T extends Vec> {
    public ArrayList<T> points = new ArrayList();
    private final Class classOfT;

    public Interpolation(T ... points) {
        if (points.length < 2) {
            throw new IllegalArgumentException("At least two points are needed!");
        }
        this.classOfT = points[0].getClass();
        for (int i = 0; i < points.length; ++i) {
            this.points.add(points[i]);
        }
    }

    protected double getValue(int index, int dim) {
        return ((Vec)this.points.get(index)).getValueByDim(dim);
    }

    public T valueAt(double t) {
        int pointIndex;
        int pointIndexNext;
        if (t >= 0.0 && t <= 1.0 && (pointIndexNext = (pointIndex = (int)((double)(this.points.size() - 1) * t)) + 1) < this.points.size()) {
            Vec vec = Vec.copyVec((Vec)this.points.get(pointIndex));
            double pointDistance = 1.0 / (double)(this.points.size() - 1);
            double pointPosition = pointDistance * (double)pointIndex;
            double mu = (t - pointPosition) / pointDistance;
            for (int dim = 0; dim < vec.getDimensionCount(); ++dim) {
                vec.setValueByDim(dim, this.valueAt(mu, pointIndex, pointIndexNext, dim));
            }
            return (T)vec;
        }
        return (T)Vec.createEmptyVec(this.classOfT);
    }

    public abstract double valueAt(double var1, int var3, int var4, int var5);
}

