/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.editor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.managers.ServerList;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.swing.editor.ExtendedHTMLEditorKit;
import ru.turikhay.tlauncher.ui.swing.editor.HyperlinkProcessor;

public abstract class ServerHyperlinkProcessor
extends HyperlinkProcessor
implements Blockable {
    private final JPopupMenu popup = new JPopupMenu();
    private boolean blocked;

    @Override
    public void process(String link) {
        if (link != null && link.startsWith("server:")) {
            if (!this.blocked) {
                try {
                    this.openServer(link);
                }
                catch (Exception e) {
                    Alert.showLocError("ad.server.error", new RuntimeException("\"" + link + "\"", e));
                }
            }
            return;
        }
        ExtendedHTMLEditorKit.defaultHyperlinkProcessor.process(link);
    }

    private void openServer(String link) {
        final ServerList.Server server = ServerList.Server.parseFromString(link.substring("server:".length()));
        this.popup.removeAll();
        LocalizableMenuItem openWith = new LocalizableMenuItem("ad.server.openwith", server.getName());
        openWith.setEnabled(false);
        this.popup.add(openWith);
        ArrayList<VersionSyncInfo> list = new ArrayList<VersionSyncInfo>();
        for (final VersionSyncInfo syncInfo : TLauncher.getInstance().getVersionManager().getVersions()) {
            int index = server.getVersions().indexOf(syncInfo.getID());
            if (index == -1) continue;
            list.add(syncInfo);
        }
        for (int i = list.size() - 1; i > -1; --i) {
            VersionSyncInfo syncInfo;
            syncInfo = (VersionSyncInfo)list.get(i);
            JMenuItem item = new JMenuItem(syncInfo.getID());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerHyperlinkProcessor.this.open(syncInfo, server);
                }
            });
            this.popup.add(item);
        }
        LocalizableMenuItem currentVersion = new LocalizableMenuItem("ad.server.openwith.current", server.getName());
        currentVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerHyperlinkProcessor.this.open(null, server);
            }
        });
        this.popup.add(currentVersion);
        this.showPopup(this.popup);
    }

    public abstract void showPopup(JPopupMenu var1);

    public abstract void open(VersionSyncInfo var1, ServerList.Server var2);

    @Override
    public void block(Object reason) {
        this.blocked = true;
    }

    @Override
    public void unblock(Object reason) {
        this.blocked = false;
    }
}

