/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.tlauncher.tlauncher.configuration.SimpleConfiguration;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.U;

public class LangConfiguration
extends SimpleConfiguration {
    private final Locale[] locales;
    private final Properties[] prop;
    private int i;

    public LangConfiguration(Locale[] locales, Locale select, String folder) throws IOException {
        if (locales == null) {
            throw new NullPointerException();
        }
        int size = locales.length;
        this.locales = locales;
        this.prop = new Properties[size];
        for (int i = 0; i < size; ++i) {
            Locale locale = locales[i];
            if (locale == null) {
                throw new NullPointerException("Locale at #" + i + " is NULL!");
            }
            String localeName = locale.toString();
            InputStream stream = this.getClass().getResourceAsStream(folder + localeName);
            if (stream == null) {
                throw new IOException("Cannot find locale file for: " + localeName);
            }
            this.prop[i] = LangConfiguration.loadFromStream(stream);
            if (!localeName.equals("en_US")) continue;
            LangConfiguration.copyProperties(this.prop[i], this.properties, true);
        }
        int defLocale = -1;
        for (int i = 0; i < size; ++i) {
            if (!locales[i].toString().equals("ru_RU")) continue;
            defLocale = i;
            break;
        }
        if (defLocale != -1) {
            for (Object key : this.prop[defLocale].keySet()) {
                for (int i = 0; i < size; ++i) {
                    if (i == defLocale || this.prop[i].containsKey(key) || TLauncher.DEBUG) continue;
                    U.log("Locale", locales[i], "doesn't contain key", key);
                }
            }
            for (int i = 0; i < size; ++i) {
                if (i == defLocale) continue;
                int numberLine = 0;
                for (Object key : this.prop[i].keySet()) {
                    ++numberLine;
                    if (this.prop[defLocale].containsKey(key)) continue;
                    U.log("Locale", locales[i], "contains redundant key line is " + numberLine + ", key is " + key);
                }
            }
        }
        this.setSelected(select);
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public Locale getSelected() {
        return this.locales[this.i];
    }

    public void setSelected(Locale select) {
        if (select == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.locales.length; ++i) {
            if (!this.locales[i].equals(select)) continue;
            this.i = i;
            return;
        }
        throw new IllegalArgumentException("Cannot find Locale:" + select);
    }

    public String nget(String key) {
        if (key == null) {
            return null;
        }
        String value = this.prop[this.i].getProperty(key);
        if (value == null) {
            return this.getDefault(key);
        }
        return value;
    }

    @Override
    public String get(String key) {
        String value = this.nget(key);
        if (value == null) {
            return key;
        }
        return value;
    }

    public String nget(String key, Object ... vars) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        String[] variables = LangConfiguration.checkVariables(vars);
        for (int i = 0; i < variables.length; ++i) {
            value = value.replace("%" + i, variables[i]);
        }
        return value;
    }

    public String get(String key, Object ... vars) {
        String value = this.nget(key, vars);
        if (value == null) {
            return key;
        }
        return value;
    }

    @Override
    public void set(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefault(String key) {
        return super.get(key);
    }

    private static String[] checkVariables(Object[] check) {
        if (check == null) {
            throw new NullPointerException();
        }
        if (check.length == 1 && check[0] == null) {
            return new String[0];
        }
        String[] string = new String[check.length];
        for (int i = 0; i < check.length; ++i) {
            if (check[i] == null) {
                throw new NullPointerException("Variable at index " + i + " is NULL!");
            }
            string[i] = check[i].toString();
        }
        return string;
    }
}

