/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.controller;

import com.google.inject.Inject;
import java.io.IOException;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameVersionDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.share.ForgeStringComparator;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.util.U;

public class ModpackConfig {
    @Inject
    private ModpackManager manager;

    public GameVersionDTO findGameVersion(String currentGameVersion) {
        for (GameVersionDTO dto : this.manager.getInfoMod().getGameVersions()) {
            if (!dto.getName().equalsIgnoreCase(currentGameVersion) || dto.getForgeVersions().size() <= 0) continue;
            dto.getForgeVersions().sort(new ForgeStringComparator());
            return dto;
        }
        return null;
    }

    public void installSkinMod(CompleteVersion version) {
        if (this.manager.getInfoMod().getMods().isEmpty()) {
            Alert.showLocMessage("modpack.internet.update");
            return;
        }
        Long id = this.manager.getSkinId(version.getModpack());
        for (ModDTO m : this.manager.getInfoMod().getMods()) {
            if (!m.getId().equals(id)) continue;
            for (VersionDTO v : m.getVersions()) {
                if (!v.getGameVersions().contains(((ModpackVersionDTO)version.getModpack().getVersion()).getGameVersion())) continue;
                this.manager.installEntity(m, v, GameType.MOD);
                return;
            }
        }
    }

    public void save(CompleteVersion version, String modpackName, boolean optifine, String forge) {
        if (!version.getID().equals(modpackName)) {
            this.manager.renameModpack(version, modpackName);
        } else {
            this.manager.resaveVersion(version);
        }
        if (ModpackUtil.useSkinMod(version) && !optifine) {
            Long id = this.manager.getSkinId(version.getModpack());
            ModDTO m = new ModDTO();
            m.setId(id);
            this.manager.removeEntity(m, m.getVersion(), GameType.MOD, true);
        } else if (!ModpackUtil.useSkinMod(version) && optifine) {
            this.installSkinMod(version);
        }
        if (!((ModpackVersionDTO)version.getModpack().getVersion()).getForgeVersion().equalsIgnoreCase(forge)) {
            try {
                CompleteVersion v = this.manager.getForgeVersion(forge);
                v.setSkinVersion(version.isSkinVersion());
                v.setID(version.getID());
                v.setModpackDTO(version.getModpack());
                ((ModpackVersionDTO)v.getModpack().getVersion()).setForgeVersion(forge);
                this.manager.resaveVersion(v);
            }
            catch (IOException e) {
                U.log(e);
            }
        }
    }

    public void open(CompleteVersion version) {
        this.manager.openModpackFolder(version);
    }

    public void remove(CompleteVersion version) {
        this.manager.removeEntity(version.getModpack(), version.getModpack().getVersion(), GameType.MODPACK, false);
    }
}

