/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.managers;

import com.github.junrar.Archive;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipFile;
import javax.inject.Named;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.Version;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.tlauncher.exceptions.ParseModPackException;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.GameEntityDependencyDTO;
import org.tlauncher.modpack.domain.client.MapDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.ResourcePackDTO;
import org.tlauncher.modpack.domain.client.SubModpackDTO;
import org.tlauncher.modpack.domain.client.share.Category;
import org.tlauncher.modpack.domain.client.share.DependencyType;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.share.InfoMod;
import org.tlauncher.modpack.domain.client.share.StateGameElement;
import org.tlauncher.modpack.domain.client.version.MapMetadataDTO;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.modpack.domain.client.version.ModVersionDTO;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.configuration.InnerConfiguration;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.downloader.mods.ArchiveGameEntityDownloader;
import org.tlauncher.tlauncher.downloader.mods.GameEntityDownloader;
import org.tlauncher.tlauncher.downloader.mods.GameEntityHandler;
import org.tlauncher.tlauncher.downloader.mods.MapDownloader;
import org.tlauncher.tlauncher.downloader.mods.UnzipEntityDownloader;
import org.tlauncher.tlauncher.entity.MinecraftInstance;
import org.tlauncher.tlauncher.exceptions.GameEntityNotFound;
import org.tlauncher.tlauncher.exceptions.SameMapFoldersException;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.managers.VersionManagerListener;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityAdapter;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.modpack.HandleInstallModpackElementFrame;
import org.tlauncher.tlauncher.ui.modpack.ModpackBackupFrame;
import org.tlauncher.tlauncher.ui.modpack.filter.BaseModpackFilter;
import org.tlauncher.tlauncher.ui.modpack.filter.ModpackSceneFilter;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;

@Singleton
public class ModpackManager
implements VersionManagerListener {
    private final Map<GameType, List<GameEntityListener>> gameListeners = Collections.synchronizedMap(new HashMap<GameType, List<GameEntityListener>>(){
        {
            this.put(GameType.MAP, Collections.synchronizedList(new ArrayList()));
            this.put(GameType.MOD, Collections.synchronizedList(new ArrayList()));
            this.put(GameType.MODPACK, Collections.synchronizedList(new ArrayList()));
            this.put(GameType.RESOURCEPACK, Collections.synchronizedList(new ArrayList()));
        }
    });
    private final File STATUS_MODPACK_FILE = FileUtil.getRelativeConfigFile("status.modpack");
    @javax.inject.Inject
    @Named(value="GsonCompleteVersion")
    private Gson gson;
    @Inject
    private TLauncher tLauncher;
    private InnerConfiguration innerConfiguration = TLauncher.getInnerSettings();
    private InfoMod infoMod;
    private Set<Long> statusModpackElement;
    private AtomicBoolean addedVersionListener = new AtomicBoolean(false);

    public ModpackManager() {
        GameEntityAdapter listener = new GameEntityAdapter(){

            @Override
            public void installEntity(CompleteVersion e) {
                this.update();
            }

            private void update() {
                TLauncher.getInstance().getVersionManager().getLocalList().refreshVersions();
            }

            @Override
            public void removeCompleteVersion(CompleteVersion e) {
                this.update();
            }
        };
        this.gameListeners.get((Object)GameType.MODPACK).add(listener);
    }

    public Set<Long> getStatusModpackElement() {
        return this.statusModpackElement;
    }

    private void log(Object ... s) {
        U.log("[Modpack] ", s);
    }

    public synchronized void loadInfo() {
        U.gc();
        List<CompleteVersion> versions = this.getModpackVersions();
        if (this.getInfoMod() == null || this.getInfoMod().getGameVersions().isEmpty()) {
            InfoMod infoMod;
            String lang = this.tLauncher.getConfiguration().getLocale().toString().toUpperCase();
            try {
                String url;
                File cached = MinecraftUtil.getTLauncherFile("cache/modpacks_" + this.tLauncher.getConfiguration().getLocale().getLanguage());
                boolean usedCache = false;
                if (cached.exists()) {
                    url = String.format("%sseparated/%s?lang=%s&version=%s", this.innerConfiguration.get("modpack.url"), "hash", lang, this.innerConfiguration.get("version"));
                    usedCache = Http.performGet(url).equalsIgnoreCase(FileUtil.getChecksum(cached));
                }
                if (!usedCache) {
                    url = String.format("%sseparated/%s?lang=%s&version=%s", this.innerConfiguration.get("modpack.url"), "infomod", lang, this.innerConfiguration.get("version"));
                    DownloadableContainer container = new DownloadableContainer();
                    container.add(new Downloadable(ClientInstanceRepo.EMPTY_REPO, url, cached, true, true));
                    this.tLauncher.getDownloader().add(container);
                    this.tLauncher.getDownloader().startDownloadAndWait();
                }
                infoMod = this.gson.fromJson(FileUtil.readZippedFile(cached, "entities.json"), InfoMod.class);
                infoMod.setMods((List)this.gson.fromJson(FileUtil.readZippedFile(cached, "mods.json"), new TypeToken<List<ModDTO>>(){}.getType()));
            }
            catch (IOException e) {
                U.log(e);
                infoMod = new InfoMod();
            }
            U.debug("loaded data and created data from modpack server");
            this.setInfoMod(infoMod);
            this.processGameElementByStatus();
            this.installedDirectlySkinCapeMod();
        }
        this.tLauncher.getFrame().mp.modpackScene.prepareView(this.getInfoMod(), versions);
        if (!this.addedVersionListener.get()) {
            this.addedVersionListener.set(true);
            this.tLauncher.getVersionManager().addListener(this);
        }
    }

    private void installedDirectlySkinCapeMod() {
        try {
            boolean f = false;
            List<VersionSyncInfo> list = this.tLauncher.getVersionManager().getInstalledVersions();
            for (VersionSyncInfo v : list) {
                ModpackVersionDTO versionDTO;
                CompleteVersion completeVersion = v.getLocalCompleteVersion();
                if (Objects.isNull(completeVersion) && v.getLocal() instanceof CompleteVersion) {
                    completeVersion = (CompleteVersion)v.getLocal();
                }
                if (!Objects.nonNull(completeVersion) || !completeVersion.isModpack() || !completeVersion.isSkinVersion() || !(versionDTO = (ModpackVersionDTO)completeVersion.getModpack().getVersion()).getMods().stream().noneMatch(e -> ModDTO.SKIN_MODS.contains(e.getId()))) continue;
                GameEntityDTO gameEntityDTO = this.findById(ModDTO.TL_SKIN_CAPE_ID, GameType.MOD);
                BaseModpackFilter<VersionDTO> filter = BaseModpackFilter.getBaseModpackStandardFilters(gameEntityDTO, GameType.MOD, completeVersion.getModpack());
                List<? extends VersionDTO> l = ModpackUtil.sortByDate(filter.findAll(gameEntityDTO.getVersions()));
                if (!l.isEmpty()) {
                    GameEntityDTO installEntity = this.readFromServer(ModDTO.class, gameEntityDTO, l.get(0));
                    this.addEntityToModpack(installEntity, completeVersion, GameType.MOD);
                    this.resaveVersion(completeVersion);
                    f = true;
                    U.log("added mod cape and skin for " + completeVersion.getModpack().getName());
                    continue;
                }
                U.log("can't find proper cape and skin for " + completeVersion.getModpack().getName());
            }
            if (f) {
                this.tLauncher.getVersionManager().asyncRefresh();
            }
        }
        catch (Throwable t) {
            U.log("can't install mods", t);
        }
    }

    public DownloadableContainer getContainer(CompleteVersion version, boolean force) {
        this.log("got container");
        DownloadableContainer container = new DownloadableContainer();
        Path versionFolder = ModpackUtil.getPathByVersion(version);
        if (version.getModpack() != null && version.getModpack().getVersion() != null) {
            MetadataDTO metadataDTO;
            Path additionalFile;
            GameEntityDownloader d;
            ModpackVersionDTO versionDTO = (ModpackVersionDTO)version.getModpack().getVersion();
            List<MetadataDTO> list = this.checkResources(versionDTO, force, versionFolder);
            for (MetadataDTO m : list) {
                d = new ArchiveGameEntityDownloader(ClientInstanceRepo.createModpackRepo(), force, m, versionFolder);
                container.add(d);
            }
            list = this.checkCompositeResources(versionDTO, force, versionFolder);
            for (MetadataDTO m : list) {
                d = new MapDownloader(force, m, versionFolder);
                container.add(d);
            }
            if (versionDTO.getAdditionalFile() != null && (Files.notExists(additionalFile = ModpackUtil.getPathByVersion(version, (metadataDTO = versionDTO.getAdditionalFile()).getPath()), new LinkOption[0]) || !FileUtil.getChecksum(additionalFile.toFile()).equals(metadataDTO.getSha1()))) {
                container.add(new UnzipEntityDownloader(force, versionDTO.getAdditionalFile(), versionFolder));
            }
            container.addHandler(new GameEntityHandler());
        }
        return container;
    }

    private List<MetadataDTO> checkResources(ModpackVersionDTO version, boolean force, Path versionFolder) {
        this.log("check resources");
        ArrayList<MetadataDTO> list = new ArrayList<MetadataDTO>();
        for (ModDTO mod : version.getMods()) {
            if (mod.isUserInstall() || mod.getStateGameElement() == StateGameElement.NO_ACTIVE || !this.notExistOrCorrect(versionFolder, mod, force) || this.fillFromCache(GameType.MOD, mod, version, versionFolder)) continue;
            list.add(mod.getVersion().getMetadata());
        }
        for (ResourcePackDTO resourcePack : version.getResourcePacks()) {
            if (resourcePack.isUserInstall() || resourcePack.getStateGameElement() == StateGameElement.NO_ACTIVE || !this.notExistOrCorrect(versionFolder, resourcePack, force) || this.fillFromCache(GameType.RESOURCEPACK, resourcePack, version, versionFolder)) continue;
            list.add(resourcePack.getVersion().getMetadata());
        }
        return list;
    }

    private boolean notExistOrCorrect(Path versionFolder, GameEntityDTO e, boolean hash) {
        Path path = Paths.get(versionFolder.toString(), e.getVersion().getMetadata().getPath());
        if (Files.notExists(path, new LinkOption[0])) {
            return true;
        }
        if (hash) {
            return !FileUtil.getChecksum(path.toFile()).equals(e.getVersion().getMetadata().getSha1());
        }
        return false;
    }

    private List<MetadataDTO> checkCompositeResources(ModpackVersionDTO version, boolean force, Path versionFolder) {
        this.log("check CompositeResources");
        ArrayList<MetadataDTO> list = new ArrayList<MetadataDTO>();
        for (MapDTO map : version.getMaps()) {
            if (map.isUserInstall()) continue;
            list.add(map.getVersion().getMetadata());
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String folder;
            MetadataDTO meta = (MetadataDTO)it.next();
            U.debug(meta);
            if (((MapMetadataDTO)meta).getFolders() == null || ((MapMetadataDTO)meta).getFolders().size() == 0 || !new File(folder = versionFolder.toString() + "/saves/" + ((MapMetadataDTO)meta).getFolders().get(0)).exists()) continue;
            it.remove();
        }
        return list;
    }

    public void backupModPack(List<CompleteVersion> list, File saveFolder, ModpackBackupFrame.HandleListener handleListener) {
        AsyncThread.execute(() -> {
            this.log("backuping modpack");
            File versionFolder = FileUtil.getRelative("versions").toFile();
            ArrayList<File> files = new ArrayList<File>();
            for (CompleteVersion v : list) {
                File version = new File(versionFolder, v.getID());
                files.addAll(this.findCopiedFiles(v, version));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            ArrayList<String> names = new ArrayList<String>();
            for (CompleteVersion v : list) {
                map.put(v.getID() + ".json", this.gson.toJson(v));
                names.add(v.getID());
            }
            try {
                if (saveFolder.exists() && !saveFolder.delete()) {
                    throw new IOException("can't delete old version of the file");
                }
                FileUtil.backupModpacks(map, files, versionFolder.toPath(), saveFolder, names);
                handleListener.operationSuccess();
            }
            catch (IOException e) {
                this.log(e);
                handleListener.processError(e);
            }
        });
    }

    private List<File> findCopiedFiles(CompleteVersion completeVersion, File version) {
        IOFileFilter filter = FileFilterUtils.notFileFilter(FileFilterUtils.or(FileFilterUtils.nameFileFilter("natives"), FileFilterUtils.nameFileFilter(FileUtil.GameEntityFolder.SAVES.toString()), FileFilterUtils.nameFileFilter(FileUtil.GameEntityFolder.MODS.toString()), FileFilterUtils.nameFileFilter(FileUtil.GameEntityFolder.RESOURCEPACKS.toString())));
        IOFileFilter filesFilter = FileFilterUtils.notFileFilter(FileFilterUtils.or(FileFilterUtils.nameFileFilter(completeVersion.getID() + ".jar"), FileFilterUtils.nameFileFilter(completeVersion.getID() + ".jar.bak")));
        List list = (List)FileUtils.listFiles(version, filesFilter, filter);
        if (TLauncher.DEBUG) {
            U.log("filter by IOFileFilter");
            for (File f : list) {
                U.log(f);
            }
        }
        ModpackVersionDTO modpackVersion = (ModpackVersionDTO)completeVersion.getModpack().getVersion();
        for (GameEntityDTO gameEntityDTO : modpackVersion.getMaps()) {
            File map = new File(version, "saves/" + FilenameUtils.getBaseName(gameEntityDTO.getVersion().getMetadata().getPath()));
            if (!map.exists()) continue;
            list.addAll(FileUtils.listFiles(map, TrueFileFilter.INSTANCE, TrueFileFilter.INSTANCE));
        }
        for (GameEntityDTO gameEntityDTO : modpackVersion.getMods()) {
            if (!gameEntityDTO.isUserInstall()) continue;
            this.addToList(version, list, gameEntityDTO);
        }
        for (GameEntityDTO gameEntityDTO : modpackVersion.getResourcePacks()) {
            if (!gameEntityDTO.isUserInstall()) continue;
            this.addToList(version, list, gameEntityDTO);
        }
        if (TLauncher.DEBUG) {
            U.log("backed files");
            for (File file : list) {
                U.log(file);
            }
        }
        return list;
    }

    private void addToList(File version, List<File> list, GameEntityDTO en) {
        list.add(new File(version, en.getVersion().getMetadata().getPath()));
    }

    public void installModPack(File file, ModpackBackupFrame.HandleListener handleListener) {
        AsyncThread.execute(() -> {
            this.log("installModPack");
            File versionFolder = FileUtil.getRelative("versions").toFile();
            try {
                List<String> modpackNames = this.analizeArchiver(file);
                FileUtil.unzipUniversal(file, versionFolder);
                for (String name : modpackNames) {
                    File modPackFolder = new File(versionFolder, name);
                    File fileVersion = new File(modPackFolder, name + ".json");
                    CompleteVersion version = Files.notExists(fileVersion.toPath(), new LinkOption[0]) ? this.parseCurse(versionFolder, name, modPackFolder, fileVersion) : this.gson.fromJson(FileUtil.readFile(fileVersion), CompleteVersion.class);
                    for (GameEntityListener listener : this.gameListeners.get((Object)GameType.MODPACK)) {
                        listener.installEntity(version);
                    }
                }
                handleListener.installedSuccess(modpackNames);
            }
            catch (Exception e) {
                U.log(e);
                handleListener.processError(e);
            }
        });
    }

    private CompleteVersion parseCurse(File versionFolder, String modpackName, File modPackFolder, File version) throws Exception {
        File instance = new File(modPackFolder, "minecraftinstance.json");
        if (Files.exists(instance.toPath(), new LinkOption[0])) {
            MinecraftInstance minecraftInstance;
            File mods = new File(modPackFolder, "mods");
            File resourcepacks = new File(modPackFolder, "resourcepacks");
            File maps = new File(modPackFolder, "saves");
            if (!(Files.exists(mods.toPath(), new LinkOption[0]) || Files.exists(resourcepacks.toPath(), new LinkOption[0]) || Files.exists(maps.toPath(), new LinkOption[0]))) {
                this.log("modpack doesn't exist");
            }
            if ((minecraftInstance = this.gson.fromJson(FileUtil.readFile(instance), MinecraftInstance.class)) == null) {
                throw new Exception("broken config");
            }
            ModpackDTO modPack = new ModpackDTO();
            modPack.setId(-U.n());
            ModpackVersionDTO modpackVersion = new ModpackVersionDTO();
            String[] formats = new String[]{"jar", "zip"};
            CompleteVersion completeVersion = this.gson.fromJson(minecraftInstance.baseModLoader.VersionJson, CompleteVersion.class);
            modpackVersion.setForgeVersion(completeVersion.getID());
            modpackVersion.setGameVersion(minecraftInstance.baseModLoader.MinecraftVersion);
            completeVersion.setID(modpackName);
            modPack.setName(completeVersion.getID());
            modpackVersion.setId(-U.n() - 1L);
            modpackVersion.setName("1.0");
            modpackVersion.setMods(this.createHandleGameEntities(mods, formats, ModDTO.class));
            modpackVersion.setResourcePacks(this.createHandleGameEntities(resourcepacks, formats, ResourcePackDTO.class));
            modpackVersion.setMaps(this.createMapsByFolder(maps));
            modPack.setVersion(modpackVersion);
            completeVersion.setModpackDTO(modPack);
            FileUtil.writeFile(version, this.gson.toJson(completeVersion));
            return completeVersion;
        }
        throw new Exception("dont' find config file");
    }

    private List<MapDTO> createMapsByFolder(File maps) {
        ArrayList<MapDTO> list = new ArrayList<MapDTO>();
        FilenameFilter filter = (dir, name) -> dir.isDirectory();
        for (File file : Objects.requireNonNull(maps.listFiles(filter))) {
            MapDTO map = new MapDTO();
            VersionDTO v = new VersionDTO();
            v.setName("1.0");
            MetadataDTO meta = new MetadataDTO();
            meta.setPath(FileUtil.GameEntityFolder.getPath(GameType.MAP) + "/" + file.getName() + ".zip");
            v.setMetadata(meta);
            map.setUserInstall(true);
            map.setName(file.getName());
            map.setVersion(v);
            list.add(map);
        }
        return list;
    }

    public List<String> analizeArchiver(File file) throws ParseModPackException {
        try {
            String ext = FilenameUtils.getExtension(file.getCanonicalPath());
            List<String> list = new ArrayList<String>();
            switch (ext) {
                case "rar": {
                    list = FileUtil.topFolders(new Archive(file));
                    break;
                }
                case "zip": {
                    list = FileUtil.topFolders(new ZipFile(file));
                }
            }
            if (list.isEmpty()) {
                throw new ParseModPackException("The archive doesn't contain any folders");
            }
            if (!this.checkNameVersion(list)) {
                throw new ParseModPackException("there is a version with same name");
            }
            return list;
        }
        catch (Exception e) {
            throw new ParseModPackException(e);
        }
    }

    public boolean checkNameVersion(List<String> list) {
        for (String s : list) {
            if (!Objects.nonNull(this.tLauncher.getVersionManager().getVersionSyncInfo(s))) continue;
            return false;
        }
        return true;
    }

    private List<? extends GameEntityDTO> createHandleGameEntities(File folder, String[] exts, Class<? extends GameEntityDTO> t) {
        ArrayList<GameEntityDTO> list = new ArrayList<GameEntityDTO>();
        List files = (List)FileUtils.listFiles(folder, exts, true);
        for (File f : files) {
            try {
                GameEntityDTO c = this.createHandleGameEntity(folder, t, f);
                list.add(c);
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.log(e);
            }
        }
        return list;
    }

    private GameEntityDTO createHandleGameEntity(File folder, Class<? extends GameEntityDTO> t, File f) throws InstantiationException, IllegalAccessException {
        GameEntityDTO c = t.newInstance();
        c.setId(-U.n());
        c.setName(FilenameUtils.getBaseName(f.getName()));
        c.setUserInstall(true);
        MetadataDTO meta = FileUtil.createMetadata(f, folder, t);
        meta.setPath(FileUtil.GameEntityFolder.getPath(t, true).concat(meta.getPath()));
        meta.setUrl(FileUtil.GameEntityFolder.getPath(t, true).concat(meta.getUrl()));
        VersionDTO standardVersion = new VersionDTO();
        standardVersion.setId(-U.n());
        standardVersion.setName("1.0");
        standardVersion.setMetadata(meta);
        c.setVersion(standardVersion);
        return c;
    }

    public void createModpack(String name, ModpackDTO modpackDTO, boolean usedSkin) {
        try {
            CompleteVersion completeVersion = this.getForgeVersion(((ModpackVersionDTO)modpackDTO.getVersion()).getForgeVersion());
            completeVersion.setID(name);
            completeVersion.setModpackDTO(modpackDTO);
            this.tLauncher.getVersionManager().getLocalList().saveVersion(completeVersion);
            for (GameEntityListener l : this.gameListeners.get((Object)GameType.MODPACK)) {
                l.installEntity(completeVersion);
                l.installEntity(completeVersion.getModpack(), GameType.MODPACK);
            }
            if (usedSkin) {
                GameEntityDTO entityDTO = this.findById(this.getSkinId(modpackDTO), GameType.MOD);
                this.addSkinMod(modpackDTO, entityDTO);
            }
        }
        catch (IOException e) {
            U.log(e);
        }
    }

    public Long getSkinId(ModpackDTO modpackDTO) {
        GameEntityDTO gameEntityDTO = this.findById(ModDTO.TL_SKIN_CAPE_ID, GameType.MOD);
        BaseModpackFilter<VersionDTO> filter = BaseModpackFilter.getBaseModpackStandardFilters(gameEntityDTO, GameType.MOD, modpackDTO);
        List<? extends VersionDTO> l = ModpackUtil.sortByDate(filter.findAll(gameEntityDTO.getVersions()));
        if (l.isEmpty()) {
            return ModDTO.TL_SKIN_ID;
        }
        return ModDTO.TL_SKIN_CAPE_ID;
    }

    private void addSkinMod(ModpackDTO modpackDTO, GameEntityDTO entityDTO) {
        List<VersionDTO> versionDTOS;
        if (entityDTO != null && !(versionDTOS = ModpackSceneFilter.getBaseModpackStandardFilters(entityDTO, GameType.MOD, modpackDTO).findAll(entityDTO.getVersions())).isEmpty()) {
            this.installEntity(entityDTO, versionDTOS.get(0), GameType.MOD, false);
        }
    }

    private GameEntityDTO findById(Long id, GameType type) {
        for (GameEntityDTO gameEntityDTO : this.getInfoMod().getByType(type)) {
            if (!gameEntityDTO.getId().equals(id)) continue;
            return gameEntityDTO;
        }
        return null;
    }

    void addEntityToModpack(GameEntityDTO gameEntity, CompleteVersion completeVersion, GameType type) throws IOException {
        ModpackDTO modPack = completeVersion.getModpack();
        ModpackVersionDTO modpackVersion = (ModpackVersionDTO)modPack.getVersion();
        if (modpackVersion == null) {
            modpackVersion = new ModpackVersionDTO();
            modpackVersion.setMaps(new ArrayList<MapDTO>());
            modpackVersion.setMods(new ArrayList<ModDTO>());
            modpackVersion.setResourcePacks(new ArrayList<ResourcePackDTO>());
            modPack.setVersion(modpackVersion);
        }
        try {
            GameEntityDTO removedEntity = this.findAndRemoveGameEntity(completeVersion, gameEntity, type);
            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                l.removeEntity(removedEntity);
            }
        }
        catch (GameEntityNotFound gameEntityNotFound) {
            // empty catch block
        }
        switch (type) {
            case MOD: {
                modpackVersion.getMods().add((ModDTO)gameEntity);
                break;
            }
            case RESOURCEPACK: {
                modpackVersion.getResourcePacks().add((ResourcePackDTO)gameEntity);
                break;
            }
            case MAP: {
                modpackVersion.getMaps().add((MapDTO)gameEntity);
                break;
            }
            default: {
                U.log("there is the problem with", gameEntity);
            }
        }
    }

    private boolean checkAddedElement(VersionDTO version, GameType type, GameEntityDTO entity) {
        ModpackVersionDTO v = (ModpackVersionDTO)version;
        if (v != null && type != GameType.MODPACK) {
            for (GameEntityDTO gameEntityDTO : v.getByType(type)) {
                if (!gameEntityDTO.getId().equals(entity.getId())) continue;
                return false;
            }
        }
        return true;
    }

    public void showFullGameEntity(GameEntityDTO entity, GameType type) {
        AsyncThread.execute(() -> {
            ModpackManager modpackManager = this;
            synchronized (modpackManager) {
                try {
                    GameEntityDTO remote = this.findRemoteEntity(entity, type);
                    if (remote == null) {
                        return;
                    }
                    this.fillPicturesAndDescription(type, remote);
                    MainPane mp = this.tLauncher.getFrame().mp;
                    if (type == GameType.MODPACK) {
                        mp.modpackEnitityScene.showModpackEntity(remote);
                    } else {
                        mp.completeSubEntityScene.showFullGameEntity(remote, type);
                    }
                }
                catch (SocketTimeoutException e) {
                    Alert.showLocError("modpack.internet.update");
                }
                catch (IOException e) {
                    U.log(e);
                    Alert.showError("", Localizable.get("modpack.remote.not.found", Localizable.get("modpack.try.later")), null);
                }
            }
        });
    }

    private void fillPicturesAndDescription(GameType type, GameEntityDTO remote) throws IOException {
        if (remote.getPictures() == null) {
            String request = this.innerConfiguration.get("modpack.url") + remote.getClass().getSimpleName().toLowerCase() + "/update/full";
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", remote.getId());
            map.put("lang", this.tLauncher.getConfiguration().getLocale().toString().toUpperCase());
            if (type == GameType.MODPACK) {
                map.put("versionId", remote.getVersions().get(0).getId());
            }
            String result = Http.performGet(request, map, this.innerConfiguration.getInteger("modpack.update.time.connect"), this.innerConfiguration.getInteger("modpack.update.time.connect"));
            GameEntityDTO updated = (GameEntityDTO)this.gson.fromJson(result, remote.getClass());
            remote.setPictures(updated.getPictures());
            remote.setDescription(updated.getDescription());
            remote.setOfficialSite(updated.getOfficialSite());
            if (type == GameType.MODPACK) {
                remote.setVersion(updated.getVersion());
            }
        }
    }

    private GameEntityDTO findRemoteEntity(GameEntityDTO entity, GameType type) {
        for (GameEntityDTO gameEntityDTO : this.infoMod.getByType(type)) {
            if (!gameEntityDTO.getId().equals(entity.getId())) continue;
            return gameEntityDTO;
        }
        return null;
    }

    public void showInnerModpackElement(GameEntityDTO entity, GameEntityDTO parent, GameType type) {
        if ((entity = this.findRemoteEntity(entity, type)) == null) {
            return;
        }
        try {
            this.fillPicturesAndDescription(type, entity);
            this.tLauncher.getFrame().mp.completeSubEntityScene.showModpackElement(entity, type);
        }
        catch (SocketTimeoutException e) {
            Alert.showLocError("modpack.internet.update");
        }
        catch (IOException e) {
            U.log(e);
            Alert.showError("", Localizable.get("modpack.remote.not.found", Localizable.get("modpack.try.later")), null);
        }
    }

    public <T> T readFromServer(Class<T> t, GameEntityDTO e, VersionDTO version) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", e.getId());
        map.put("versionId", version.getId());
        String res = Http.performGet(this.innerConfiguration.get("modpack.url") + t.getSimpleName().toLowerCase(), map, U.getConnectionTimeout(), this.innerConfiguration.getInteger("modpack.update.time.connect"));
        return this.gson.fromJson(res, t);
    }

    public void sendToServer(ModpackServerCommand command, GameEntityDTO entity, GameType type) {
        AsyncThread.execute(() -> {
            try {
                switch (command) {
                    case UPDATE: 
                    case DOWNLOAD: {
                        URL url = new URL(this.innerConfiguration.get("modpack.operation.url") + command.toString().toLowerCase() + "/" + entity.getId());
                        try {
                            Http.performPost(url, String.valueOf(new HashMap()), "application/json");
                            break;
                        }
                        catch (IOException e) {
                            U.log("can't send operation " + (Object)((Object)command));
                        }
                    }
                }
            }
            catch (IOException e) {
                Alert.showMonologError(Localizable.get().get("modpack.error.send.unsuccess"), 0);
                U.log(e);
            }
        });
    }

    @Override
    public void onVersionsRefreshing(VersionManager manager) {
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager manager) {
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        if (!manager.isLocalRefresh()) {
            this.loadInfo();
        }
    }

    private void processGameElementByStatus() {
        this.readStatusGameElement();
        this.setStatusByType(GameType.MAP);
        this.setStatusByType(GameType.MOD);
        this.setStatusByType(GameType.MODPACK);
        this.setStatusByType(GameType.RESOURCEPACK);
    }

    private void setStatusByType(GameType type) {
        for (GameEntityDTO gameEntityDTO : this.infoMod.getByType(type)) {
            if (!this.statusModpackElement.contains(gameEntityDTO.getId())) continue;
            gameEntityDTO.setPopulateStatus(true);
        }
    }

    public void addStatusElement(GameEntityDTO e, GameType type) {
        this.statusModpackElement.add(e.getId());
        this.writeStatusGameElement();
        for (GameEntityListener gameEntityListener : this.gameListeners.get((Object)type)) {
            gameEntityListener.populateStatus(e, type, true);
        }
        for (GameEntityDTO gameEntityDTO : this.infoMod.getByType(type)) {
            if (!gameEntityDTO.getId().equals(e.getId())) continue;
            gameEntityDTO.setPopulateStatus(true);
        }
    }

    public void removeStatusElement(GameEntityDTO e, GameType type) {
        this.statusModpackElement.remove(e.getId());
        this.writeStatusGameElement();
        for (GameEntityListener gameEntityListener : this.gameListeners.get((Object)type)) {
            gameEntityListener.populateStatus(e, type, false);
        }
        for (GameEntityDTO gameEntityDTO : this.infoMod.getByType(type)) {
            if (!gameEntityDTO.getId().equals(e.getId())) continue;
            gameEntityDTO.setPopulateStatus(false);
        }
    }

    private void readStatusGameElement() {
        try {
            if (this.STATUS_MODPACK_FILE.exists()) {
                this.statusModpackElement = (Set)this.gson.fromJson(FileUtil.readFile(this.STATUS_MODPACK_FILE), new TypeToken<HashSet<Long>>(){}.getType());
            } else {
                this.statusModpackElement = new HashSet<Long>();
                this.writeStatusGameElement();
            }
        }
        catch (JsonSyntaxException | IOException e) {
            U.log(e);
            this.statusModpackElement = new HashSet<Long>();
            this.writeStatusGameElement();
        }
    }

    private void writeStatusGameElement() {
        try {
            FileUtil.writeFile(this.STATUS_MODPACK_FILE, this.gson.toJson(this.statusModpackElement));
        }
        catch (IOException e1) {
            U.log(e1);
        }
    }

    public synchronized InfoMod getInfoMod() {
        return this.infoMod;
    }

    private synchronized void setInfoMod(InfoMod infoMod) {
        this.infoMod = infoMod;
    }

    private List<CompleteVersion> getModpackVersions() {
        ArrayList<CompleteVersion> versions = new ArrayList<CompleteVersion>();
        for (Version v : TLauncher.getInstance().getVersionManager().getLocalList().getVersions()) {
            if (!((CompleteVersion)v).isModpack()) continue;
            versions.add((CompleteVersion)v);
        }
        return versions;
    }

    public void changeModpackElementState(GameEntityDTO entity, GameType type) {
        CompleteVersion completeVersion = this.tLauncher.getFrame().mp.modpackScene.getSelectedCompleteVersion();
        ModpackVersionDTO versionDTO = (ModpackVersionDTO)completeVersion.getModpack().getVersion();
        Optional<GameEntityDTO> op = versionDTO.getByType(type).stream().filter(e -> e.getId().equals(entity.getId())).findFirst();
        if (!op.isPresent()) {
            return;
        }
        SubModpackDTO en = (SubModpackDTO)op.get();
        AsyncThread.execute(() -> {
            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                l.activationStarted(en);
            }
            try {
                switch (type) {
                    case MOD: 
                    case RESOURCEPACK: {
                        this.changeActivation(en, type, completeVersion);
                        if (en.getDependencies() == null || en.getStateGameElement() != StateGameElement.ACTIVE) break;
                        for (GameEntityDependencyDTO d : en.getDependencies()) {
                            Optional<GameEntityDTO> optional;
                            if (d.getDependencyType() != DependencyType.REQUIRED || !(optional = versionDTO.getByType(type).stream().filter(e -> e.getId().equals(d.getId())).filter(e -> ((SubModpackDTO)e).getStateGameElement() == StateGameElement.NO_ACTIVE).findFirst()).isPresent()) continue;
                            this.changeActivation((SubModpackDTO)optional.get(), d.getGameType(), completeVersion);
                        }
                        break;
                    }
                    default: {
                        this.log(new Object[]{"strange type of ", type, "for entity ", entity});
                    }
                }
                for (GameEntityListener l : this.gameListeners.get((Object)GameType.MODPACK)) {
                    l.updateVersion(completeVersion, completeVersion);
                }
                this.tLauncher.getVersionManager().getLocalList().refreshLocalVersion(completeVersion);
            }
            catch (Exception e2) {
                this.log(e2);
                for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                    l.activationError(entity, e2);
                }
            }
        });
    }

    private void changeActivation(SubModpackDTO entity, GameType type, CompleteVersion completeVersion) throws IOException {
        File modpackFolder = FileUtil.getRelative("versions/" + completeVersion.getID()).toFile();
        try {
            File target = new File(modpackFolder, entity.getVersion().getMetadata().getPath());
            if (entity.getStateGameElement() == StateGameElement.ACTIVE) {
                Files.move(target.toPath(), Paths.get(target.toString() + ".deactivation", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(Paths.get(target.toString() + ".deactivation", new String[0]), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (NoSuchFileException e) {
            this.log((Object)((Object)entity.getStateGameElement()) + " ", e.getMessage());
        }
        if (entity.getStateGameElement() == StateGameElement.NO_ACTIVE) {
            entity.setStateGameElement(StateGameElement.ACTIVE);
        } else {
            entity.setStateGameElement(StateGameElement.NO_ACTIVE);
        }
        for (GameEntityListener l : this.gameListeners.get((Object)type)) {
            l.activation(entity);
        }
    }

    public synchronized void installEntity(GameEntityDTO e, VersionDTO version, GameType type) {
        if (type != GameType.MODPACK && !this.tLauncher.getFrame().mp.modpackScene.isSelectedCompleteVersion()) {
            Alert.showLocMessage("modpack.select.modpack");
            return;
        }
        for (GameEntityListener l : this.gameListeners.get((Object)type)) {
            l.processingStarted(e, version);
        }
        try {
            GameEntityDTO installEntity;
            CompleteVersion completeVersion;
            if (type == GameType.MODPACK) {
                completeVersion = this.readFromServer(CompleteVersion.class, e, version);
                installEntity = completeVersion.getModpack();
                completeVersion.setID(installEntity.getName() + " " + installEntity.getVersion().getName());
                this.tLauncher.getVersionManager().getLocalList().saveVersion(completeVersion);
                for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                    l.installEntity(completeVersion);
                }
            } else {
                completeVersion = this.tLauncher.getFrame().mp.modpackScene.getSelectedCompleteVersion();
                installEntity = (GameEntityDTO)this.readFromServer(e.getClass(), e, version);
                if (ModDTO.SKIN_MODS.contains(installEntity.getId())) {
                    completeVersion.setSkinVersion(true);
                }
                this.checkMapFolders(completeVersion, installEntity, type);
                this.addDependencies(e, completeVersion);
                this.addEntityToModpack(installEntity, completeVersion, type);
                this.resaveVersion(completeVersion);
            }
            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                l.installEntity(installEntity, type);
            }
            this.sendToServer(ModpackServerCommand.DOWNLOAD, installEntity, type);
        }
        catch (IOException e1) {
            U.log(e1);
            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                l.installError(e, version, e1);
            }
            Alert.showLocMessage("", "modpack.try.later", null);
        }
        catch (SameMapFoldersException e1) {
            Alert.showLocWarning("modpack.map.same.folder");
            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                l.installError(e, version, e1);
            }
        }
    }

    private void checkMapFolders(CompleteVersion completeVersion, GameEntityDTO installEntity, GameType type) throws SameMapFoldersException {
        if (type != GameType.MAP) {
            return;
        }
        List<String> remoteFolders = ((MapMetadataDTO)installEntity.getVersion().getMetadata()).getFolders();
        for (MapDTO mapDTO : ((ModpackVersionDTO)completeVersion.getModpack().getVersion()).getMaps()) {
            List<String> folders = ((MapMetadataDTO)mapDTO.getVersion().getMetadata()).getFolders();
            if (folders == null || remoteFolders == null || Collections.disjoint(folders, remoteFolders)) continue;
            throw new SameMapFoldersException(String.format("maps have same folders local: %s remote: %s", folders.toString(), remoteFolders.toString()));
        }
    }

    public void installEntity(GameEntityDTO e, VersionDTO version, GameType type, boolean async) {
        if (e.getCategories().contains((Object)Category.CHITA) && type == GameType.MOD && !this.tLauncher.getProfileManager().hasPremium()) {
            Alert.showLocMessage("", "account.premium.chita", null);
            return;
        }
        if (async) {
            AsyncThread.execute(() -> this.installEntity(e, version, type));
        } else {
            this.installEntity(e, version, type);
        }
    }

    private void addDependencies(GameEntityDTO e, CompleteVersion version) throws IOException {
        List<GameEntityDependencyDTO> list = e.getDependencies();
        if (list == null || list.size() == 0) {
            return;
        }
        HashMap<GameEntityDTO, GameType> downloadedList = new HashMap<GameEntityDTO, GameType>();
        for (GameEntityDependencyDTO gameEntityDependencyDTO : list) {
            if (gameEntityDependencyDTO.getDependencyType() == DependencyType.INCOMPATIBLE || gameEntityDependencyDTO.getDependencyType() == DependencyType.OPTIONAL || e.getId().equals(gameEntityDependencyDTO.getId())) continue;
            GameEntityDTO dto = new GameEntityDTO();
            dto.setId(gameEntityDependencyDTO.getId());
            dto = this.findRemoteEntity(dto, gameEntityDependencyDTO.getGameType());
            if (Objects.isNull(dto)) {
                this.log("not found proper game entity for " + e.getName() + " " + version.getID());
                continue;
            }
            List<VersionDTO> versions = ModpackSceneFilter.getBaseModpackStandardFilters(dto, gameEntityDependencyDTO.getGameType(), version.getModpack()).findAll(dto.getVersions());
            if (versions.size() == 0) {
                this.log("not found proper game entity for " + e.getName() + " " + version.getID());
                continue;
            }
            if (this.findGameFromCollection(dto, gameEntityDependencyDTO.getGameType(), (ModpackVersionDTO)version.getModpack().getVersion()) != null) {
                this.log("it has already added   " + dto.getName() + " " + dto.getId());
                continue;
            }
            this.addDependencies(dto, version);
            GameEntityDTO install = this.readFromServer(GameType.createDTO(gameEntityDependencyDTO.getGameType()), dto, ModpackUtil.sortByDate(versions).get(0));
            downloadedList.put(install, gameEntityDependencyDTO.getGameType());
        }
        for (Map.Entry entry : downloadedList.entrySet()) {
            this.addEntityToModpack((GameEntityDTO)entry.getKey(), version, (GameType)((Object)entry.getValue()));
            for (GameEntityListener l : this.gameListeners.get(entry.getValue())) {
                l.installEntity((GameEntityDTO)entry.getKey(), (GameType)((Object)entry.getValue()));
            }
        }
    }

    public void installHandleEntity(File[] files, CompleteVersion completeVersion, GameType type, HandleInstallModpackElementFrame.HandleListener handleListener) {
        Path folder = FileUtil.getRelative("versions/" + completeVersion.getID() + "/" + FileUtil.GameEntityFolder.getPath(type));
        folder.toFile().mkdir();
        try {
            ArrayList<GameEntityDTO> list = new ArrayList<GameEntityDTO>();
            for (File f : files) {
                GameEntityDTO entity = this.initHanldeEntity(type, f, folder);
                Path target = Paths.get(folder.toString(), f.getName());
                if (!this.checkAddedElement(completeVersion.getModpack().getVersion(), type, entity)) {
                    throw new ParseModPackException("entity exists" + entity);
                }
                Files.copy(f.toPath(), target, new CopyOption[0]);
                if (type == GameType.MAP) {
                    FileUtil.unzipUniversal(target.toFile(), target.toFile().getParentFile());
                    FileUtil.deleteFile(target.toFile());
                }
                this.addEntityToModpack(entity, completeVersion, type);
                list.add(entity);
            }
            for (GameEntityDTO entity : list) {
                for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                    l.installEntity(entity, type);
                }
            }
            this.resaveVersion(completeVersion);
            handleListener.installedSuccess();
        }
        catch (Exception e) {
            U.log(e);
            handleListener.processError(e);
        }
    }

    private GameEntityDTO initHanldeEntity(GameType type, File f, Path folder) throws ParseModPackException {
        SubModpackDTO entity;
        VersionDTO versionDTO = new VersionDTO();
        switch (type) {
            case MOD: {
                ModDTO modDTO = new ModDTO();
                ModVersionDTO modVersionDTO = new ModVersionDTO();
                modVersionDTO.setIncompatibleMods(new ArrayList<String>());
                modVersionDTO.setIncompatibleMods(new ArrayList<String>());
                versionDTO = modVersionDTO;
                entity = modDTO;
                break;
            }
            case MAP: {
                entity = new MapDTO();
                break;
            }
            case RESOURCEPACK: {
                entity = new ResourcePackDTO();
                break;
            }
            default: {
                throw new ParseModPackException("not proper type");
            }
        }
        entity.setId(-U.n());
        versionDTO.setId(-U.n() - 1L);
        entity.setVersion(versionDTO);
        entity.setStateGameElement(StateGameElement.ACTIVE);
        entity.setName(FilenameUtils.getBaseName(f.getName()));
        entity.setUserInstall(true);
        VersionDTO v = new VersionDTO();
        v.setName("1.0");
        MetadataDTO meta = new MetadataDTO();
        if (type == GameType.MAP) {
            MapMetadataDTO mapMetadata = new MapMetadataDTO();
            mapMetadata.setFolders(this.analizeArchiver(f));
            meta = mapMetadata;
        }
        if (type == GameType.MAP) {
            meta.setPath("saves/" + f.getName());
        } else {
            meta.setPath(type.toString() + "s/" + f.getName());
        }
        v.setMetadata(meta);
        entity.setVersion(v);
        return entity;
    }

    public synchronized void removeEntity(GameEntityDTO entity, VersionDTO versionDTO, GameType type) {
        for (GameEntityListener l : this.gameListeners.get((Object)type)) {
            l.processingStarted(entity, versionDTO);
        }
        try {
            GameEntityDTO removedEntity = entity;
            switch (type) {
                case MODPACK: {
                    CompleteVersion version = this.tLauncher.getFrame().mp.modpackScene.getCompleteVersion((ModpackDTO)entity, versionDTO);
                    this.tLauncher.getVersionManager().getLocalList().deleteVersion(version.getID(), false);
                    for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                        l.removeCompleteVersion(version);
                    }
                    this.tLauncher.getVersionManager().getLocalList().refreshVersions();
                    removedEntity = version.getModpack();
                    break;
                }
                case MOD: 
                case RESOURCEPACK: 
                case MAP: {
                    removedEntity = this.findAndRemoveGameEntity(this.tLauncher.getFrame().mp.modpackScene.getSelectedCompleteVersion(), entity, type);
                }
            }
            for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                l.removeEntity(removedEntity);
            }
        }
        catch (Throwable e) {
            U.log(e);
            SwingUtilities.invokeLater(() -> {
                for (GameEntityListener l : this.gameListeners.get((Object)type)) {
                    l.installError(entity, versionDTO, e);
                }
            });
        }
    }

    public void removeEntity(GameEntityDTO entity, VersionDTO versionDTO, GameType type, boolean sync) {
        if (sync) {
            this.removeEntity(entity, versionDTO, type);
        } else {
            AsyncThread.execute(() -> this.removeEntity(entity, versionDTO, type));
        }
    }

    private GameEntityDTO findAndRemoveGameEntity(CompleteVersion selected, GameEntityDTO entity, GameType type) throws IOException, GameEntityNotFound {
        ModpackVersionDTO versionDTO = (ModpackVersionDTO)selected.getModpack().getVersion();
        GameEntityDTO current = this.findGameFromCollection(entity, type, versionDTO);
        if (current != null) {
            MetadataDTO meta = current.getVersion().getMetadata();
            File removedFile = null;
            switch (type) {
                case MOD: 
                case RESOURCEPACK: {
                    removedFile = FileUtil.getRelative("versions/" + selected.getID() + "/" + meta.getPath()).toFile();
                    break;
                }
                case MAP: {
                    removedFile = FileUtil.getRelative("versions/" + selected.getID() + FilenameUtils.removeExtension(meta.getPath())).toFile();
                }
            }
            FileUtil.deleteFile(removedFile);
            versionDTO.getByType(type).remove(current);
            if (ModDTO.SKIN_MODS.contains(current.getId())) {
                selected.setSkinVersion(false);
            }
            this.tLauncher.getVersionManager().getLocalList().refreshLocalVersion(selected);
            return current;
        }
        throw new GameEntityNotFound("can't find in complete version: " + selected.getID() + " gameEntity: " + entity.getName());
    }

    private GameEntityDTO findGameFromCollection(GameEntityDTO entity, GameType type, ModpackVersionDTO versionDTO) {
        for (GameEntityDTO gameEntityDTO : versionDTO.getByType(type)) {
            if (!entity.getId().equals(gameEntityDTO.getId())) continue;
            return gameEntityDTO;
        }
        return null;
    }

    public void addGameListener(GameType type, GameEntityListener listener) {
        this.gameListeners.get((Object)type).add(listener);
    }

    public void removeGameListener(GameType type, GameEntityListener listener) {
        this.gameListeners.get((Object)type).remove(listener);
    }

    public void renameModpack(CompleteVersion version, String newName) {
        try {
            String oldName = version.getID();
            CompleteVersion newVersion = this.tLauncher.getVersionManager().getLocalList().renameVersion(version, newName);
            this.tLauncher.getVersionManager().getLocalList().refreshVersions();
            for (GameEntityListener l : this.gameListeners.get((Object)GameType.MODPACK)) {
                l.updateVersion(version, newVersion);
            }
            version.setID(newName);
        }
        catch (IOException e) {
            U.log(e);
            Alert.showError(Localizable.get("modpack.rename.exception.title"), Localizable.get("modpack.rename.exception"));
        }
    }

    public void resaveVersion(CompleteVersion completeVersion) {
        try {
            TLauncher.getInstance().getVersionManager().getLocalList().refreshLocalVersion(completeVersion);
            for (GameEntityListener l : this.gameListeners.get((Object)GameType.MODPACK)) {
                l.updateVersion(completeVersion, completeVersion);
            }
        }
        catch (IOException e) {
            U.log(e);
            Alert.showError(Localizable.get("modpack.resave.exception.title"), Localizable.get("modpack.resave.exception"));
        }
    }

    public void checkFolderSubGameEntity(CompleteVersion selectedValue, GameType current) {
        boolean find;
        ModpackVersionDTO versionDTO = (ModpackVersionDTO)selectedValue.getModpack().getVersion();
        Path subFolder = ModpackUtil.getPathByVersion(selectedValue, FileUtil.GameEntityFolder.getPath(current));
        if (Files.notExists(subFolder, new LinkOption[0])) {
            return;
        }
        switch (current) {
            case MOD: {
                find = this.isFind(FileUtils.listFiles(subFolder.toFile(), new String[]{"jar", "zip"}, true), current, versionDTO, subFolder);
                break;
            }
            case RESOURCEPACK: {
                find = this.isFind(FileUtils.listFiles(subFolder.toFile(), new String[]{"zip"}, true), current, versionDTO, subFolder);
                break;
            }
            case MAP: {
                find = this.isFindMap(current, versionDTO, subFolder);
                break;
            }
            default: {
                return;
            }
        }
        if (find) {
            this.resaveVersion(selectedValue);
        }
    }

    private boolean isFindMap(GameType current, ModpackVersionDTO versionDTO, Path subFolder) {
        boolean find = false;
        HashSet<String> set = new HashSet<String>();
        for (GameEntityDTO gameEntityDTO : versionDTO.getByType(current)) {
            if (((MapMetadataDTO)gameEntityDTO.getVersion().getMetadata()).getFolders() == null) continue;
            set.addAll(((MapMetadataDTO)gameEntityDTO.getVersion().getMetadata()).getFolders());
        }
        String[] array = subFolder.toFile().list(DirectoryFileFilter.DIRECTORY);
        for (String m : Objects.requireNonNull(array)) {
            if (set.contains(m)) continue;
            try {
                GameEntityDTO dto = this.createHandleGameEntity(subFolder.toFile(), MapDTO.class, new File(subFolder.toFile(), m));
                versionDTO.getByType(current).add(dto);
            }
            catch (IllegalAccessException | InstantiationException e) {
                U.log(new Object[0]);
            }
            find = true;
        }
        return find;
    }

    private boolean isFind(Collection<File> list, GameType current, ModpackVersionDTO versionDTO, Path subFolder) {
        boolean find = false;
        for (File f : list) {
            boolean foundFile = false;
            String name = f.getName();
            for (GameEntityDTO gameEntityDTO : versionDTO.getByType(current)) {
                if (!gameEntityDTO.getVersion().getMetadata().getPath().endsWith(name)) continue;
                foundFile = true;
                break;
            }
            if (foundFile) continue;
            try {
                GameEntityDTO dto = this.createHandleGameEntity(subFolder.toFile(), GameType.createDTO(current), f);
                versionDTO.getByType(current).add(dto);
                find = true;
            }
            catch (Exception e) {
                this.log(e);
            }
        }
        return find;
    }

    public void openModpackFolder(CompleteVersion version) {
        OS.openFolder(FileUtil.getRelative("versions/" + version.getID()).toFile());
    }

    public CompleteVersion getForgeVersion(String name) throws IOException {
        return this.gson.fromJson(Http.performGet(this.innerConfiguration.get("modpack.url") + "forgeversion?name=" + name), CompleteVersion.class);
    }

    private boolean fillFromCache(GameType t, GameEntityDTO e, ModpackVersionDTO versionDTO, Path versionFolder) {
        for (CompleteVersion v : this.getModpackVersions()) {
            if (v.getModpack().getVersion() == versionDTO) continue;
            for (GameEntityDTO gameEntityDTO : ((ModpackVersionDTO)v.getModpack().getVersion()).getByType(t)) {
                Path cachedFolder;
                if (((SubModpackDTO)gameEntityDTO).getStateGameElement() == StateGameElement.NO_ACTIVE || gameEntityDTO.isUserInstall() || e.isUserInstall() || !e.getId().equals(gameEntityDTO.getId()) || !e.getVersion().getId().equals(gameEntityDTO.getVersion().getId()) || this.notExistOrCorrect(cachedFolder = ModpackUtil.getPathByVersion(v), e, true)) continue;
                File dest = new File(versionFolder.toFile(), e.getVersion().getMetadata().getPath());
                try {
                    FileUtil.copyFile(new File(cachedFolder.toFile(), e.getVersion().getMetadata().getPath()), dest, true);
                    return true;
                }
                catch (IOException e1) {
                    this.log(e1);
                    if (dest.exists()) {
                        FileUtil.deleteFile(dest);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public List<GameEntityDTO> findDependenciesFromGameEntityDTO(GameEntityDTO entityDTO) {
        ArrayList<GameEntityDTO> list = new ArrayList<GameEntityDTO>();
        CompleteVersion completeVersion = this.tLauncher.getFrame().mp.modpackScene.getSelectedCompleteVersion();
        if (completeVersion != null && !entityDTO.isUserInstall() && ((SubModpackDTO)entityDTO).getStateGameElement() != StateGameElement.NO_ACTIVE) {
            for (GameType t : GameType.values()) {
                for (GameEntityDTO gameEntityDTO : ((ModpackVersionDTO)completeVersion.getModpack().getVersion()).getByType(t)) {
                    if (gameEntityDTO.getDependencies() == null || ((SubModpackDTO)gameEntityDTO).getStateGameElement() == StateGameElement.NO_ACTIVE) continue;
                    for (GameEntityDependencyDTO d : gameEntityDTO.getDependencies()) {
                        if (d.getDependencyType() != DependencyType.REQUIRED || !d.getId().equals(entityDTO.getId())) continue;
                        list.add(gameEntityDTO);
                    }
                }
            }
        }
        return list;
    }

    public void resetInfoMod() {
        this.infoMod = null;
    }

    public static enum ModpackServerCommand {
        UPDATE,
        DOWNLOAD,
        ADD_NEW_GAME_ENTITY;

    }
}

