/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.managers.popup.menu;

import ch.jamiete.mcping.MinecraftPing;
import ch.jamiete.mcping.MinecraftPingOptions;
import ch.jamiete.mcping.MinecraftPingReply;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.launcher.updater.VersionFilter;
import net.minecraft.launcher.updater.VersionSyncInfo;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.ReleaseType;
import org.apache.commons.lang3.time.DateUtils;
import org.tlauncher.tlauncher.entity.ServerInfo;
import org.tlauncher.tlauncher.entity.hot.AdditionalHotServer;
import org.tlauncher.tlauncher.entity.hot.AdditionalHotServers;
import org.tlauncher.tlauncher.entity.server.RemoteServer;
import org.tlauncher.tlauncher.entity.server.Server;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.managers.VersionManagerAdapter;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftListener;
import org.tlauncher.tlauncher.minecraft.launcher.server.InnerMinecraftServer;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.menu.PopupMenuModel;
import org.tlauncher.tlauncher.ui.menu.PopupMenuView;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;
import org.tlauncher.util.gson.DownloadUtil;
import org.tlauncher.util.statistics.StatisticsUtil;

@Singleton
public class HotServerManager
extends VersionManagerAdapter
implements MinecraftListener {
    private Map<String, PopupMenuModel> hashMap = Collections.synchronizedMap(new HashMap());
    private boolean serviceAvailable = true;
    private PopupMenuModel current;
    private VersionFilter filter = new VersionFilter().exclude(ReleaseType.SNAPSHOT);
    private AdditionalHotServers additionalHotServers;
    private List<ServerInfo> hotServers;
    @Inject
    private InnerMinecraftServer innerMinecraftServer;
    @Inject
    private TLauncher tLauncher;

    public void processingEvent(String serverId) {
        if (this.serviceAvailable) {
            this.current = this.hashMap.get(serverId);
            if (this.current != null) {
                PopupMenuView view = this.current.isMainPage() ? TLauncher.getInstance().getFrame().mp.defaultScene.getPopupMenuView() : TLauncher.getInstance().getFrame().mp.additionalHostServerScene.getPopupMenuView();
                view.showSelectedModel(this.current);
            } else {
                U.log("server id hasn't found = " + serverId);
            }
        }
    }

    public void launchGame(VersionSyncInfo name) {
        this.changeVersion(name);
        this.block();
        TLauncher.getInstance().getFrame().mp.openDefaultScene();
        RemoteServer s = new RemoteServer();
        if (this.current.getInfo() instanceof ServerInfo) {
            try {
                this.getMinecraftPingReplyAndResolvedAddress(this.current.getInfo());
            }
            catch (Throwable e) {
                U.log(e);
            }
        }
        s.setAddress(this.current.getResolvedAddress());
        s.setName(this.current.getName());
        this.sendStat();
        this.addServerToList(false, name);
        TLauncher.getInstance().getFrame().mp.defaultScene.loginForm.startLauncher(s);
    }

    private void sendStat() {
        String type = this.current.isMainPage() ? "main/page" : "additional";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("version", this.current.getServerId());
        StatisticsUtil.startSending("save/hot/server/" + type, null, map);
    }

    public void copyAddress() {
        StringSelection selection = new StringSelection(this.current.getAddress());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
        Alert.showMessage("", Localizable.get().get("menu.copy.done"));
    }

    private void changeVersion(VersionSyncInfo version) {
        this.current.setSelected(version);
        this.tLauncher.getFrame().mp.defaultScene.loginForm.versions.setSelectedValue(version);
    }

    public void addServerToList(boolean showMessage, VersionSyncInfo v) {
        this.innerMinecraftServer.initInnerServers();
        Server server = new Server();
        server.setAddress(this.current.getAddress());
        server.setName(server.getIp());
        try {
            if (v.isInstalled() && ((CompleteVersion)v.getLocal()).isModpack()) {
                this.innerMinecraftServer.addPageServerToModpack(server, v.getLocal());
            } else {
                this.innerMinecraftServer.addPageServer(server);
            }
        }
        catch (Throwable e) {
            U.log(e);
        }
        if (showMessage) {
            Alert.showMessage("", Localizable.get().get("menu.favorite.done"));
        }
    }

    @Override
    public void onMinecraftPrepare() {
        this.block();
    }

    @Override
    public void onMinecraftAbort() {
        this.enablePopup();
    }

    @Override
    public void onMinecraftLaunch() {
        this.block();
        try {
            if (!this.tLauncher.getLauncher().getVersion().isModpack()) {
                this.innerMinecraftServer.initInnerServers();
                this.innerMinecraftServer.searchRemovedServers();
                this.innerMinecraftServer.prepareInnerServer();
            }
        }
        catch (Throwable e) {
            U.log(e);
        }
    }

    @Override
    public void onMinecraftClose() {
        this.enablePopup();
    }

    @Override
    public void onMinecraftError(Throwable e) {
        this.enablePopup();
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        this.enablePopup();
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
        this.enablePopup();
    }

    public void enablePopup() {
        this.serviceAvailable = true;
    }

    private void block() {
        this.serviceAvailable = false;
    }

    private void addServers(List<? extends ServerInfo> list, boolean mainPage, List<VersionSyncInfo> versions) {
        for (ServerInfo serverInfo : list) {
            if (this.hashMap.get(serverInfo.getServerId()) != null) {
                U.log("!!!the same id was found: " + serverInfo.getServerId());
                continue;
            }
            PopupMenuModel p = new PopupMenuModel(this.findAvailableVersions(serverInfo, versions), serverInfo, mainPage);
            this.hashMap.put(serverInfo.getServerId(), p);
        }
    }

    private List<VersionSyncInfo> findAvailableVersions(ServerInfo serverInfo, List<VersionSyncInfo> versionList) {
        ArrayList<VersionSyncInfo> list = new ArrayList<VersionSyncInfo>();
        for (VersionSyncInfo v2 : versionList) {
            if (!this.filter.satisfies(v2.getAvailableVersion()) || serverInfo.getIgnoreVersions().contains(v2.getID())) continue;
            list.add(v2);
            if (!Objects.equals(serverInfo.getMinVersion(), v2.getID())) continue;
            break;
        }
        versionList.stream().filter(v -> this.filter.satisfies(v.getAvailableVersion())).filter(v -> serverInfo.getIncludeVersions().contains(v.getID())).forEach(list::add);
        return list;
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        List<VersionSyncInfo> list = manager.getVersions();
        this.hashMap.clear();
        AsyncThread.execute(() -> {
            try {
                if (Objects.isNull(this.additionalHotServers)) {
                    AdditionalHotServers servers = DownloadUtil.loadByRepository(ClientInstanceRepo.ADD_HOT_SERVERS_REPO, AdditionalHotServers.class);
                    servers.setList(servers.getList().stream().filter(AdditionalHotServer::isActive).collect(Collectors.toList()));
                    if (servers.isShuffle()) {
                        Collections.shuffle(servers.getList());
                    }
                    this.additionalHotServers = servers;
                }
                this.addServers(this.additionalHotServers.getList(), false, list);
            }
            catch (Throwable e) {
                U.log("can't load additional servers", e);
            }
        });
        AsyncThread.execute(() -> {
            try {
                if (Objects.isNull(this.hotServers)) {
                    this.hotServers = (List)DownloadUtil.loadByRepository(ClientInstanceRepo.HOT_SERVERS_REPO, new TypeToken<List<ServerInfo>>(){}.getType());
                }
                this.addServers(this.hotServers, true, list);
            }
            catch (Throwable e) {
                U.log("can't load hot servers", e);
            }
        });
    }

    public AdditionalHotServers getAdditionalHotServers() {
        return this.additionalHotServers;
    }

    public boolean isReady() {
        return Objects.nonNull(this.additionalHotServers);
    }

    public void fillServer(AdditionalHotServer s) {
        try {
            MinecraftPingReply data = this.getMinecraftPingReplyAndResolvedAddress(s);
            s.setOnline(data.getPlayers().getOnline());
            s.setMax(data.getPlayers().getMax());
            s.setUpdated(DateUtils.addMinutes((Date)new Date(), (int)15));
            s.setImage(data.getFavicon());
        }
        catch (Throwable t) {
            U.log(t);
        }
    }

    private MinecraftPingReply getMinecraftPingReplyAndResolvedAddress(ServerInfo s) throws IOException {
        MinecraftPingReply data;
        String[] serverConfig = s.getAddress().split(":");
        MinecraftPing p = new MinecraftPing();
        MinecraftPingOptions options = new MinecraftPingOptions().setHostname(serverConfig[0]).setPort(Integer.valueOf(serverConfig[1]));
        try {
            data = p.getPing(options);
        }
        catch (Throwable t) {
            p.resolveDNS(options);
            s.setRedirectAddress(String.format("%s:%s", options.getHostname(), options.getPort()));
            data = p.getPing(options);
        }
        return data;
    }
}

