/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.auth;

import java.util.UUID;
import org.tlauncher.tlauncher.exceptions.auth.AuthenticatorException;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.auth.AuthenticatorListener;
import org.tlauncher.tlauncher.minecraft.auth.MojangAuthenticator;
import org.tlauncher.tlauncher.minecraft.auth.TlauncherAuthenticator;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;

public abstract class Authenticator {
    protected final Account account;
    private final String logPrefix = '[' + this.getClass().getSimpleName() + ']';

    public final Account getAccount() {
        return this.account;
    }

    public boolean pass(AuthenticatorListener l) {
        if (l != null) {
            l.onAuthPassing(this);
        }
        try {
            this.pass();
        }
        catch (Exception e) {
            this.log("Cannot authenticate:", e);
            if (l != null) {
                l.onAuthPassingError(this, e);
            }
            return false;
        }
        if (l != null) {
            l.onAuthPassed(this);
        }
        return true;
    }

    Authenticator(Account account) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        this.account = account;
    }

    public static Authenticator instanceFor(Account account) {
        if (account == null) {
            throw new NullPointerException("account");
        }
        U.log("instancefor:", account);
        switch (account.getType()) {
            case TLAUNCHER: {
                return new TlauncherAuthenticator(account);
            }
            case MOJANG: {
                return new MojangAuthenticator(account, TLauncher.getInnerSettings().get("authserver.mojang"));
            }
        }
        throw new IllegalArgumentException("illegal account type");
    }

    public static UUID getClientToken() {
        return TLauncher.getInstance().getProfileManager().getClientToken();
    }

    protected abstract void pass() throws AuthenticatorException;

    protected void log(Object ... o) {
        U.log(this.logPrefix, o);
    }

    public void asyncPass(AuthenticatorListener l) {
        AsyncThread.execute(() -> this.pass(l));
    }

    protected static void setClientToken(String uuid) {
        TLauncher.getInstance().getProfileManager().setClientToken(uuid);
    }
}

