/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.launcher.assitent;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.downloader.RetryDownloadException;
import org.tlauncher.tlauncher.downloader.mods.ArchiveGameEntityDownloader;
import org.tlauncher.tlauncher.downloader.mods.GameEntityDownloader;
import org.tlauncher.tlauncher.downloader.mods.GameEntityHandler;
import org.tlauncher.tlauncher.entity.AdditionalAsset;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftLauncher;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.MinecraftLauncherAssistantWrapper;
import org.tlauncher.tlauncher.repository.ClientInstanceRepo;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.U;

public class SoundAssist
extends MinecraftLauncherAssistantWrapper {
    @Inject
    public SoundAssist(@Assisted MinecraftLauncher launcher) {
        super(launcher);
    }

    @Override
    public void collectResources(Downloader d, boolean force) throws MinecraftException {
        List<AdditionalAsset> assets = TLauncher.getInstance().getAdditionalAssetsComponent().getAdditionalAssets();
        DownloadableContainer c = new DownloadableContainer();
        try {
            for (AdditionalAsset r : assets) {
                if (!r.getVersions().contains(this.launcher.getVersion().getJar()) && !r.getVersions().contains(this.launcher.getVersionName())) continue;
                for (MetadataDTO m : r.getFiles()) {
                    if (!this.notExistsOrCorrect(m) || this.copyFromLocalRepo(m)) continue;
                    c.add(new ArchiveGameEntityDownloader(ClientInstanceRepo.EXTRA_VERSION_REPO, true, m, MinecraftUtil.getTLauncherFile("repo").toPath()));
                }
            }
        }
        catch (IOException e) {
            throw new MinecraftException(e.getMessage(), "download-jar", e);
        }
        if (!c.getList().isEmpty()) {
            c.addHandler(new GameEntityHandler(){

                @Override
                public void onComplete(DownloadableContainer c, Downloadable d) throws RetryDownloadException {
                    super.onComplete(c, d);
                    GameEntityDownloader g = (GameEntityDownloader)d;
                    try {
                        SoundAssist.this.copyFromLocalRepo(g.getMetadata());
                    }
                    catch (IOException e) {
                        U.log(e);
                        throw new RetryDownloadException("problem with sound", e);
                    }
                }
            });
            d.add(c);
        }
    }

    private boolean notExistsOrCorrect(MetadataDTO m) {
        File f = new File(this.launcher.getRunningMinecraftDir(), m.getPath());
        if (!f.exists()) {
            return true;
        }
        return !m.getSha1().equalsIgnoreCase(FileUtil.getChecksum(f));
    }

    private boolean copyFromLocalRepo(MetadataDTO m) throws IOException {
        File source = MinecraftUtil.getTLauncherFile("repo/" + m.getPath());
        File target = new File(this.launcher.getRunningMinecraftDir(), m.getPath());
        if (m.getSha1().equalsIgnoreCase(FileUtil.getChecksum(source))) {
            FileUtil.copyFile(source, target, true);
            return true;
        }
        return false;
    }
}

