/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.rmo;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessLauncher;
import net.minecraft.launcher.process.JavaProcessListener;
import org.apache.log4j.LogManager;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.configuration.LangConfiguration;
import org.tlauncher.tlauncher.configuration.SimpleConfiguration;
import org.tlauncher.tlauncher.configuration.enums.ConnectionQuality;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.updater.bootstrapper.PreparedEnvironmentComponent;
import org.tlauncher.tlauncher.updater.bootstrapper.PreparedEnvironmentComponentImpl;
import org.tlauncher.tlauncher.updater.bootstrapper.model.DownloadedBootInfo;
import org.tlauncher.tlauncher.updater.bootstrapper.model.JavaConfig;
import org.tlauncher.tlauncher.updater.bootstrapper.model.LibraryConfig;
import org.tlauncher.tlauncher.updater.bootstrapper.view.DownloadingFrameElement;
import org.tlauncher.util.DoubleRunningTimer;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.Reflect;
import org.tlauncher.util.StringUtil;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.U;

public final class Bootstrapper {
    private static final String linkUpdateErrorRu = "https://tlauncher.org/ru/error-kb4515384.html";
    private static final String linkUpdateErrorEn = "https://tlauncher.org/en/error-kb4515384.html";
    public static final File directory = new File(".");
    public static SimpleConfiguration innerConfig;
    public static LangConfiguration langConfiguration;
    private static SimpleConfiguration launcherConfig;
    private static JavaConfig javaConfig;
    private static LibraryConfig libraryConfig;
    private final BootstrapperListener listener;
    private JavaProcessLauncher processLauncher;
    private DoubleRunningTimer doubleRunningTimer;
    private JavaProcess process;
    private boolean started;
    private String[] args;
    private PreparedEnvironmentComponent preparedEnvironmentComponent;
    private File jvmFolder;
    public static final String PROTECTION = "protection.txt";
    private FileLock lock;
    private static int i;

    public Bootstrapper(String[] args) {
        this.args = args;
        this.doubleRunningTimer = new DoubleRunningTimer();
        this.doubleRunningTimer.startProtection();
        this.listener = new BootstrapperListener();
    }

    public static void main(String[] args) {
        File jvmFolder = null;
        try {
            System.setProperty("java.net.preferIPv4Stack", "true");
            Bootstrapper.initConfig();
            U.initializeLoggerU(launcherConfig.get("minecraft.gamedir"), "boot", launcherConfig.getInteger("log.file.counter", 0));
            U.log("");
            U.log("-------------------------------------------------------------------");
            Class.forName("org.apache.log4j.helpers.NullEnumeration");
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ExceptionInInitializerError error) {
                if (error.getCause() instanceof IllegalArgumentException && error.getCause().getMessage().contains("Text-specific LCD")) {
                    String link = "https://tlauncher.org/ru/font-error.html";
                    boolean ussr = launcherConfig.isUSSRLocale();
                    if (!ussr) {
                        link = "https://tlauncher.org/en/font-error.html";
                    }
                    OS.openLink(link);
                    System.exit(-1);
                }
            }
            catch (Throwable ex) {
                U.log(ex);
            }
            if (TlauncherUtil.isDoubleRunning() && Bootstrapper.showQuestion(langConfiguration.get("double.running.title"), langConfiguration.get("double.running"), langConfiguration.get("yes"), langConfiguration.get("no")) != 0) {
                return;
            }
            if (!Bootstrapper.checkFreeSpace(FileUtil.SIZE_200)) {
                Bootstrapper.showDiskProblem();
            }
            Bootstrapper.validateWorkDir();
            Bootstrapper.validateTempDir();
            Bootstrapper.valitdateKB4515384();
            boolean properJRE = false;
            if (launcherConfig.getBoolean("not.work.jfxwebkit.dll") || launcherConfig.getBoolean("fixed.gpu.jre.error")) {
                properJRE = true;
            }
            File jvm = Bootstrapper.getJVM(properJRE);
            jvmFolder = jvm.getParentFile();
            Bootstrapper bootstrapper = new Bootstrapper(args);
            bootstrapper.activeDoublePreparingJVM();
            Downloader downloader = new Downloader(ConnectionQuality.NORMAL);
            DownloadingFrameElement downloadingBarElement = new DownloadingFrameElement(langConfiguration.get("updater.frame.name"));
            PreparedEnvironmentComponentImpl prepareLauncher = new PreparedEnvironmentComponentImpl(libraryConfig, javaConfig, Bootstrapper.getWorkFolder(), jvmFolder, downloader, properJRE);
            downloader.addListener(downloadingBarElement);
            DownloadedBootInfo info = prepareLauncher.validateLibraryAndJava();
            prepareLauncher.preparedLibrariesAndJava(info);
            bootstrapper.setPreparedEnvironmentComponent(prepareLauncher);
            bootstrapper.setJVMFolder(jvm);
            bootstrapper.diactivateDoublePreparingJVM();
            bootstrapper.start();
        }
        catch (Throwable e) {
            if (e instanceof IOException && Objects.nonNull(jvmFolder) && jvmFolder.toString().contains("jvms")) {
                Bootstrapper.fixedOnce(args, jvmFolder);
            }
            e.printStackTrace();
            String message = e.getMessage();
            if (Objects.nonNull(message) && message.contains("GetIpAddrTable")) {
                Alert.showErrorHtml("", langConfiguration.get("addr.table.error"));
                TLauncher.kill();
            }
            U.log("problem with preparing boostrapper");
            TlauncherUtil.showCriticalProblem(e);
        }
    }

    private static void valitdateKB4515384() {
        boolean KB4515384Exists;
        if (launcherConfig.getBoolean("block.updater.message")) {
            return;
        }
        if (!launcherConfig.getBoolean("retest.update")) {
            launcherConfig.set("retest.update", true, true);
            return;
        }
        if (OS.is(OS.WINDOWS) && (KB4515384Exists = OS.executeByTerminal("wmic qfe get HotFixID", 5).contains("KB4515384"))) {
            Bootstrapper.showUpdateWinError();
            Alert.showErrorHtml(langConfiguration.get("warning.KB4515384.problem"), 500);
        }
    }

    private static void validateTempDir() throws IOException {
        block3: {
            try {
                Files.createTempFile("test", "txt", new FileAttribute[0]);
            }
            catch (IOException e) {
                if (!Objects.nonNull(System.getProperty("java.io.tmpdir"))) break block3;
                Path folder = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                if (Files.isRegularFile(folder, new LinkOption[0])) {
                    Files.delete(folder);
                }
                if (Files.exists(folder, new LinkOption[0])) break block3;
                FileUtil.createFolder(folder.toFile());
            }
        }
    }

    private static void fixedOnce(String[] args, File jvmFolder) {
        if (i != 0) {
            return;
        }
        ++i;
        FileUtil.deleteDirectory(jvmFolder);
        Alert.showErrorHtml("", langConfiguration.get("run.again.launcher"));
    }

    private static void validateWorkDir() {
        String minecraftConfigDir = launcherConfig.get("minecraft.gamedir");
        try {
            if (Objects.nonNull(minecraftConfigDir)) {
                FileUtil.makeTemp(new File(minecraftConfigDir, "test.folder.txt"));
            }
        }
        catch (IOException e) {
            U.log(e);
            launcherConfig.set("minecraft.gamedir", null);
        }
    }

    private static File getJVM(boolean properJVM) {
        if (OS.isJava8() && !TlauncherUtil.useX64JavaInsteadX32Java() && TlauncherUtil.hasCorrectJavaFX() && !properJVM) {
            return new File(OS.getJavaPathByHome(false));
        }
        File tlauncherFolder = MinecraftUtil.getSystemRelatedDirectory("tlauncher");
        return TlauncherUtil.getJVMFolder(javaConfig, tlauncherFolder);
    }

    private static void showDiskProblem() {
        String minecraftGamedir = launcherConfig.get("minecraft.gamedir");
        File minecraftFolder = minecraftGamedir == null ? MinecraftUtil.getSystemRelatedDirectory(innerConfig.get("folder")) : new File(minecraftGamedir);
        String url = launcherConfig.isUSSRLocale() ? "http://www.inetkomp.ru/uroki/488-osvobodit-mesto-na-diske-c.html" : "https://www.windowscentral.com/best-7-ways-free-hard-drive-space-windows-10";
        String path = minecraftFolder.toPath().getRoot().toString();
        String message = langConfiguration.get("place.disk.warning", path) + "<br><br>" + langConfiguration.get("alert.start.message", url);
        U.log(message);
        TlauncherUtil.showCriticalProblem(message);
        TLauncher.kill();
    }

    public static JavaProcessLauncher restartLauncher() {
        Bootstrapper.initConfig();
        File directory = new File(".");
        String path = OS.getJavaPathByHome(true);
        JavaProcessLauncher processLauncher = new JavaProcessLauncher(path, new String[0]);
        Bootstrapper.log("choose jvm for restart:" + path);
        String classPath = FileUtil.getRunningJar().getPath();
        processLauncher.directory(directory);
        processLauncher.addCommand("-cp");
        processLauncher.addCommand(classPath + System.getProperty("path.separator"));
        processLauncher.addCommand(innerConfig.get("bootstrapper.class"));
        U.debug(processLauncher);
        return processLauncher;
    }

    private static File getWorkFolder() {
        String minecraftGamedir = launcherConfig.get("minecraft.gamedir");
        return minecraftGamedir == null ? MinecraftUtil.getSystemRelatedDirectory(innerConfig.get("folder")) : new File(minecraftGamedir);
    }

    private static void initConfig() {
        Gson g = new Gson();
        try {
            block6: {
                try {
                    innerConfig = new SimpleConfiguration(Bootstrapper.class.getResourceAsStream("/inner.tlauncher.properties"));
                }
                catch (NullPointerException ex) {
                    String path = FileUtil.getRunningJar().toString();
                    if (!path.contains("!" + File.separator)) break block6;
                    Alert.showError("Error", String.format("Java can't work with path that contains symbol '!', create new local user without characters '!'(use new local user for game) and use path to TLauncher without '!' characters \r\ncurrent: %s\r\n\r\n\u0414\u0436\u0430\u0432\u0430 \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 c \u043f\u0443\u0442\u044f\u043c\u0438 \u0432 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432\u043e\u0441\u043a\u043b\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0437\u043d\u0430\u043a '!' , \u0441\u043e\u0437\u0434\u0430\u0439\u0442\u0435 \u043d\u043e\u0432\u0443\u044e \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c \u0431\u0435\u0437 '!' \u0437\u043d\u0430\u043a\u043e\u0432(\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0435\u0451 \u0434\u043b\u044f \u0438\u0433\u0440\u044b) \u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043f\u0443\u0442\u044c \u043a \u0444\u0430\u0439\u043b\u0443 TLauncher \u0431\u0435\u0437 '!'\r\n \u0442\u0435\u043a\u0443\u0449\u0438\u0439: %s", path, path));
                    System.exit(-2);
                }
            }
            launcherConfig = new SimpleConfiguration(new File(MinecraftUtil.getSystemRelatedDirectory(innerConfig.get("settings.new")).getCanonicalPath()));
            String locale = launcherConfig.get("locale");
            Locale locale2 = Locale.getDefault();
            if (locale != null) {
                locale2 = Configuration.getLocaleOf(locale);
            }
            List<Locale> listLocales = Configuration.getDefaultLocales(innerConfig);
            Locale selected = Configuration.findSuitableLocale(locale2, listLocales);
            langConfiguration = new LangConfiguration(listLocales.toArray(new Locale[0]), selected, innerConfig.get("bootstrapper.language.folder"));
            libraryConfig = g.fromJson((Reader)new InputStreamReader(Bootstrapper.class.getResourceAsStream("/bootstrapper.libraries.json"), Charset.forName("utf-8")), LibraryConfig.class);
            String fileName = "/bootstrapper.jre.json";
            if (launcherConfig.getBoolean("fixed.gpu.jre.error")) {
                fileName = "/bootstrapper.jre_fixed_gpu.json";
            }
            javaConfig = g.fromJson((Reader)new InputStreamReader(Bootstrapper.class.getResourceAsStream(fileName), Charset.forName("utf-8")), JavaConfig.class);
        }
        catch (Throwable e1) {
            TlauncherUtil.showCriticalProblem(e1);
        }
    }

    private static int showQuestion(String title, String messae, String button, String button2) {
        return JOptionPane.showOptionDialog(null, messae, title, 0, 2, null, new Object[]{button, button2}, button2);
    }

    private static boolean checkFreeSpace(long size) {
        String minecraftGamedir = launcherConfig.get("minecraft.gamedir");
        File minecraftFolder = minecraftGamedir == null ? MinecraftUtil.getSystemRelatedDirectory(innerConfig.get("folder")) : new File(minecraftGamedir);
        return FileUtil.checkFreeSpace(minecraftFolder, size);
    }

    private static void log(Object ... s) {
        U.log("[Bootstrapper]", s);
    }

    private JavaProcessLauncher createLauncher(String[] args) {
        Bootstrapper.log("createLauncher");
        String jvm = OS.appendBootstrapperJvm(this.jvmFolder.getPath());
        Bootstrapper.log("choose jvm:" + jvm);
        JavaProcessLauncher processLauncher = new JavaProcessLauncher(jvm, new String[0]);
        processLauncher.directory(directory);
        processLauncher.addCommand("-Xmx" + innerConfig.get("max.memory") + "m");
        processLauncher.addCommand("-Dfile.encoding=UTF8");
        String classPath = FileUtil.getRunningJar().getPath();
        String separator = File.pathSeparator;
        Bootstrapper.log("validate files");
        try {
            classPath = classPath + separator;
            classPath = classPath + StringUtil.convertListToString(separator, this.preparedEnvironmentComponent.getLibrariesForRunning());
        }
        catch (Throwable e) {
            U.log(e);
            StringBuilder builder = new StringBuilder(langConfiguration.get("updater.download.fail"));
            builder.append("<br>");
            builder = new StringBuilder(builder.toString().replace("- problem1", ""));
            TlauncherUtil.showCriticalProblem(builder.toString());
            System.exit(-1);
        }
        Bootstrapper.log("end validated files");
        processLauncher.addCommand("-cp", classPath);
        processLauncher.addCommand(innerConfig.get("main.class"));
        if (args != null && args.length > 0) {
            processLauncher.addCommands(args);
        }
        return processLauncher;
    }

    private void die(int status) {
        Bootstrapper.log("I can be terminated now: " + status);
        if (!this.started && this.process.isRunning()) {
            Bootstrapper.log("...started instance also will be terminated.");
            this.process.stop();
        }
        LogManager.shutdown();
        System.exit(status);
    }

    public void start() throws IOException {
        this.processLauncher = this.createLauncher(this.args);
        this.doubleRunningTimer.cancel();
        Bootstrapper.log("Starting launcher...");
        this.processLauncher.setListener(this.listener);
        this.process = this.processLauncher.start();
    }

    public void setPreparedEnvironmentComponent(PreparedEnvironmentComponent preparedEnvironmentComponent) {
        this.preparedEnvironmentComponent = preparedEnvironmentComponent;
    }

    public void setJVMFolder(File jvmFolder) {
        this.jvmFolder = jvmFolder;
    }

    private void activeDoublePreparingJVM() throws IOException {
        File tlauncherFolder = MinecraftUtil.getSystemRelatedDirectory("tlauncher");
        File f = new File(tlauncherFolder, PROTECTION);
        FileUtil.createFile(f);
        if (f.exists()) {
            FileChannel ch = FileChannel.open(f.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            this.lock = ch.tryLock();
            if (Objects.isNull(this.lock)) {
                LogManager.shutdown();
                System.exit(4);
            }
        }
    }

    private void diactivateDoublePreparingJVM() throws IOException {
        if (Objects.nonNull(this.lock)) {
            this.lock.release();
        }
    }

    private static void showUpdateWinError() {
        boolean ussr = launcherConfig.isUSSRLocale();
        if (ussr) {
            OS.openLink(linkUpdateErrorRu);
        } else {
            OS.openLink(linkUpdateErrorEn);
        }
    }

    static {
        i = 0;
    }

    private class BootstrapperListener
    implements JavaProcessListener {
        private StringBuffer buffer = new StringBuffer();

        private BootstrapperListener() {
        }

        @Override
        public void onJavaProcessLog(JavaProcess jp, String line) {
            U.plog(Character.valueOf('>'), line);
            this.buffer.append(line).append('\n');
            if (line.startsWith("[Loading]")) {
                if (line.length() < "[Loading]".length() + 2) {
                    Bootstrapper.log(new Object[]{"Cannot parse line: content is empty."});
                    return;
                }
                String content = line.substring("[Loading]".length() + 1);
                LoadingStep step = Reflect.parseEnum(LoadingStep.class, content);
                if (step == null) {
                    Bootstrapper.log(new Object[]{"Cannot parse line: cannot parse step"});
                    return;
                }
                if (step.getPercentage() == 100) {
                    Bootstrapper.this.started = true;
                    Bootstrapper.this.die(0);
                }
            }
        }

        @Override
        public void onJavaProcessEnded(JavaProcess jp) {
            int exit = jp.getExitCode();
            if (exit == 1 && Bootstrapper.this.jvmFolder.toString().contains("jvms")) {
                Bootstrapper.fixedOnce(Bootstrapper.this.args, Bootstrapper.this.jvmFolder);
            }
            if (exit == -1073740791) {
                TlauncherUtil.showCriticalProblem(langConfiguration.get("alert.start.message", "https://tlauncher.org/ru/closed-minecraft-1073740791.html"));
                TlauncherUtil.showCriticalProblem(langConfiguration.get("alert.start.message", "https://tlauncher.org/en/closed-minecraft-1073740791.html"));
                Bootstrapper.this.die(exit);
            } else if (exit == -1073740771) {
                Bootstrapper.showUpdateWinError();
                Alert.showWarning("", langConfiguration.get("warning.KB4515384.problem"));
                Bootstrapper.this.die(exit);
            }
            if (exit != 0) {
                TlauncherUtil.showCriticalProblem(this.buffer.toString());
            }
            Bootstrapper.this.die(exit);
        }

        @Override
        public void onJavaProcessError(JavaProcess jp, Throwable e) {
            Bootstrapper.log(new Object[]{e});
        }
    }

    public static enum LoadingStep {
        INITIALIZING(21),
        LOADING_CONFIGURATION(35),
        LOADING_CONSOLE(41),
        LOADING_MANAGERS(51),
        LOADING_WINDOW(62),
        PREPARING_MAINPANE(77),
        POSTINIT_GUI(82),
        REFRESHING_INFO(91),
        SUCCESS(100);

        public static final String LOADING_PREFIX = "[Loading]";
        private final int percentage;

        private LoadingStep(int percentage) {
            this.percentage = percentage;
        }

        public int getPercentage() {
            return this.percentage;
        }
    }
}

