/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.SideNotifier;
import org.tlauncher.tlauncher.ui.TLauncherFrame;
import org.tlauncher.tlauncher.ui.browser.BrowserHolder;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.progress.login.LauncherProgress;
import org.tlauncher.tlauncher.ui.scenes.AccountEditorScene;
import org.tlauncher.tlauncher.ui.scenes.AdditionalHostServerScene;
import org.tlauncher.tlauncher.ui.scenes.CompleteSubEntityScene;
import org.tlauncher.tlauncher.ui.scenes.DefaultScene;
import org.tlauncher.tlauncher.ui.scenes.ModpackEnitityScene;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.scenes.PseudoScene;
import org.tlauncher.tlauncher.ui.scenes.SettingsScene;
import org.tlauncher.tlauncher.ui.scenes.VersionManagerScene;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedLayeredPane;
import org.tlauncher.tlauncher.ui.swing.progress.ProgressBarPanel;
import org.tlauncher.tlauncher.ui.ui.FancyProgressBar;
import org.tlauncher.util.SwingUtil;

public class MainPane
extends ExtendedLayeredPane {
    public static final Dimension SIZE = new Dimension(1050, 655);
    public final BrowserHolder browser;
    public final DefaultScene defaultScene;
    public final VersionManagerScene versionManager;
    public final SettingsScene settingsScene;
    public final ModpackScene modpackScene;
    public final CompleteSubEntityScene completeSubEntityScene;
    public final ModpackEnitityScene modpackEnitityScene;
    public final AdditionalHostServerScene additionalHostServerScene;
    public final SideNotifier notifier;
    public final AccountEditorScene accountEditor;
    private final TLauncherFrame rootFrame;
    private PseudoScene scene;
    private ProgressBarPanel barPanel;

    MainPane(TLauncherFrame frame) {
        super(null);
        this.setPreferredSize(SIZE);
        this.setMaximumSize(SIZE);
        this.rootFrame = frame;
        this.browser = BrowserHolder.getInstance();
        this.browser.setPane(this);
        this.add((Component)this.browser);
        this.notifier = new SideNotifier();
        this.notifier.setLocation(10, 10);
        this.notifier.setSize(32, 32);
        this.add((Component)this.notifier);
        this.defaultScene = new DefaultScene(this);
        this.add((Component)this.defaultScene);
        this.versionManager = new VersionManagerScene(this);
        this.add((Component)this.versionManager);
        this.modpackScene = new ModpackScene(this);
        this.add((Component)this.modpackScene);
        this.completeSubEntityScene = new CompleteSubEntityScene(this);
        this.add((Component)this.completeSubEntityScene);
        this.modpackEnitityScene = new ModpackEnitityScene(this);
        this.add((Component)this.modpackEnitityScene);
        this.additionalHostServerScene = new AdditionalHostServerScene(this);
        this.add((Component)this.additionalHostServerScene);
        LauncherProgress bar = new LauncherProgress();
        bar.setBorder(BorderFactory.createEmptyBorder());
        bar.setUI(new FancyProgressBar(ImageCache.getBufferedImage((String)"login-progress-bar.png")));
        bar.setOpaque(false);
        this.barPanel = new ProgressBarPanel(ImageCache.getNativeIcon((String)"speed-icon.png"), ImageCache.getNativeIcon((String)"files-icon.png"), bar);
        TLauncher.getInstance().getDownloader().addListener(this.barPanel);
        this.add((Component)this.barPanel);
        this.accountEditor = new AccountEditorScene(this);
        this.add((Component)this.accountEditor);
        this.settingsScene = new SettingsScene(this);
        this.add((Component)this.settingsScene);
        this.setScene(this.defaultScene, false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MainPane.this.onResize();
            }
        });
    }

    public PseudoScene getScene() {
        return this.scene;
    }

    public void setScene(PseudoScene scene) {
        this.setScene(scene, true);
    }

    private void setScene(PseudoScene newscene, boolean animate) {
        if (newscene == null) {
            throw new NullPointerException();
        }
        if (newscene.equals(this.scene)) {
            return;
        }
        for (Component comp : this.getComponents()) {
            if (newscene != this.additionalHostServerScene) {
                if (comp.equals(newscene) || !(comp instanceof PseudoScene) || comp == this.defaultScene) continue;
                ((PseudoScene)comp).setShown(false, animate);
                continue;
            }
            if (comp.equals(newscene) || !(comp instanceof PseudoScene)) continue;
            ((PseudoScene)comp).setShown(false, animate);
        }
        this.scene = newscene;
        this.scene.setShown(true);
        this.browser.setBrowserContentShown("scene", this.scene.equals(this.defaultScene));
    }

    public void openDefaultScene() {
        this.setScene(this.defaultScene);
    }

    public TLauncherFrame getRootFrame() {
        return this.rootFrame;
    }

    public ProgressBarPanel getProgress() {
        return this.barPanel;
    }

    @Override
    public void onResize() {
        this.browser.onResize();
        this.barPanel.setBounds(0, this.getHeight() - ProgressBarPanel.SIZE.height - LoginForm.LOGIN_SIZE.height, ProgressBarPanel.SIZE.width, ProgressBarPanel.SIZE.height);
    }

    public Point getLocationOf(Component comp) {
        return SwingUtil.getRelativeLocation(this, comp);
    }

    public void openAccountEditor() {
        this.setScene(this.accountEditor);
    }
}

