/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.accounts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.accounts.UsernameField;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.block.Blocker;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableRadioButton;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.scenes.AccountEditorScene;
import org.tlauncher.tlauncher.ui.swing.CheckBoxListener;
import org.tlauncher.tlauncher.ui.swing.FlexibleEditorPanel;
import org.tlauncher.tlauncher.ui.text.ExtendedPasswordField;

public class AccountEditor
extends CenterPanel {
    private static final String passlock = "passlock";
    private final AccountEditorScene scene;
    public final UsernameField username;
    public final BlockablePasswordField password;
    public final ButtonGroup authGroup;
    public final AuthTypeRadio mojangAuth;
    public final AuthTypeRadio tlauncherAuth;
    public final UpdaterButton save;
    public final LinkedHashMap<Account.AccountType, AuthTypeRadio> radioMap;
    private final Configuration configuration = TLauncher.getInstance().getConfiguration();
    private final FlexibleEditorPanel flex;
    public final EditorCheckBox skinCheckBox;
    public static final Dimension SIZE = new Dimension(214, 171);
    public static final Color FIELD_COLOR = new Color(149, 149, 149);

    public AccountEditor(AccountEditorScene sc, FlexibleEditorPanel flex) {
        super(noInsets);
        this.scene = sc;
        this.flex = flex;
        ActionListener enterHandler = e -> {
            this.defocus();
            this.scene.handler.saveEditor();
        };
        this.username = new UsernameField((CenterPanel)this, UsernameField.UsernameState.EMAIL);
        EmptyBorder empty = new EmptyBorder(0, 9, 0, 0);
        CompoundBorder border = new CompoundBorder(BorderFactory.createLineBorder(FIELD_COLOR, 1), empty);
        this.username.setBorder(border);
        this.username.addActionListener(enterHandler);
        this.username.setForeground(FIELD_COLOR);
        this.password = new BlockablePasswordField();
        this.password.addActionListener(enterHandler);
        this.password.setBorder(border);
        this.password.setEnabled(false);
        this.password.setForeground(FIELD_COLOR);
        this.authGroup = new ButtonGroup();
        this.radioMap = new LinkedHashMap();
        this.mojangAuth = new AuthTypeRadio(Account.AccountType.MOJANG);
        this.mojangAuth.setFont(this.mojangAuth.getFont().deriveFont(1));
        this.tlauncherAuth = new AuthTypeRadio(Account.AccountType.TLAUNCHER);
        this.tlauncherAuth.setFont(this.tlauncherAuth.getFont().deriveFont(1));
        this.save = new UpdaterButton(UpdaterButton.GREEN_COLOR, "account.save");
        this.save.setFont(this.save.getFont().deriveFont(1, 16.0f));
        this.save.setForeground(Color.WHITE);
        this.save.addActionListener(enterHandler);
        this.skinCheckBox = new EditorCheckBox("skin.status.checkbox"){

            @Override
            public void block(Object reason) {
            }

            @Override
            public void unblock(Object reason) {
            }
        };
        this.skinCheckBox.setState(this.configuration.getBoolean("skin.status.checkbox.state"));
        this.skinCheckBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (!AccountEditor.this.skinCheckBox.getState()) {
                        if (Alert.showLocQuestion("skin.status.title", "skin.status.message")) {
                            AccountEditor.this.configuration.set("skin.status.checkbox.state", false, true);
                        } else {
                            AccountEditor.this.skinCheckBox.setState(true);
                        }
                    } else {
                        Alert.showMessage(AccountEditor.this.lang.get("skin.checkbox.switch.on.title"), AccountEditor.this.lang.get("skin.checkbox.switch.on.message"));
                        AccountEditor.this.configuration.set("skin.status.checkbox.state", true, true);
                    }
                }
            }
        });
        this.setPreferredSize(new Dimension(214, 171));
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        UsernameField panel = this.username;
        springLayout.putConstraint("North", (Component)panel, 0, "North", (Component)this);
        springLayout.putConstraint("South", (Component)panel, 20, "North", (Component)panel);
        springLayout.putConstraint("West", (Component)panel, 0, "West", (Component)this);
        springLayout.putConstraint("East", (Component)panel, 214, "West", (Component)this);
        this.add((Component)panel);
        AuthTypeRadio panel_1 = this.tlauncherAuth;
        springLayout.putConstraint("North", (Component)panel_1, 12, "South", (Component)panel);
        springLayout.putConstraint("South", (Component)panel_1, 15, "North", (Component)panel_1);
        springLayout.putConstraint("West", (Component)panel_1, -4, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_1, 8, "East", (Component)panel);
        this.add((Component)panel_1);
        AuthTypeRadio panel_2 = this.mojangAuth;
        springLayout.putConstraint("North", (Component)panel_2, 12, "South", (Component)panel_1);
        springLayout.putConstraint("South", (Component)panel_2, 15, "North", (Component)panel_2);
        springLayout.putConstraint("West", (Component)panel_2, -4, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_2, 0, "East", (Component)panel);
        this.add((Component)panel_2);
        BlockablePasswordField panel_3 = this.password;
        springLayout.putConstraint("North", (Component)panel_3, 12, "South", (Component)panel_2);
        springLayout.putConstraint("South", (Component)panel_3, 19, "North", (Component)panel_3);
        springLayout.putConstraint("West", (Component)panel_3, 0, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_3, 0, "East", (Component)panel);
        this.add((Component)panel_3);
        EditorCheckBox panel_5 = this.skinCheckBox;
        springLayout.putConstraint("North", (Component)panel_5, 12, "South", (Component)panel_3);
        springLayout.putConstraint("South", (Component)panel_5, 15, "North", (Component)panel_5);
        springLayout.putConstraint("West", (Component)panel_5, -4, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_5, 0, "East", (Component)panel);
        this.add((Component)panel_5);
        UpdaterButton panel_4 = this.save;
        springLayout.putConstraint("North", (Component)panel_4, 13, "South", (Component)panel_5);
        springLayout.putConstraint("South", (Component)panel_4, 26, "North", (Component)panel_4);
        springLayout.putConstraint("West", (Component)panel_4, 0, "West", (Component)panel);
        springLayout.putConstraint("East", (Component)panel_4, 0, "East", (Component)panel);
        this.add((Component)panel_4);
    }

    public Account.AccountType getSelectedAccountType() {
        for (Map.Entry<Account.AccountType, AuthTypeRadio> en : this.radioMap.entrySet()) {
            if (!en.getValue().isSelected()) continue;
            return en.getKey();
        }
        return Account.AccountType.TLAUNCHER;
    }

    public void setSelectedAccountType(Account.AccountType type) {
        AuthTypeRadio selectable = this.radioMap.get((Object)type);
        if (selectable != null) {
            selectable.setSelected(true);
        }
    }

    public void fill(Account account) {
        this.setSelectedAccountType(account.getType());
        this.username.setText(account.getUsername());
        this.password.setText(null);
    }

    public void clear() {
        this.setSelectedAccountType(null);
        this.username.setText(null);
        this.password.setText(null);
    }

    public Account get() {
        Account account = new Account();
        account.setUsername(this.username.getValue());
        Account.AccountType type = this.getSelectedAccountType();
        switch (type) {
            case TLAUNCHER: 
            case MOJANG: {
                if (!this.password.hasPassword()) break;
                account.setPassword(new String(this.password.getPassword()));
                break;
            }
        }
        account.setType(type);
        return account;
    }

    @Override
    public void block(Object reason) {
        super.block(reason);
        if (!reason.equals("empty")) {
            // empty if block
        }
    }

    @Override
    public void unblock(Object reason) {
        super.unblock(reason);
        if (!reason.equals("empty")) {
            // empty if block
        }
    }

    public class AuthTypeRadio
    extends LocalizableRadioButton {
        private final Account.AccountType type;

        private AuthTypeRadio(final Account.AccountType type) {
            super("account.auth." + type.toString().toLowerCase());
            AccountEditor.this.radioMap.put(type, this);
            AccountEditor.this.authGroup.add(this);
            this.type = type;
            this.setFocusable(false);
            final boolean free = type == Account.AccountType.FREE;
            this.addItemListener(new CheckBoxListener(){

                @Override
                public void itemStateChanged(boolean newstate) {
                    if (newstate && !AccountEditor.this.password.hasPassword()) {
                        AccountEditor.this.password.setText(null);
                    }
                    if (newstate) {
                        ((AccountEditor)AccountEditor.this).scene.tip.setAccountType(type);
                        if (AuthTypeRadio.this.type == Account.AccountType.TLAUNCHER) {
                            AccountEditor.this.flex.setText(Localizable.get("auth.tip.tlauncher"));
                        } else {
                            AccountEditor.this.flex.setText(Localizable.get("auth.tip.mojang"));
                        }
                    }
                    Blocker.setBlocked(AccountEditor.this.password, AccountEditor.passlock, newstate &= free);
                    AccountEditor.this.username.setState(newstate ? UsernameField.UsernameState.USERNAME : UsernameField.UsernameState.EMAIL_LOGIN);
                    if (AccountEditor.this.mojangAuth.isSelected()) {
                        AccountEditor.this.username.setState(UsernameField.UsernameState.EMAIL);
                    }
                    AccountEditor.this.defocus();
                }
            });
        }

        public Account.AccountType getAccountType() {
            return this.type;
        }
    }

    private class BlockablePasswordField
    extends ExtendedPasswordField
    implements Blockable {
        private BlockablePasswordField() {
        }

        @Override
        public void block(Object reason) {
            this.setEnabled(false);
        }

        @Override
        public void unblock(Object reason) {
            this.setEnabled(true);
        }
    }
}

