/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.browser;

import com.google.common.collect.Maps;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.apache.commons.io.Charsets;
import org.launcher.resource.TlauncherResource;
import org.tlauncher.skin.domain.AdvertisingDTO;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.handlers.ExceptionHandler;
import org.tlauncher.tlauncher.managers.popup.menu.HotServerManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.block.Blocker;
import org.tlauncher.tlauncher.ui.browser.BrowserBridge;
import org.tlauncher.tlauncher.ui.browser.BrowserHolder;
import org.tlauncher.tlauncher.ui.browser.JFXStartPageLoader;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.LocalizableComponent;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;
import org.tlauncher.util.advertising.AdvertisingStatusObserver;
import org.tlauncher.util.lang.PageUtil;
import org.tlauncher.util.statistics.StatisticsUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.html.HTMLAnchorElement;

public class BrowserPanel
extends JFXPanel
implements LocalizableComponent,
Blockable,
AdvertisingStatusObserver {
    private static final long serialVersionUID = 5857121254870623943L;
    private static final boolean freeSurf = false;
    final BrowserHolder holder;
    final BrowserBridge bridge;
    private String failPage;
    private String style;
    private String scripts;
    private String background;
    private String currentDefaultPage;
    private int width;
    private int height;
    private boolean success;
    private int counter;
    private long lastTime;
    private boolean block;
    private volatile boolean specialFlag = false;
    private Group group;
    private WebView view;
    private WebEngine engine;
    private long start;
    private AdvertisingDTO advertisingDTO;
    private final Object advertisingSynchronizedObject = new Object();

    BrowserPanel(BrowserHolder h) throws IOException {
        this.start = System.currentTimeMillis();
        this.holder = h;
        this.bridge = new BrowserBridge(this);
        this.loadResources();
        this.loadPageSync();
        Platform.runLater(() -> {
            Thread.currentThread().setPriority(10);
            BrowserPanel.log("Running in JavaFX Thread");
            this.prepareFX();
            this.initBrowser();
        });
        this.setOpaque(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BrowserPanel.this.width = BrowserPanel.this.holder.getWidth();
                BrowserPanel.this.height = BrowserPanel.this.holder.getHeight();
                Platform.runLater(() -> {
                    if (BrowserPanel.this.view != null) {
                        BrowserPanel.this.view.setPrefSize((double)BrowserPanel.this.width, (double)BrowserPanel.this.height);
                    }
                });
            }
        });
    }

    private static void log(Object ... o) {
        U.log("[Browser]", o);
    }

    private static void engine(WebEngine engine, Object ... o) {
        U.log("[Browser@" + engine.hashCode() + "]", o);
    }

    private static void page(WebEngine engine, String text, String page) {
        BrowserPanel.engine(engine, text + ':', '\"' + page + '\"');
    }

    private synchronized void loadResources() throws IOException {
        BrowserPanel.log("Loading resources...");
        this.failPage = FileUtil.readStream(TlauncherResource.getResource((String)"fail.html").openStream());
        this.style = FileUtil.readStream(TlauncherResource.getResource((String)"style.css").openStream());
        URL jqueryResource = TlauncherResource.getResource((String)"jquery.js");
        URL pageScriptResource = TlauncherResource.getResource((String)"scripts.js");
        this.scripts = FileUtil.readStream(jqueryResource.openStream()) + '\n' + FileUtil.readStream(pageScriptResource.openStream());
        URL backgroundResource = ImageCache.getRes((String)"plains.png");
        BrowserPanel.log("Loading background...");
        Object timeLock = new Object();
        URL url = TlauncherResource.getResource((String)"background.image.base64.txt");
        this.background = FileUtil.readStream(url.openStream(), Charsets.UTF_8.toString());
        BrowserPanel.log("Cleaning up after loading:");
        U.gc();
    }

    synchronized void cleanupResources() {
        this.style = null;
        this.scripts = null;
        this.background = null;
    }

    private void prepareFX() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Call this method from Platform.runLater()");
        }
        BrowserPanel.log("Preparing JavaFX...");
        Thread.currentThread().setUncaughtExceptionHandler(ExceptionHandler.getInstance());
        this.group = new Group();
        Scene scene = new Scene((Parent)this.group);
        this.setScene(scene);
    }

    private synchronized void initBrowser() {
        String location;
        BrowserPanel.log("Initializing...");
        this.group.getChildren().removeAll((Object[])new Node[0]);
        this.view = JFXStartPageLoader.getInstance().getWebView();
        this.view.setContextMenuEnabled(false);
        this.view.setPrefSize((double)this.width, (double)this.height);
        WebEngine currentEngine = this.engine = this.view.getEngine();
        this.engine.setOnAlert(event -> Alert.showMessage(currentEngine.getTitle(), (String)event.getData()));
        this.success = true;
        this.engine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
            try {
                this.onBrowserStateChanged(currentEngine, (Worker.State)newValue);
            }
            catch (Throwable e) {
                BrowserPanel.engine(currentEngine, "State change handle error:", e);
            }
        });
        if (this.engine.getLoadWorker().getState() == Worker.State.FAILED && !this.specialFlag) {
            location = this.engine.getLocation();
            this.failLoad(location);
        }
        if (this.engine.getLoadWorker().getState() == Worker.State.SUCCEEDED && !this.specialFlag) {
            location = this.engine.getLocation();
            this.loadSucceeded(location);
        }
        this.group.getChildren().add((Object)this.view);
    }

    private void failLoad(String location) {
        this.specialFlag = true;
        BrowserPanel.page(this.engine, "Failed to load", location);
        if (!this.success) {
            this.holder.setBrowserShown("error", false);
            return;
        }
        this.success = false;
        this.loadContent(this.failPage);
    }

    private void onBrowserStateChanged(WebEngine engine, Worker.State val) {
        if (this.engine != engine) {
            return;
        }
        if (val == null) {
            throw new NullPointerException("State is NULL!");
        }
        String location = engine.getLocation();
        this.view.setMouseTransparent(true);
        switch (val) {
            case SCHEDULED: {
                BrowserPanel.page(engine, "Loading", location);
                if (location.isEmpty() || location.startsWith(TLauncher.getInstance().getPagePrefix())) break;
                U.debug("[state] scheduled in");
                URI uri = U.makeURI(location);
                if (uri == null) {
                    uri = U.fixInvallidLink(location);
                }
                OS.openLink(uri);
                Platform.runLater(() -> {
                    if (this.block) {
                        return;
                    }
                    this.deniedRedirectedRecursion();
                    String last = this.getLastEntry().getUrl();
                    BrowserPanel.page(this.engine, "Last entry", last);
                    this.loadPage(last);
                });
                break;
            }
            case FAILED: {
                this.failLoad(location);
            }
            case SUCCEEDED: {
                this.loadSucceeded(location);
            }
        }
    }

    private void deniedRedirectedRecursion() {
        if (this.counter > 3) {
            if (new Date().before(new Date(this.lastTime + 2000L))) {
                this.block = true;
            } else if (this.counter > 3) {
                this.counter = 0;
            }
        }
        this.lastTime = System.currentTimeMillis();
        ++this.counter;
    }

    private void loadSucceeded(String location) {
        String locale;
        this.specialFlag = true;
        BrowserPanel.page(this.engine, "Loaded successfully", location);
        this.holder.setBrowserShown("error", true);
        this.success = true;
        Document document = this.engine.getDocument();
        if (document == null) {
            return;
        }
        NodeList bodies = document.getElementsByTagName("body");
        org.w3c.dom.Node body = bodies.item(0);
        if (body == null) {
            BrowserPanel.engine(this.engine, "What the...? Couldn't find <body> element!");
            return;
        }
        if (!location.isEmpty() && !(locale = TLauncher.getInstance().getConfiguration().getLocale().getLanguage()).equals(new Locale("zh").getLanguage())) {
            Element styleElement = document.createElement("style");
            styleElement.setAttribute("type", "text/css");
            styleElement.setTextContent(this.style);
            body.appendChild(styleElement);
        }
        Element scriptElement = document.createElement("script");
        scriptElement.setAttribute("type", "text/javascript");
        scriptElement.setTextContent(this.scripts);
        body.appendChild(scriptElement);
        this.engine.executeScript(this.background);
        JSObject jsobj = (JSObject)this.engine.executeScript("window");
        jsobj.setMember("bridge", this.bridge);
        this.cleanAdvertising(document);
        NodeList linkList = document.getElementsByTagName("a");
        for (int i = 0; i < linkList.getLength(); ++i) {
            org.w3c.dom.Node linkNode = linkList.item(i);
            EventTarget eventTarget = (EventTarget)((Object)linkNode);
            eventTarget.addEventListener("click", evt -> {
                EventTarget target = evt.getCurrentTarget();
                HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                String href = anchorElement.getHref();
                if (href == null || href.isEmpty() || href.startsWith("javascript:")) {
                    return;
                }
                URI uri = U.makeURI(href);
                if (uri == null) {
                    uri = U.fixInvallidLink(href);
                }
                OS.openLink(uri);
                evt.preventDefault();
            }, false);
        }
        Element adyoutube = document.getElementById("adyoutube");
        if (adyoutube != null) {
            ((EventTarget)((Object)adyoutube)).addEventListener("click", evt -> StatisticsUtil.startSending("save/adyoutube", null, Maps.newHashMap()), false);
        }
        this.mixServers(document);
        this.addListensOnMenuServer(document);
        Element serverInfoPage = document.getElementById("server_info_page");
        if (serverInfoPage != null) {
            ((EventTarget)((Object)serverInfoPage)).addEventListener("click", evt -> {
                if (((HotServerManager)TLauncher.getInjector().getInstance(HotServerManager.class)).isReady()) {
                    MainPane mp = TLauncher.getInstance().getFrame().mp;
                    mp.setScene(mp.additionalHostServerScene);
                }
            }, false);
        }
        this.processSidebarMessage(document);
        if (Blocker.isBlocked(this)) {
            this.block(null);
        }
        this.view.setMouseTransparent(false);
    }

    private void processSidebarMessage(Document document) {
        Element sidebarButton = document.getElementById("sidebar_1_button");
        Configuration configuration = TLauncher.getInstance().getConfiguration();
        if (sidebarButton != null) {
            Element el = document.getElementById("sidebar_1");
            if (configuration.getBoolean("main.cross.close")) {
                if (el != null) {
                    this.removeChilds(el);
                }
            } else {
                ((EventTarget)((Object)sidebarButton)).addEventListener("click", evt -> {
                    if (el != null) {
                        this.removeChilds(el);
                        configuration.set("main.cross.close", (Object)true);
                    }
                }, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAdvertising(Document document) {
        Object object = this.advertisingSynchronizedObject;
        synchronized (object) {
            if (this.advertisingDTO == null) {
                try {
                    BrowserPanel.log("fx thread has waited status of ad");
                    this.advertisingSynchronizedObject.wait();
                    BrowserPanel.log("fx thread continuing work");
                }
                catch (InterruptedException e) {
                    BrowserPanel.log(String.format("got status of advertising: %s", this.advertisingDTO));
                }
            }
        }
        if (this.advertisingDTO.isInfoServerAdvertising()) {
            this.removeNode("advertising_block", document);
        }
        if (this.advertisingDTO.isCenterAdvertising()) {
            this.removeNode("adnew", document);
        }
        if (this.advertisingDTO.isVideoAdvertising()) {
            this.removeNode("adyoutube", document);
        }
    }

    private void removeNode(String name, Document document) {
        Element node = document.getElementById(name);
        if (node != null) {
            node.getParentNode().removeChild(node);
        }
    }

    private void removeChilds(org.w3c.dom.Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }

    private void mixServers(Document document) {
        Element node = document.getElementById("advertising_servers");
        if (node == null) {
            return;
        }
        NodeList list = node.getChildNodes();
        if (list == null || list.getLength() < 2) {
            return;
        }
        org.w3c.dom.Node element = list.item(1);
        NodeList listRowServer = element.getChildNodes();
        ArrayList<org.w3c.dom.Node> listOld = new ArrayList<org.w3c.dom.Node>();
        for (int i = 0; i < listRowServer.getLength(); ++i) {
            org.w3c.dom.Node el = listRowServer.item(i);
            listOld.add(el);
        }
        this.removeChilds(element);
        Random random = new Random();
        while (!listOld.isEmpty()) {
            int index = random.nextInt(listOld.size());
            element.appendChild((org.w3c.dom.Node)listOld.remove(index));
        }
    }

    private void addListensOnMenuServer(Document doc) {
        BrowserPanel.log("add listens into server_choose");
        NodeList list = doc.getElementsByTagName("server");
        for (int i = 0; i < list.getLength(); ++i) {
            ((EventTarget)((Object)list.item(i))).addEventListener("mouseover", evt -> ((HotServerManager)TLauncher.getInjector().getInstance(HotServerManager.class)).processingEvent(this.extractServer(evt)), false);
        }
        BrowserPanel.log("finished listens into server_choose");
    }

    private WebHistory.Entry getLastEntry() {
        WebHistory hist = this.engine.getHistory();
        return (WebHistory.Entry)hist.getEntries().get(hist.getCurrentIndex());
    }

    private String extractServer(Event evt) {
        org.w3c.dom.Node node = (org.w3c.dom.Node)((Object)evt.getCurrentTarget());
        NamedNodeMap map = node.getAttributes();
        if (map == null || map.getLength() < 2) {
            BrowserPanel.log("map=" + map + "or map.getLength() <3");
            return "";
        }
        org.w3c.dom.Node idServer = map.item(1);
        if (idServer != null) {
            if (idServer.getNodeValue() != null && !idServer.getNodeValue().isEmpty()) {
                if (evt instanceof MouseEvent) {
                    return idServer.getNodeValue();
                }
                BrowserPanel.log("problems with your browser");
            } else {
                BrowserPanel.log("idServer is null or empty");
            }
        } else {
            BrowserPanel.log("error the node doesn't have childNodes " + node.toString());
        }
        return null;
    }

    private void loadPage(String url) {
        U.debug("load started after init object = " + (System.currentTimeMillis() - this.start) / 1000L);
        BrowserPanel.engine(this.engine, "Trying to load URL: \"" + url + "\"");
        this.engine.load(url);
    }

    private void loadContent(String content) {
        this.engine.loadContent(content);
    }

    void execute(String script) {
        try {
            this.engine.executeScript(script);
        }
        catch (Exception e) {
            U.log("Hidden JS exception:", e);
        }
    }

    @Override
    public void block(Object reason) {
        Platform.runLater(() -> this.execute("page.visibility.hide();"));
    }

    @Override
    public void unblock(Object reason) {
        Platform.runLater(() -> this.execute("page.visibility.show();"));
    }

    @Override
    public void updateLocale() {
        String oldDefaultPage = this.currentDefaultPage;
        this.currentDefaultPage = PageUtil.buildPagePath();
        if (oldDefaultPage == null || oldDefaultPage.equals(this.currentDefaultPage)) {
            return;
        }
        Platform.runLater(() -> this.loadPage(this.currentDefaultPage));
    }

    private void loadPageSync() {
        String oldDefaultPage = this.currentDefaultPage;
        this.currentDefaultPage = PageUtil.buildPagePath();
        if (oldDefaultPage == null || oldDefaultPage.equals(this.currentDefaultPage)) {
            return;
        }
        this.loadPage(this.currentDefaultPage);
    }

    public void setAdvertising(AdvertisingDTO dto) {
        this.advertisingDTO = dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advertisingReceived(AdvertisingDTO advertisingDTO) {
        Object object = this.advertisingSynchronizedObject;
        synchronized (object) {
            this.advertisingDTO = advertisingDTO;
            this.advertisingSynchronizedObject.notify();
        }
    }
}

