/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.button;

import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.BorderFactory;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.LocalizableButton;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;

public class RoundImageButton
extends LocalizableButton {
    private BufferedImage current;

    public RoundImageButton(final BufferedImage image, final BufferedImage mouseUnderImage) {
        super("");
        this.current = image;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                RoundImageButton.this.current = mouseUnderImage;
                RoundImageButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RoundImageButton.this.current = image;
                RoundImageButton.this.repaint();
            }
        });
    }

    public RoundImageButton(String image, String mouseUnderUrl) {
        this(ImageCache.loadImage((URL)U.makeURL(image), (boolean)true), ImageCache.loadImage((URL)U.makeURL(mouseUnderUrl), (boolean)true));
    }

    public Dimension getImageSize() {
        return new Dimension(this.current.getWidth(), this.current.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.drawImage(this.current, 0, 0, null);
        String text = this.getText();
        if (!Strings.isNullOrEmpty((String)text)) {
            SwingUtil.paintText((Graphics2D)g, this, text);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.current.getWidth(), this.current.getHeight());
    }
}

